/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.tools.ScreenUnitHelper;

public class OcrLipDetectMaskView
extends View {
    private Paint mPaint;
    private Bitmap maskView;
    private Bitmap scanView;
    private PorterDuff.Mode mode = PorterDuff.Mode.SRC_OVER;
    private Rect scanViewRect;
    private int screenWidthInPixel;
    private int screenHeightInPixel;
    private int startScanX;
    private int startScanY;
    private int endScanX;
    private int endScanY;
    private int scanViewWidth;
    private ValueAnimator scanAnimation;
    private int scanY;

    public OcrLipDetectMaskView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mPaint = new Paint(3);
        this.maskView = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.background_bg);
        this.scanView = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.scan01);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.screenWidthInPixel = displayMetrics.widthPixels;
        this.screenHeightInPixel = displayMetrics.heightPixels;
        int middle = this.screenWidthInPixel / 2;
        int scanViewLengthHalf = this.screenWidthInPixel * 250 / 1125;
        this.startScanX = middle - scanViewLengthHalf;
        this.endScanX = middle + scanViewLengthHalf;
        this.startScanY = this.screenHeightInPixel * 500 / 1809;
        this.endScanY = this.screenHeightInPixel * 1100 / 1809;
        this.scanViewWidth = ScreenUnitHelper.dip2px(context, 3.0f);
        this.scanViewRect = new Rect(this.startScanX, this.startScanY, this.endScanX, this.startScanY + this.scanViewWidth);
    }

    public void startAnimation() {
        this.initAnimation();
    }

    public void stopAnimation() {
        if (this.scanAnimation != null) {
            this.scanAnimation.cancel();
        }
        this.scanAnimation = null;
    }

    private void initAnimation() {
        this.scanAnimation = ValueAnimator.ofInt((int[])new int[]{this.startScanY, this.endScanY});
        this.scanAnimation.setDuration(3000L);
        this.scanAnimation.setRepeatCount(-1);
        this.scanAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object value = animation.getAnimatedValue();
                if (value != null) {
                    OcrLipDetectMaskView.this.scanY = (Integer)animation.getAnimatedValue();
                }
                OcrLipDetectMaskView.this.invalidate();
            }
        });
        this.scanAnimation.start();
    }

    protected void onDraw(Canvas canvas) {
        if (this.scanAnimation != null) {
            canvas.drawBitmap(this.scanView, null, new Rect(this.startScanX, this.scanY, this.endScanX, this.scanY + this.scanViewWidth), this.mPaint);
        }
        canvas.drawBitmap(this.maskView, null, new Rect(0, 0, this.screenWidthInPixel, this.screenHeightInPixel), this.mPaint);
        this.mPaint.setXfermode(null);
        super.onDraw(canvas);
    }
}

