/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.animation.LinearInterpolator;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.tools.ScreenUnitHelper;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeMaskView
extends View {
    private Logger logger = LoggerFactory.getLogger(IdCardRecognizeMaskView.class);
    private Paint mPaint;
    private Paint mAreaPaint;
    private Bitmap nationMaskView;
    private Bitmap faceMaskView;
    private Bitmap scanView;
    private Xfermode xfermode;
    private PorterDuff.Mode mode = PorterDuff.Mode.SRC_OVER;
    private RectF maskViewRect;
    private Path maskPath;
    private RectF scanViewRect;
    private int screenWidthInPixel;
    private int screenHeightInPixel;
    private float screenDensity;
    private float rate;
    private float moveTopRate;
    private Context context;
    private String faceImagePath;
    private String backImagePath;
    private Paint textPaint;
    private BitmapFactory.Options fileSizeOptions;
    private int pattern;
    private int scanViewWidth;
    private ValueAnimator scanAnimation;
    private float scanX;
    private boolean showTip;

    public IdCardRecognizeMaskView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.mPaint = new Paint(3);
        this.faceMaskView = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.bg01);
        this.nationMaskView = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.bg02);
        this.scanView = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.scan01);
        this.xfermode = new PorterDuffXfermode(this.mode);
        this.textPaint = new Paint();
        this.textPaint.setTextSize((float)ScreenUnitHelper.dip2px(context, 16.0f));
        this.textPaint.setColor(-1);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.screenWidthInPixel = displayMetrics.widthPixels;
        this.screenHeightInPixel = displayMetrics.heightPixels;
        this.screenDensity = displayMetrics.density;
        QCloudLogger.debug((Logger)this.logger, (String)"screenWidthInPixel = {}, screenHeightInPixel = {}", (Object[])new Object[]{this.screenWidthInPixel, this.screenHeightInPixel});
        this.mAreaPaint = new Paint(1);
        this.mAreaPaint.setColor(-16777216);
        this.mAreaPaint.setStyle(Paint.Style.FILL);
        this.mAreaPaint.setAlpha(180);
        this.maskPath = new Path();
        this.fileSizeOptions = new BitmapFactory.Options();
        this.fileSizeOptions.inJustDecodeBounds = true;
        this.pattern = 0;
        this.changePattern(this.pattern);
    }

    public void changePattern(int pattern) {
        this.pattern = pattern;
        if (pattern == 0 || pattern == 1 || pattern == 2 || pattern == 3) {
            this.rate = 5.0f;
            this.moveTopRate = 0.0f;
            this.mAreaPaint.setAlpha(180);
        } else {
            this.rate = 4.0f;
            this.moveTopRate = 0.1f;
            this.mAreaPaint.setAlpha(255);
        }
        this.showTip = true;
        int moveTop = (int)(this.moveTopRate * (float)this.screenHeightInPixel);
        int maskViewHeight = (int)((float)this.screenHeightInPixel * this.rate / (this.rate + 2.0f));
        int maskViewWidth = maskViewHeight * 1121 / 707;
        int maskViewX = (this.screenWidthInPixel - maskViewWidth) / 2;
        int maskViewY = (this.screenHeightInPixel - maskViewHeight) / 2;
        this.maskViewRect = new RectF((float)maskViewX, (float)(maskViewY - moveTop), (float)(maskViewX + maskViewWidth), (float)(maskViewY + maskViewHeight - moveTop));
        QCloudLogger.debug((Logger)this.logger, (String)"left = {}, top = {}, right = {}, bottom = {}", (Object[])new Object[]{Float.valueOf(this.maskViewRect.left), Float.valueOf(this.maskViewRect.top), Float.valueOf(this.maskViewRect.right), Float.valueOf(this.maskViewRect.bottom)});
        this.scanViewWidth = ScreenUnitHelper.dip2px(this.context, 3.0f);
        this.scanViewRect = new RectF((float)maskViewX, (float)maskViewY, (float)(maskViewX + this.scanViewWidth), (float)(maskViewY + maskViewHeight));
        QCloudLogger.debug((Logger)this.logger, (String)"left = {}, top = {}, right = {}, bottom = {}", (Object[])new Object[]{Float.valueOf(this.scanViewRect.left), Float.valueOf(this.scanViewRect.top), Float.valueOf(this.scanViewRect.right), Float.valueOf(this.scanViewRect.bottom)});
        this.maskPath.reset();
        this.maskPath.addRoundRect(this.maskViewRect, this.maskViewRect.height() / 15.0f, this.maskViewRect.height() / 15.0f, Path.Direction.CCW);
        this.maskPath.addRect(0.0f, 0.0f, (float)this.screenWidthInPixel, (float)this.screenHeightInPixel, Path.Direction.CW);
        if (pattern == 0 || pattern == 1) {
            this.startAnimation();
        } else {
            this.stopAnimation();
            this.scanAnimation = null;
        }
        this.invalidate();
    }

    public RectF getMaskViewRect() {
        return this.maskViewRect;
    }

    public void startAnimation() {
        this.initAnimation();
    }

    public void stopAnimation() {
        if (this.scanAnimation != null) {
            this.scanAnimation.cancel();
        }
    }

    public void removeScanAnimation() {
        this.stopAnimation();
        this.scanAnimation = null;
        this.invalidate();
    }

    public void setShowTip(boolean showTip) {
        this.showTip = showTip;
        this.invalidate();
    }

    public void resize(float rate) {
        this.rate = rate;
        int maskViewHeight = (int)((float)this.screenHeightInPixel * rate / (rate + 2.0f));
        int maskViewWidth = maskViewHeight * 1121 / 707;
        int maskViewX = (this.screenWidthInPixel - maskViewWidth) / 2;
        int maskViewY = (this.screenHeightInPixel - maskViewHeight) / 2;
        this.maskViewRect = new RectF((float)maskViewX, (float)maskViewY, (float)(maskViewX + maskViewWidth), (float)(maskViewY + maskViewHeight));
        this.invalidate();
    }

    private void initAnimation() {
        this.scanAnimation = ValueAnimator.ofFloat((float[])new float[]{this.maskViewRect.left, this.maskViewRect.right});
        Log.i((String)"TAG", (String)("left = " + this.maskViewRect.left + ", top = " + this.maskViewRect.top + ", right = " + this.maskViewRect.right + ", botton = " + this.maskViewRect.bottom));
        this.scanAnimation.setDuration(3000L);
        PropertyValuesHolder[] propertyValuesHolders = this.scanAnimation.getValues();
        Log.i((String)"TAG", (String)("length is " + propertyValuesHolders.length));
        for (int i = 0; i < propertyValuesHolders.length; ++i) {
            Log.i((String)"ATG", (String)("value is =" + propertyValuesHolders[i]));
        }
        this.scanAnimation.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.scanAnimation.setRepeatCount(-1);
        this.scanAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object value = animation.getAnimatedValue();
                if (value != null) {
                    IdCardRecognizeMaskView.this.scanX = ((Float)value).floatValue();
                }
                IdCardRecognizeMaskView.this.invalidate();
            }
        });
        this.scanAnimation.start();
        this.showTip = true;
    }

    public void setBackImagePath(String backImagePath) {
        this.backImagePath = backImagePath;
    }

    public void setFaceImagePath(String faceImagePath) {
        this.faceImagePath = faceImagePath;
    }

    protected void onDraw(Canvas canvas) {
        if (this.scanAnimation != null) {
            canvas.drawBitmap(this.scanView, null, new RectF(this.scanX, this.maskViewRect.top, this.scanX + (float)this.scanViewWidth, this.maskViewRect.bottom), this.mPaint);
        }
        if ((this.pattern == 1 || this.pattern == 0) && this.showTip) {
            canvas.drawText(this.getResources().getString(R.string.auto_recognize), this.maskViewRect.centerX() - (float)(ScreenUnitHelper.dip2px(this.context, 16.0f) * 3), this.maskViewRect.bottom - (float)ScreenUnitHelper.dip2px(this.context, 18.0f), this.textPaint);
        } else if ((this.pattern == 2 || this.pattern == 3) && this.showTip) {
            canvas.drawText(this.getResources().getString(R.string.you_are_using_take_photo_mode), this.maskViewRect.centerX() - (float)(ScreenUnitHelper.dip2px(this.context, 16.0f) * 5), this.maskViewRect.bottom - (float)ScreenUnitHelper.dip2px(this.context, 18.0f), this.textPaint);
        }
        canvas.drawPath(this.maskPath, this.mAreaPaint);
        if (this.pattern == 0 || this.pattern == 2) {
            canvas.drawBitmap(this.faceMaskView, null, this.maskViewRect, this.mPaint);
        } else if (this.pattern == 1 || this.pattern == 3) {
            canvas.drawBitmap(this.nationMaskView, null, this.maskViewRect, this.mPaint);
        }
        if (this.pattern == 4 && this.faceImagePath != null) {
            BitmapFactory.decodeFile((String)this.faceImagePath, (BitmapFactory.Options)this.fileSizeOptions);
            int bitmapWidth = this.fileSizeOptions.outWidth;
            int realBitmapWidth = (int)Math.min((float)bitmapWidth, this.getResources().getDimension(R.dimen.max_id_card_recognize_success_width));
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = (int)Math.round(1.0 * (double)bitmapWidth / (double)realBitmapWidth);
            Bitmap image = BitmapFactory.decodeFile((String)this.faceImagePath, (BitmapFactory.Options)options);
            canvas.drawBitmap(image, null, this.maskViewRect, this.mPaint);
        } else if (this.pattern == 5 && this.backImagePath != null) {
            BitmapFactory.decodeFile((String)this.backImagePath, (BitmapFactory.Options)this.fileSizeOptions);
            int bitmapWidth = this.fileSizeOptions.outWidth;
            int realBitmapWidth = (int)Math.min((float)bitmapWidth, this.getResources().getDimension(R.dimen.max_id_card_recognize_success_width));
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = (int)Math.round(1.0 * (double)bitmapWidth / (double)realBitmapWidth);
            Bitmap image = BitmapFactory.decodeFile((String)this.backImagePath, (BitmapFactory.Options)options);
            canvas.drawBitmap(image, null, this.maskViewRect, this.mPaint);
        }
        this.mPaint.setXfermode(null);
        super.onDraw(canvas);
    }
}

