/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.controler;

import android.hardware.Camera;
import com.tencent.qcloud.facein.common.LocalPathHelper;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudPictureCamera;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeRequest;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeResult;
import com.tencent.qcloud.facein.tools.FileTools;
import com.tencent.qcloud.facein.tools.ImageTools;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeHelper {
    private final Logger logger = LoggerFactory.getLogger(IdCardRecognizeHelper.class);
    private QCloudPictureCamera camera;
    private int rotation;
    private FaceInService service;
    private QCloudCameraPreview preview;
    private volatile byte[] frameData;
    private boolean isFaceSide;
    private boolean isScanMode;
    private boolean isFirstScan;
    private Camera.Parameters parameters;

    public IdCardRecognizeHelper(FaceInService service, QCloudCameraPreview preview, int rotation) {
        this.service = service;
        this.preview = preview;
        this.rotation = rotation;
        this.isFaceSide = true;
        this.isScanMode = true;
        this.isFirstScan = true;
        this.initCamera();
    }

    private void initCamera() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                IdCardRecognizeHelper.this.camera = new QCloudPictureCamera(IdCardRecognizeHelper.this.rotation, 0);
                IdCardRecognizeHelper.this.camera.setFocusMode("continuous-picture");
                int prepareTimes = 10;
                while (prepareTimes >= 0) {
                    if (IdCardRecognizeHelper.this.camera.prepare(IdCardRecognizeHelper.this.preview)) {
                        QCloudLogger.info((Logger)IdCardRecognizeHelper.this.logger, (String)"camera prepare success");
                        break;
                    }
                    --prepareTimes;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    QCloudLogger.debug((Logger)IdCardRecognizeHelper.this.logger, (String)"camera is prepare failed, try again.");
                }
                if (prepareTimes < 0) {
                    QCloudLogger.error((Logger)IdCardRecognizeHelper.this.logger, (String)"camera prepare failed");
                }
                IdCardRecognizeHelper.this.camera.setPreviewCallback(new Camera.PreviewCallback(){

                    public void onPreviewFrame(byte[] bytes, Camera camera) {
                        IdCardRecognizeHelper.access$402(IdCardRecognizeHelper.this, bytes);
                    }
                });
                if (IdCardRecognizeHelper.this.camera.getCamera() != null) {
                    IdCardRecognizeHelper.this.parameters = IdCardRecognizeHelper.this.camera.getCamera().getParameters();
                }
                IdCardRecognizeHelper.this.camera.start();
            }
        }).start();
    }

    public void scan(final boolean isFaceSide, final long requestSeq, final IdCardRecognizeListener recognizeListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (IdCardRecognizeHelper.this.isFirstScan) {
                    IdCardRecognizeHelper.this.isFirstScan = false;
                    while (IdCardRecognizeHelper.this.frameData == null) {
                    }
                }
                File jpegFile = IdCardRecognizeHelper.this.scanFile(IdCardRecognizeHelper.this.frameData);
                IdCardRecognizeHelper.this.sendRequest(true, isFaceSide, requestSeq, jpegFile, recognizeListener);
            }
        }).start();
    }

    public void take(final boolean isFaceSide, final long requestSeq, final IdCardRecognizeListener recognizeListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] data = IdCardRecognizeHelper.this.camera.takePicture();
                File jpegFile = IdCardRecognizeHelper.this.takeFile(data);
                IdCardRecognizeHelper.this.sendRequest(false, isFaceSide, requestSeq, jpegFile, recognizeListener);
            }
        }).start();
    }

    private void sendRequest(boolean isScanMode, boolean isFaceSide, long requestSeq, File jpegFile, IdCardRecognizeListener recognizeListener) {
        if (jpegFile == null || !jpegFile.exists()) {
            QCloudLogger.info((Logger)this.logger, (String)"recognize file is null.");
            if (recognizeListener != null) {
                recognizeListener.onFailed(null, isScanMode, isFaceSide, null);
            }
            return;
        }
        QCloudLogger.info((Logger)this.logger, (String)"send a network request.");
        IdCardRecognizeRequest ocrIdCardRequest = new IdCardRecognizeRequest(FaceInConfig.getBucket(), jpegFile.getAbsolutePath(), isFaceSide);
        ocrIdCardRequest.setRequestSeq(requestSeq);
        IdCardRecognizeResult recognizeResult = null;
        QCloudException exception = null;
        try {
            recognizeResult = this.service.idCardRecognize(ocrIdCardRequest);
        }
        catch (QCloudException e) {
            e.printStackTrace();
            QCloudLogger.debug((Logger)this.logger, (String)"face in saas exception");
            exception = e;
        }
        if (recognizeResult != null && recognizeResult.isSuccess(0.7f, 10, isFaceSide)) {
            QCloudLogger.info((Logger)this.logger, (String)"recognize request success");
            recognizeListener.onSuccess(ocrIdCardRequest, isScanMode, isFaceSide, recognizeResult, jpegFile.getAbsolutePath());
        } else {
            QCloudLogger.info((Logger)this.logger, (String)"recognize request failed");
            if (exception != null) {
                QCloudLogger.debug((Logger)this.logger, (String)exception.getMessage());
            }
            recognizeListener.onFailed(ocrIdCardRequest, isScanMode, isFaceSide, exception);
        }
    }

    public synchronized void release() {
        this.camera.setPreviewCallback(null);
        this.camera.stop();
        this.camera.release();
        QCloudLogger.info((Logger)this.logger, (String)"camera is released");
    }

    public boolean isCameraStarted() {
        if (this.camera == null) {
            return false;
        }
        if (this.camera.isStarted()) {
            return true;
        }
        return this.camera.start();
    }

    public File scanFile(byte[] data) {
        Camera.Size size;
        if (data == null) {
            return null;
        }
        Object outStream = null;
        FileTools.createDir();
        File jpegFile = new File(LocalPathHelper.getLocalImagePath(), System.currentTimeMillis() + ".jpg");
        if (this.parameters != null && (size = this.parameters.getPreviewSize()) != null) {
            ImageTools.NV21ToFile(data, size.width, size.height, jpegFile);
        }
        return jpegFile;
    }

    public File takeFile(byte[] data) {
        File jpegFile = null;
        FileTools.createDir();
        if (data != null && (jpegFile = new File(LocalPathHelper.getLocalImagePath(), System.currentTimeMillis() + ".jpg")) != null) {
            ImageTools.toJpegFile(data, jpegFile);
        }
        return jpegFile;
    }

    static /* synthetic */ byte[] access$402(IdCardRecognizeHelper x0, byte[] x1) {
        x0.frameData = x1;
        return x1;
    }

    public static interface IdCardRecognizeListener {
        public void onSuccess(IdCardRecognizeRequest var1, boolean var2, boolean var3, IdCardRecognizeResult var4, String var5);

        public void onFailed(IdCardRecognizeRequest var1, boolean var2, boolean var3, QCloudException var4);
    }
}

