/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.activity;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ImageButton;
import android.widget.TextView;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.activity.TakePhotoCompareEntryActivity;
import com.tencent.qcloud.facein.activity.TakePhotoCompareFailedActivity;
import com.tencent.qcloud.facein.activity.TakePhotoCompareSuccessActivity;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.controler.ImageTakePhotoThread;
import com.tencent.qcloud.facein.dialog.FaceInDialogs;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardCompareResult;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.facein.user.FaceInFailedType;
import com.tencent.qcloud.facein.user.FaceInModelType;
import com.tencent.qcloud.facein.user.FaceInResultListener;
import com.tencent.qcloud.facein.user.IdCardInfo;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TakePhotoCompareActivity
extends AppCompatActivity {
    private Logger logger = LoggerFactory.getLogger(TakePhotoCompareActivity.class);
    private ImageButton takePhoto;
    private FaceInService saasService;
    private ImageTakePhotoThread takePhotoThread;
    private QCloudCameraPreview cameraPreview;
    final String userName = UserIdCardInfo.name;
    final String userId = UserIdCardInfo.id;
    private Dialog recognizingDialog;
    private TextView back;
    private int rotation;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_take_photo_compare);
        this.takePhoto = (ImageButton)this.findViewById(R.id.take_photo);
        this.saasService = new FaceInService((Context)this, FaceInConfig.getFaceInServiceConfig(), FaceInConfig.getCredentialProvider());
        this.cameraPreview = (QCloudCameraPreview)this.findViewById(R.id.preview);
        this.takePhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakePhotoCompareActivity.this.recognizingDialog = FaceInDialogs.simpleProgressDialog((Context)TakePhotoCompareActivity.this);
                TakePhotoCompareActivity.this.recognizingDialog.show();
                if (TakePhotoCompareActivity.this.takePhotoThread != null) {
                    TakePhotoCompareActivity.this.takePhotoThread.takePhoto();
                }
            }
        });
        this.back = (TextView)this.findViewById(R.id.back);
        this.back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TakePhotoCompareActivity.this.onBack();
            }
        });
        this.rotation = this.getWindowManager().getDefaultDisplay().getRotation();
    }

    protected void onResume() {
        super.onResume();
        this.takePhotoThread = new ImageTakePhotoThread(this.saasService, this.cameraPreview, this.rotation, this.userName, this.userId);
        this.takePhotoThread.setTakePhotoListener(new ImageTakePhotoThread.ImageTakePhotoListener(){

            @Override
            public void onSuccess(ImageTakePhotoThread scanThread, IdCardCompareResult result) {
                if (TakePhotoCompareActivity.this.recognizingDialog != null) {
                    TakePhotoCompareActivity.this.recognizingDialog.dismiss();
                }
                QCloudLogger.info((Logger)TakePhotoCompareActivity.this.logger, (String)"verify success");
                float similarity = 0.0f;
                if (result != null) {
                    similarity = result.getSimilarity();
                }
                TakePhotoCompareActivity.this.sendSuccessMessage(similarity);
                Intent intent = new Intent((Context)TakePhotoCompareActivity.this, TakePhotoCompareSuccessActivity.class);
                TakePhotoCompareActivity.this.startActivity(intent);
                TakePhotoCompareActivity.this.finish();
            }

            @Override
            public void onFailed(ImageTakePhotoThread scanThread, FaceInSaasException code) {
                QCloudLogger.info((Logger)TakePhotoCompareActivity.this.logger, (String)"verify failed");
                if (TakePhotoCompareActivity.this.recognizingDialog != null) {
                    TakePhotoCompareActivity.this.recognizingDialog.dismiss();
                }
                TakePhotoCompareActivity.this.sendFailedMessage();
                Intent intent = new Intent((Context)TakePhotoCompareActivity.this, TakePhotoCompareFailedActivity.class);
                TakePhotoCompareActivity.this.startActivity(intent);
                TakePhotoCompareActivity.this.finish();
            }
        });
        this.takePhotoThread.start();
    }

    private void sendSuccessMessage(float similarity) {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IdCardInfo idCardInfo = new IdCardInfo(UserIdCardInfo.name, UserIdCardInfo.id, UserIdCardInfo.addr, UserIdCardInfo.authority, UserIdCardInfo.date);
                    resultListener.onSuccess(FaceInModelType.OCR_ID_CARD_IMAGE_COMPARE, idCardInfo);
                }
            }).start();
        }
    }

    private void sendFailedMessage() {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IdCardInfo idCardInfo = new IdCardInfo(UserIdCardInfo.name, UserIdCardInfo.id, UserIdCardInfo.addr, UserIdCardInfo.authority, UserIdCardInfo.date);
                    resultListener.onFailed(FaceInModelType.OCR_ID_CARD_IMAGE_COMPARE, FaceInFailedType.FACE_IN_SIMILARITY_LOW);
                }
            }).start();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.takePhotoThread != null) {
            this.takePhotoThread.stop();
        }
    }

    private void onBack() {
        Intent intent = new Intent((Context)this, TakePhotoCompareEntryActivity.class);
        this.startActivity(intent);
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.onBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

