/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.content.Context;
import android.graphics.BitmapFactory;
import android.graphics.RectF;
import android.os.Handler;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.tools.ScreenUnitHelper;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeTopView
extends RelativeLayout {
    private Logger logger = LoggerFactory.getLogger(IdCardRecognizeTopView.class);
    private int pattern;
    private View topView;
    private TextView backTextView;
    private ImageView faceSideTipImage;
    private ImageView nationSideTipImage;
    private ImageView faceYesIcon;
    private ImageView backYesIcon;
    private Button bottomLeftButton;
    private Button bottomRightButton;
    private TextView tipText;
    private ImageView tipView;
    private ImageButton takePhotoButton;
    private TextView clickableTakePhotoText;
    private TextView clickableScanText;
    private View takePhotoVertical;
    private View scanVertical;
    private final float tipImageRate;
    private RectF centerRect;
    private Context context;
    private Handler mainHandler;
    private BitmapFactory.Options fileSizeOptions;
    private String faceSideImagePath;
    private String backSideImagePath;

    public IdCardRecognizeTopView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.topView = layoutInflater.inflate(R.layout.view_id_card_recognize_top, (ViewGroup)this);
        this.backTextView = (TextView)this.topView.findViewById(R.id.back_clickable_tv);
        this.faceSideTipImage = (ImageView)this.topView.findViewById(R.id.face_side_tip_image);
        this.nationSideTipImage = (ImageView)this.topView.findViewById(R.id.nation_side_tip_image);
        this.faceYesIcon = (ImageView)this.findViewById(R.id.face_yes_icon);
        this.backYesIcon = (ImageView)this.findViewById(R.id.back_yes_icon);
        this.bottomLeftButton = (Button)this.topView.findViewById(R.id.re_take_photo_bt);
        this.bottomRightButton = (Button)this.topView.findViewById(R.id.take_back_side_bt);
        this.tipText = (TextView)this.topView.findViewById(R.id.face_side_photo_tip_text);
        this.tipView = (ImageView)this.topView.findViewById(R.id.tip_yes_icon);
        this.takePhotoButton = (ImageButton)this.topView.findViewById(R.id.take_photo_bt);
        this.clickableTakePhotoText = (TextView)this.topView.findViewById(R.id.clickable_photo_text);
        this.clickableScanText = (TextView)this.topView.findViewById(R.id.clickable_scan_text);
        this.takePhotoVertical = this.topView.findViewById(R.id.take_photo_vertical);
        this.scanVertical = this.topView.findViewById(R.id.scan_vertical);
        this.tipImageRate = 0.6666667f;
        this.fileSizeOptions = new BitmapFactory.Options();
        this.fileSizeOptions.inJustDecodeBounds = true;
    }

    public void prepare(RectF centerRect) {
        this.centerRect = centerRect;
        this.pattern = 0;
        this.initTipImages();
        this.initTipText();
        this.initClickableText();
        this.changePattern(this.pattern);
    }

    private void backTextView(int pattern) {
        if (pattern == 0 || pattern == 1 || pattern == 2 || pattern == 3) {
            this.backTextView.setVisibility(0);
        } else {
            this.backTextView.setVisibility(8);
        }
    }

    public void setFaceSideImagePath(String faceSideImagePath) {
        this.faceSideImagePath = faceSideImagePath;
    }

    public void setBackSideImagePath(String backSideImagePath) {
        this.backSideImagePath = backSideImagePath;
    }

    private void tipImages(int pattern) {
        BitmapFactory.Options options;
        int realBitmapWidth;
        int bitmapWidth;
        if (pattern == 0 || pattern == 2) {
            this.faceSideTipImage.setImageResource(R.mipmap.zm_ic);
            this.nationSideTipImage.setImageResource(R.mipmap.fm01_ic);
            this.faceSideImagePath = null;
        } else if (pattern == 1 || pattern == 3) {
            this.nationSideTipImage.setImageResource(R.mipmap.fm02_ic);
            this.backSideImagePath = null;
        }
        this.faceYesIcon.setVisibility(8);
        this.backYesIcon.setVisibility(8);
        int shouldWidth = ScreenUnitHelper.dip2px(this.context, this.getResources().getDimension(R.dimen.id_card_recognize_tip_image__width));
        if (this.faceSideImagePath != null) {
            BitmapFactory.decodeFile((String)this.faceSideImagePath, (BitmapFactory.Options)this.fileSizeOptions);
            bitmapWidth = this.fileSizeOptions.outWidth;
            realBitmapWidth = Math.min(bitmapWidth, shouldWidth);
            options = new BitmapFactory.Options();
            options.inSampleSize = (int)Math.round(1.0 * (double)bitmapWidth / (double)realBitmapWidth);
            this.faceSideTipImage.setImageBitmap(BitmapFactory.decodeFile((String)this.faceSideImagePath, (BitmapFactory.Options)options));
            this.faceYesIcon.setVisibility(0);
        }
        if (this.backSideImagePath != null) {
            BitmapFactory.decodeFile((String)this.backSideImagePath, (BitmapFactory.Options)this.fileSizeOptions);
            bitmapWidth = this.fileSizeOptions.outWidth;
            realBitmapWidth = Math.min(bitmapWidth, shouldWidth);
            options = new BitmapFactory.Options();
            options.inSampleSize = (int)Math.round(1.0 * (double)bitmapWidth / (double)realBitmapWidth);
            this.nationSideTipImage.setImageBitmap(BitmapFactory.decodeFile((String)this.backSideImagePath, (BitmapFactory.Options)options));
            this.backYesIcon.setVisibility(0);
        }
    }

    public void setMainHandler(Handler mainHandler) {
        this.mainHandler = mainHandler;
    }

    private void bottomButton(int pattern) {
        if (pattern == 0 || pattern == 1 || pattern == 2 || pattern == 3) {
            this.bottomLeftButton.setVisibility(8);
            this.bottomRightButton.setVisibility(8);
        } else {
            this.bottomLeftButton.setVisibility(0);
            this.bottomRightButton.setVisibility(0);
            if (pattern == 4) {
                this.bottomRightButton.setText((CharSequence)this.getResources().getString(R.string.take_photo_back_side));
            } else {
                this.bottomRightButton.setText((CharSequence)this.getResources().getString(R.string.next_step_for_id_message_confirm));
            }
        }
    }

    private void tipText(int pattern) {
        String tips = null;
        SpannableString spannableString = null;
        switch (pattern) {
            case 0: {
                tips = this.getResources().getString(R.string.idcard_recognize_face_side_tips);
                this.tipView.setVisibility(8);
                break;
            }
            case 1: {
                tips = this.getResources().getString(R.string.idcard_recognize_back_side_tips);
                this.tipView.setVisibility(8);
                break;
            }
            case 2: {
                tips = this.getResources().getString(R.string.idcard_recognize_face_side_photo_tips);
                this.tipView.setVisibility(8);
                break;
            }
            case 3: {
                tips = this.getResources().getString(R.string.idcard_recognize_back_side_photo_tips);
                this.tipView.setVisibility(8);
                break;
            }
            case 4: {
                tips = this.getResources().getString(R.string.face_side_success);
                this.tipView.setVisibility(0);
                break;
            }
            case 5: {
                tips = this.getResources().getString(R.string.idcard_recognize_success);
                this.tipView.setVisibility(0);
            }
        }
        spannableString = new SpannableString(tips);
        if (pattern <= 3) {
            int beginIndex = tips.lastIndexOf("\u9762") - 1;
            if (beginIndex >= 0) {
                spannableString.setSpan((Object)new ForegroundColorSpan(-65536), beginIndex, beginIndex + 2, 17);
            }
            this.tipText.setText((CharSequence)spannableString);
        } else {
            this.tipText.setText((CharSequence)tips);
        }
    }

    private void takePhotoButton(int pattern) {
        if (pattern == 2 || pattern == 3) {
            this.takePhotoButton.setVisibility(0);
        } else {
            this.takePhotoButton.setVisibility(8);
        }
    }

    private void clickableText(int pattern) {
        switch (pattern) {
            case 0: 
            case 1: {
                this.clickableScanText.setVisibility(0);
                this.clickableTakePhotoText.setVisibility(0);
                this.clickableScanText.setTextColor(-16776961);
                this.clickableTakePhotoText.setTextColor(-1);
                this.scanVertical.setVisibility(0);
                this.takePhotoVertical.setVisibility(4);
                break;
            }
            case 2: 
            case 3: {
                this.clickableScanText.setVisibility(0);
                this.clickableTakePhotoText.setVisibility(0);
                this.clickableScanText.setTextColor(-1);
                this.clickableTakePhotoText.setTextColor(-16776961);
                this.scanVertical.setVisibility(4);
                this.takePhotoVertical.setVisibility(0);
                break;
            }
            case 4: 
            case 5: {
                this.clickableScanText.setVisibility(8);
                this.clickableTakePhotoText.setVisibility(8);
                this.scanVertical.setVisibility(8);
                this.takePhotoVertical.setVisibility(8);
            }
        }
    }

    private void initClickableText() {
    }

    private void initTipText() {
    }

    private void initTipImages() {
        QCloudLogger.debug((Logger)this.logger, (String)"top = {}. left = {}", (Object[])new Object[]{Float.valueOf(this.centerRect.top), Float.valueOf(this.centerRect.left)});
        this.faceSideTipImage.setAdjustViewBounds(true);
        this.nationSideTipImage.setAdjustViewBounds(true);
        int tipImageMaxWidth = (int)(this.centerRect.left * this.tipImageRate);
        int tipImageMaxHeight = (int)((float)tipImageMaxWidth * this.centerRect.height() / this.centerRect.width());
        this.faceSideTipImage.setMaxWidth(tipImageMaxWidth);
        this.faceSideTipImage.setMaxHeight(tipImageMaxHeight);
        this.nationSideTipImage.setMaxWidth(tipImageMaxWidth);
        this.nationSideTipImage.setMaxHeight(tipImageMaxHeight);
        LinearLayout tipImages = (LinearLayout)this.topView.findViewById(R.id.tip_image);
        RelativeLayout.LayoutParams tipImagesLayoutParams = (RelativeLayout.LayoutParams)tipImages.getLayoutParams();
        QCloudLogger.debug((Logger)this.logger, (String)"max width = {}, max height = {}", (Object[])new Object[]{tipImageMaxWidth, tipImageMaxHeight});
        int tipImageMarginLeft = (int)((this.centerRect.left - (float)tipImageMaxWidth) / 4.0f);
        tipImagesLayoutParams.setMargins(tipImageMarginLeft, 0, 0, 0);
        QCloudLogger.debug((Logger)this.logger, (String)("margin left = " + tipImageMarginLeft));
    }

    public void onRightBottomButtonClicked(View.OnClickListener onClickListener) {
        this.bottomRightButton.setOnClickListener(onClickListener);
    }

    public void onLeftBottomButtonClicked(View.OnClickListener onClickListener) {
        this.bottomLeftButton.setOnClickListener(onClickListener);
    }

    public void changePattern(int pattern) {
        this.backTextView(pattern);
        this.tipImages(pattern);
        this.bottomButton(pattern);
        this.tipText(pattern);
        this.takePhotoButton(pattern);
        this.clickableText(pattern);
    }

    public void onTakePhotoClicked(View.OnClickListener onClickListener) {
        this.takePhotoButton.setOnClickListener(onClickListener);
    }

    public void onBackTextViewClicked(View.OnClickListener onClickListener) {
        this.backTextView.setOnClickListener(onClickListener);
    }

    public void onTakePhotoTextClicked(View.OnClickListener onClickListener) {
        this.clickableTakePhotoText.setOnClickListener(onClickListener);
    }

    public void onScanTextClicked(View.OnClickListener onClickListener) {
        this.clickableScanText.setOnClickListener(onClickListener);
    }
}

