/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.tools;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTools {
    private static Logger logger = LoggerFactory.getLogger(ImageTools.class);

    public static void toJpegFile(byte[] jpegData, File jpegFile) {
        if (!jpegFile.exists()) {
            try {
                jpegFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileOutputStream fos = new FileOutputStream(jpegFile);
            fos.write(jpegData);
            fos.close();
        }
        catch (FileNotFoundException e) {
            QCloudLogger.warn((Logger)logger, (String)"File not found {}.", (Object[])new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            QCloudLogger.warn((Logger)logger, (String)"Error accessing file {}.", (Object[])new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void NV21ToFile(byte[] data, int width, int height, File jpegFile) {
        if (!jpegFile.exists()) {
            try {
                jpegFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            YuvImage yuvimage = new YuvImage(data, 17, width, height, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            yuvimage.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)baos);
            FileOutputStream outStream = new FileOutputStream(jpegFile);
            try {
                baos.writeTo(outStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            outStream.close();
            QCloudLogger.debug((Logger)logger, (String)"onPreviewFrame - wrote bytes: {}", (Object[])new Object[]{data.length});
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int[] rotateImageByExif(String photoPath, int rotation) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)photoPath, (BitmapFactory.Options)options);
        int[] imageSize = new int[2];
        if (options.outWidth > options.outHeight) {
            int maxHeight = 1000;
            BitmapFactory.Options downOptions = new BitmapFactory.Options();
            downOptions.inSampleSize = (int)Math.round(1.0 * (double)options.outWidth / (double)maxHeight);
            downOptions.inPreferredConfig = Bitmap.Config.RGB_565;
            Bitmap bitmap = BitmapFactory.decodeFile((String)photoPath, (BitmapFactory.Options)downOptions);
            Bitmap newBitmap = ImageTools.rotateImage(bitmap, rotation);
            FileOutputStream outStream = new FileOutputStream(photoPath);
            newBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outStream);
            imageSize[0] = newBitmap.getWidth();
            imageSize[1] = newBitmap.getHeight();
            if (outStream != null) {
                outStream.close();
            }
        }
        return imageSize;
    }

    private static Bitmap rotateImage(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

