/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.pass.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.tencent.qcloud.facein.pass.model.FaceInResult;
import com.tencent.qcloud.facein.pass.model.assist.IdCardMessage;
import com.tencent.qcloud.facein.pass.model.assist.IdCardResult;
import com.tencent.qcloud.facein.pass.tools.ConfidenceSuccessTools;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeResult
extends FaceInResult {
    private Logger logger = LoggerFactory.getLogger(IdCardRecognizeResult.class);
    @JSONField(name="result_list")
    private List<IdCardResult> idCardResults;

    public List<IdCardResult> getIdCardResults() {
        return this.idCardResults;
    }

    public void setIdCardResults(List<IdCardResult> idCardResults) {
        this.idCardResults = idCardResults;
    }

    public boolean isSuccess(float rate, int confidence, boolean faceSide) {
        QCloudLogger.debug((Logger)this.logger, (String)this.toString());
        if (this.getCode() != 0 || this.idCardResults == null) {
            return false;
        }
        if (faceSide) {
            for (IdCardResult faceSideResult : this.idCardResults) {
                IdCardMessage faceSideMessage;
                if (faceSideResult == null || (faceSideMessage = faceSideResult.getIdCardMessage()) == null || !ConfidenceSuccessTools.success(faceSideMessage.getNameConfidence(), rate, confidence) || !ConfidenceSuccessTools.success(faceSideMessage.getIdConfidence(), rate, confidence) || !ConfidenceSuccessTools.success(faceSideMessage.getAddressConfidence(), rate, confidence)) continue;
                return true;
            }
        } else {
            for (IdCardResult nationSideResult : this.idCardResults) {
                IdCardMessage nationSideMessage;
                if (nationSideResult == null || (nationSideMessage = nationSideResult.getIdCardMessage()) == null || !ConfidenceSuccessTools.success(nationSideMessage.getAuthorityConfidence(), rate, confidence) || !ConfidenceSuccessTools.success(nationSideMessage.getValidDateConfidence(), rate, confidence)) continue;
                return true;
            }
        }
        return false;
    }

    public IdCardMessage getIdCardMessage() {
        IdCardResult faceSideResult;
        if (this.idCardResults != null && (faceSideResult = this.idCardResults.get(0)) != null) {
            return faceSideResult.getIdCardMessage();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder desc = new StringBuilder(super.toString());
        if (this.idCardResults != null) {
            desc.append(this.idCardResults.toString());
        }
        return desc.toString();
    }
}

