/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.hardware;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import com.tencent.qcloud.facein.hardware.QCloudCamera;
import com.tencent.qcloud.facein.hardware.QCloudCameraHelper;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudCameraStatus;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QCloudVideoCamera
extends QCloudCamera {
    private Logger logger = LoggerFactory.getLogger(QCloudVideoCamera.class);
    private MediaRecorder mediaRecorder;
    private String videoFilePath;

    public QCloudVideoCamera(int rotation, int facing) {
        super(rotation, facing);
        this.setFocusMode("continuous-video");
    }

    @Override
    protected boolean _prepare(QCloudCameraPreview cameraPreview) {
        return true;
    }

    @Override
    protected boolean _start() {
        return true;
    }

    public synchronized boolean startRecord(String videoFilePath) {
        Camera.Size optimalSize;
        if (this.cameraStatus != QCloudCameraStatus.STARTED && this.cameraStatus != QCloudCameraStatus.RESUME) {
            QCloudLogger.warn((Logger)this.logger, (String)"can't take picture in this status, you should start camera first");
            return false;
        }
        this.videoFilePath = videoFilePath;
        this.mediaRecorder = new MediaRecorder();
        Camera.Parameters parameters = this.camera.getParameters();
        this.camera.unlock();
        this.mediaRecorder.setCamera(this.camera);
        this.mediaRecorder.setAudioSource(0);
        this.mediaRecorder.setVideoSource(1);
        int hint = QCloudCameraHelper.getCameraDisplayOrientation(this.windowRotation, this.facing);
        QCloudLogger.debug((Logger)this.logger, (String)"hint is {}", (Object[])new Object[]{hint});
        this.mediaRecorder.setOrientationHint(360 - hint);
        CamcorderProfile profile = CamcorderProfile.get((int)this.facing, (int)4);
        if (parameters != null && this.getPreviewSize() != null && (optimalSize = QCloudCameraHelper.getOptimalVideoSize(parameters.getSupportedVideoSizes(), parameters.getSupportedPreviewSizes(), this.getPreviewSize().width, this.getPreviewSize().height)) != null) {
            profile.videoFrameWidth = optimalSize.width;
            profile.videoFrameHeight = optimalSize.height;
        }
        this.mediaRecorder.setProfile(profile);
        this.mediaRecorder.setOutputFile(videoFilePath);
        try {
            this.mediaRecorder.prepare();
        }
        catch (IllegalStateException e) {
            QCloudLogger.debug((Logger)this.logger, (String)("IllegalStateException preparing MediaRecorder: " + e.getMessage()));
            this.releaseMediaRecorder();
            return false;
        }
        catch (IOException e) {
            QCloudLogger.debug((Logger)this.logger, (String)("IOException preparing MediaRecorder: " + e.getMessage()));
            this.releaseMediaRecorder();
            return false;
        }
        this.mediaRecorder.start();
        this.cameraStatus = QCloudCameraStatus.RECORDING;
        return true;
    }

    @Override
    protected boolean _stop() {
        return true;
    }

    public synchronized boolean stopRecord() {
        if (this.cameraStatus != QCloudCameraStatus.RECORDING) {
            QCloudLogger.warn((Logger)this.logger, (String)"can't stop record, you should start record first");
            return false;
        }
        if (this.mediaRecorder != null) {
            try {
                this.mediaRecorder.stop();
            }
            catch (RuntimeException r) {
                r.printStackTrace();
            }
        }
        this.cameraStatus = QCloudCameraStatus.PAUSED;
        return true;
    }

    @Override
    protected boolean _release() {
        return this.releaseMediaRecorder();
    }

    private synchronized boolean releaseMediaRecorder() {
        if (this.mediaRecorder != null) {
            this.mediaRecorder.reset();
            this.mediaRecorder.release();
            this.mediaRecorder = null;
            this.camera.lock();
        }
        return true;
    }
}

