/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.controler;

import com.tencent.qcloud.facein.common.LocalPathHelper;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.exception.FaceInSaasExceptionType;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudPictureCamera;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardCompareRequest;
import com.tencent.qcloud.facein.pass.model.IdCardCompareResult;
import com.tencent.qcloud.facein.tools.ImageTools;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageTakePhotoThread
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(ImageTakePhotoThread.class);
    private QCloudPictureCamera camera;
    private final FaceInService saasService;
    private volatile boolean stopped;
    private final QCloudCameraPreview preview;
    private ImageTakePhotoListener takePhotoListener;
    private byte[] data;
    private String userName;
    private String userNumber;
    private int rotation;
    private CountDownLatch blocker;

    public ImageTakePhotoThread(FaceInService saasService, QCloudCameraPreview preview, int rotation, String userName, String userNumber) {
        this.rotation = rotation;
        this.saasService = saasService;
        this.preview = preview;
        this.userName = userName;
        this.userNumber = userNumber;
        this.stopped = false;
    }

    public void setTakePhotoListener(ImageTakePhotoListener takePhotoListener) {
        this.takePhotoListener = takePhotoListener;
    }

    public void start() {
        this.stopped = false;
        new Thread(this).start();
    }

    public void takePhoto() {
        this.unlock();
    }

    public void stop() {
        this.stopped = true;
        this.unlock();
        this.saasService.cancelAll();
    }

    @Override
    public void run() {
        this.camera = new QCloudPictureCamera(this.rotation, 1);
        this.camera.setFocusMode("continuous-picture");
        if (this.camera.prepare(this.preview) && this.camera.start()) {
            QCloudLogger.debug((Logger)this.logger, (String)"camera prepare success.");
            this.lock();
            this.await();
            if (!this.stopped) {
                QCloudLogger.debug((Logger)this.logger, (String)"start take photo");
                this.data = this.camera.takePicture();
                if (this.data != null) {
                    File jpegFile = this.byte2File(this.data);
                    IdCardCompareRequest idCardCompareRequest = new IdCardCompareRequest(FaceInConfig.getBucket(), UserIdCardInfo.name, UserIdCardInfo.id, jpegFile.getAbsolutePath());
                    IdCardCompareResult idCardCompareResult = null;
                    try {
                        idCardCompareResult = this.saasService.idCardCompare(idCardCompareRequest);
                    }
                    catch (QCloudException e) {
                        e.printStackTrace();
                    }
                    if (idCardCompareResult != null && idCardCompareResult.isSuccess(FaceInConfig.getIdCardPersonCompareConfidence())) {
                        this.takePhotoListener.onSuccess(this, idCardCompareResult);
                    } else {
                        this.takePhotoListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.ID_CARD_COMPARE_CLIENT_FAILED));
                    }
                }
            } else {
                QCloudLogger.info((Logger)this.logger, (String)"has stopped, and no need to take photo.");
            }
        } else {
            QCloudLogger.error((Logger)this.logger, (String)"Camera prepare failed");
        }
        QCloudLogger.info((Logger)this.logger, (String)"take photo finished");
        this.camera.stop();
        this.camera.release();
    }

    private File byte2File(byte[] data) {
        File jpegFile = null;
        if (data != null && (jpegFile = new File(LocalPathHelper.getLocalImagePath(), System.currentTimeMillis() + ".jpg")) != null) {
            ImageTools.toJpegFile(data, jpegFile);
        }
        return jpegFile;
    }

    private void lock() {
        if (this.blocker == null || this.blocker.getCount() <= 0L) {
            this.blocker = new CountDownLatch(1);
        }
    }

    private void await() {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            try {
                this.blocker.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void unlock() {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            this.blocker.countDown();
        }
    }

    public static interface ImageTakePhotoListener {
        public void onSuccess(ImageTakePhotoThread var1, IdCardCompareResult var2);

        public void onFailed(ImageTakePhotoThread var1, FaceInSaasException var2);
    }
}

