/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtulivecheck;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StatisticsUtils {
    public static String getDeviceUid(Context aContext) {
        boolean bWithMac;
        String strDeviceId = StatisticsUtils.getIMEI(aContext.getApplicationContext());
        String strMacAddr = StatisticsUtils.getMacAddr(aContext.getApplicationContext());
        boolean bl = bWithMac = !TextUtils.isEmpty((CharSequence)strMacAddr);
        if (bWithMac) {
            strMacAddr = strMacAddr.replaceAll(":", "");
        }
        String strUid = StatisticsUtils.encryptUid(strDeviceId + (bWithMac ? strMacAddr : ""));
        return StatisticsUtils.toMD5(strUid);
    }

    public static String getMacAddr(Context aContext) {
        WifiInfo pWifiInfo;
        if (aContext == null) {
            return null;
        }
        String strMacAddr = null;
        WifiManager pWifiMan = (WifiManager)aContext.getApplicationContext().getSystemService("wifi");
        if (pWifiMan != null && (pWifiInfo = pWifiMan.getConnectionInfo()) != null) {
            strMacAddr = pWifiInfo.getMacAddress();
        }
        return strMacAddr;
    }

    public static String getIMEI(Context aContext) {
        TelephonyManager pManager;
        String strDeviceId = Settings.Secure.getString((ContentResolver)aContext.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)strDeviceId) && (pManager = (TelephonyManager)aContext.getApplicationContext().getSystemService("phone")) != null) {
            strDeviceId = pManager.getDeviceId();
        }
        return strDeviceId;
    }

    public static String toMD5(String strVal) {
        if (TextUtils.isEmpty((CharSequence)strVal)) {
            return "";
        }
        String strResult = "";
        try {
            MessageDigest pDigest = MessageDigest.getInstance("MD5");
            pDigest.reset();
            pDigest.update(strVal.getBytes());
            BigInteger hash = new BigInteger(1, pDigest.digest());
            strResult = hash.toString(16);
            while (strResult.length() < 32) {
                strResult = "0" + strResult;
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            strResult = "";
        }
        return strResult;
    }

    private static char getChar(byte aByte, int nPos) {
        return (char)(aByte - StatisticsUtils.getOffset(nPos & 1));
    }

    private static byte getOffset(int nVal) {
        byte nByte = (byte)(0 == nVal ? 65 : 97);
        return nByte;
    }

    private static String encryptUid(String strUid) {
        if (TextUtils.isEmpty((CharSequence)strUid)) {
            return "";
        }
        StringBuilder pBuilder = new StringBuilder();
        int nLength = strUid.length();
        for (int nIdx = 0; nIdx < nLength; ++nIdx) {
            char nChar = strUid.charAt(nIdx);
            pBuilder.append(nChar + nChar % nLength);
        }
        pBuilder.reverse();
        return pBuilder.toString();
    }

    private StatisticsUtils() {
    }
}

