/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.content.Context;
import android.graphics.Color;
import android.os.Handler;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberMarqueeMaskView
extends AppCompatTextView {
    private Logger logger = LoggerFactory.getLogger(NumberMarqueeMaskView.class);
    private char[] friends;
    private int interval;
    private Timer timer;
    private int count;
    private Handler mainHandler;
    private boolean hasStarted;
    int spaceInterval = 0;
    private Context context;
    String message = "";
    private MarqueeFinishListener finishListener;

    public NumberMarqueeMaskView(Context context, AttributeSet attrs, int value, Handler handler) {
        super(context, attrs);
        this.context = context;
        this.hasStarted = false;
        this.interval = 1000;
        this.initFriends(value, 4);
        this.mainHandler = handler;
        this.setText(this.getResources().getString(R.string.three_second_afer));
        this.setVisibility(8);
        this.count = 0;
    }

    public void start() {
        if (this.hasStarted) {
            return;
        }
        this.hasStarted = true;
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                NumberMarqueeMaskView.this.setVisibility(0);
                NumberMarqueeMaskView.this.setTextSize(30.0f);
                NumberMarqueeMaskView.this.setTextColor(Color.argb((int)255, (int)153, (int)204, (int)0));
            }
        });
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (NumberMarqueeMaskView.this.getCount() <= 7) {
                    NumberMarqueeMaskView.this.marqueeStep();
                    NumberMarqueeMaskView.this.addCount();
                    QCloudLogger.debug((Logger)NumberMarqueeMaskView.this.logger, (String)"run task");
                } else {
                    QCloudLogger.debug((Logger)NumberMarqueeMaskView.this.logger, (String)"schedule task is stop");
                    NumberMarqueeMaskView.this.timer.cancel();
                }
            }
        };
        this.timer = new Timer();
        this.timer.schedule(task, 0L, (long)this.interval);
    }

    private void marqueeStep() {
        if (this.finishListener != null) {
            this.finishListener.onFinish(this, this.count);
        }
        QCloudLogger.debug((Logger)this.logger, (String)"marquee step count = {}", (Object[])new Object[]{this.count});
        switch (this.getCount()) {
            case 0: {
                this.message = this.getResources().getString(R.string.three_second_afer);
                break;
            }
            case 1: {
                this.message = this.getResources().getString(R.string.two_second_after);
                break;
            }
            case 2: {
                this.message = this.getResources().getString(R.string.one_second_after);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NumberMarqueeMaskView.this.setTextSize(50.0f);
                    }
                });
                this.message = String.valueOf(this.friends[this.getCount() - 3]);
                break;
            }
            case 7: {
                this.message = "";
            }
        }
        QCloudLogger.debug((Logger)this.logger, (String)"message is {}", (Object[])new Object[]{this.message});
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                NumberMarqueeMaskView.this.setText(NumberMarqueeMaskView.this.message);
            }
        });
    }

    private void initFriends(int value, int number) {
        if (number <= 0) {
            this.friends = new char[0];
            return;
        }
        this.friends = new char[number];
        for (int i = 0; i < number; ++i) {
            this.friends[number - i - 1] = (char)(value % 10 + 48);
            value /= 10;
        }
        QCloudLogger.debug((Logger)this.logger, (String)"friends is {}", (Object[])new Object[]{String.valueOf(this.friends)});
    }

    public void setFinishListener(MarqueeFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    private synchronized int getCount() {
        return this.count;
    }

    private synchronized void addCount() {
        ++this.count;
    }

    public static interface MarqueeFinishListener {
        public void onFinish(NumberMarqueeMaskView var1, int var2);
    }
}

