/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.controler;

import android.content.Context;
import android.hardware.Camera;
import android.hardware.SensorManager;
import android.media.FaceDetector;
import android.os.Handler;
import android.util.Log;
import com.tencent.qcloud.facein.common.LocalPathHelper;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.exception.FaceInSaasExceptionType;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudVideoCamera;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.GetLipRequest;
import com.tencent.qcloud.facein.pass.model.GetLipResult;
import com.tencent.qcloud.facein.pass.model.VideoRecognizeRequest;
import com.tencent.qcloud.facein.pass.model.VideoRecognizeResult;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.youtulivecheck.YoutuLiveCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrLipDetectThread
implements Runnable,
Camera.PreviewCallback {
    private Logger logger = LoggerFactory.getLogger(OcrLipDetectThread.class);
    private QCloudVideoCamera videoCamera;
    private final QCloudCameraPreview preview;
    private YoutuLiveCheck.FaceStatus faceStatus;
    private YoutuLiveCheck liveCheck;
    private double angle = 0.0;
    private byte[] frameData = null;
    private final FaceInService saasService;
    private FaceDetector faceDetector;
    private boolean hasDetectFace;
    private volatile boolean stopped;
    private OcrLipDetectListener detectListener;
    private Handler mainHandler;
    private String lipString;
    private String videoPath;
    private int rotation;
    private Context context;
    private int detectFrameCount;
    private CountDownLatch blocker;
    private Timer timer;

    public OcrLipDetectThread(Context context, SensorManager sensorManager, FaceInService saasService, QCloudCameraPreview preview, int rotation, Handler handler) {
        this.context = context;
        this.saasService = saasService;
        this.preview = preview;
        this.rotation = rotation;
        this.mainHandler = handler;
        this.stopped = false;
        this.hasDetectFace = false;
        this.detectFrameCount = 0;
    }

    public void setDetectListener(OcrLipDetectListener detectListener) {
        this.detectListener = detectListener;
    }

    public void start() {
        this.stopped = false;
        this.hasDetectFace = false;
        new Thread(this).start();
    }

    public void stop() {
        this.stopped = true;
        this.unlock();
        this.saasService.cancelAll();
    }

    @Override
    public void run() {
        this.videoCamera = new QCloudVideoCamera(this.rotation, 1);
        this.videoCamera.setFocusMode("continuous-picture");
        this.liveCheck = YoutuLiveCheck.getInstance();
        this.liveCheck.init(this.context, "huotidetect_CloudImage.licence", 0, true);
        this.initModel();
        this.liveCheck.DoDetectionInit();
        if (this.videoCamera.prepare(this.preview) && this.videoCamera.setPreviewCallback(this) && this.videoCamera.start()) {
            QCloudLogger.info((Logger)this.logger, (String)"camera prepare success");
            QCloudLogger.info((Logger)this.logger, (String)"start face detect.");
            this.StartDetection();
            this.lock();
            QCloudLogger.debug((Logger)this.logger, (String)"waiting for face.");
            this.await();
            if (!this.stopped) {
                QCloudLogger.debug((Logger)this.logger, (String)"has detect face");
                if (this.detectListener != null) {
                    this.detectListener.onDetectFace(this);
                }
                GetLipRequest getLipRequest = new GetLipRequest(FaceInConfig.getBucket());
                GetLipResult getLipResult = null;
                try {
                    getLipResult = this.saasService.getLip(getLipRequest);
                }
                catch (QCloudException e) {
                    e.printStackTrace();
                    this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.OCR_GET_LIP_CLIENT_FAILED));
                }
                if (getLipResult != null && getLipResult.isSuccess()) {
                    this.detectListener.onGetLip(this, getLipResult.getValidateData());
                    this.lipString = getLipResult.getValidateData();
                } else {
                    this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.OCR_GET_LIP_CLIENT_FAILED));
                }
                QCloudLogger.debug((Logger)this.logger, (String)"lip string is {}", (Object[])new Object[]{this.lipString});
                if (getLipResult != null && getLipResult.isSuccess()) {
                    this.lock();
                    this.await(2000L);
                    if (!this.stopped) {
                        this.videoPath = LocalPathHelper.getLocalVideoPath() + System.currentTimeMillis() + ".mp4";
                        try {
                            this.videoCamera.startRecord(this.videoPath);
                        }
                        catch (RuntimeException e) {
                            e.printStackTrace();
                            this.stopped = true;
                        }
                        if (!this.stopped) {
                            this.lock();
                            this.await(5000L);
                            this.videoCamera.stopRecord();
                        } else {
                            this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.OCR_VIDEO_RECOGNIZE_CLIENT_FAILED));
                        }
                        if (!this.stopped) {
                            this.detectListener.onFinishRecord(this);
                            VideoRecognizeRequest videoIdCardIdentityRequest = new VideoRecognizeRequest(FaceInConfig.getBucket(), this.lipString, this.videoPath, UserIdCardInfo.name, UserIdCardInfo.id);
                            VideoRecognizeResult videoRecognizeResult = null;
                            try {
                                videoRecognizeResult = this.saasService.videoRecognize(videoIdCardIdentityRequest);
                            }
                            catch (QCloudException e) {
                                e.printStackTrace();
                            }
                            if (videoRecognizeResult != null) {
                                QCloudLogger.debug((Logger)this.logger, (String)videoRecognizeResult.toString());
                            }
                            if (videoRecognizeResult != null && videoRecognizeResult.isSuccess(FaceInConfig.getLipVideoPersonCompareConfidence())) {
                                this.detectListener.onSuccess(this, videoRecognizeResult);
                            } else {
                                this.detectListener.onFailed(this, new FaceInSaasException(FaceInSaasExceptionType.OCR_VIDEO_RECOGNIZE_CLIENT_FAILED));
                            }
                        }
                    }
                } else {
                    this.stop();
                }
            }
        } else {
            QCloudLogger.info((Logger)this.logger, (String)"Camera prepare failed");
        }
        QCloudLogger.info((Logger)this.logger, (String)"take photo finished");
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.videoCamera.setPreviewCallback(null);
        this.videoCamera.stop();
        this.videoCamera.release();
    }

    private void lock() {
        if (this.blocker == null || this.blocker.getCount() <= 0L) {
            this.blocker = new CountDownLatch(1);
        }
    }

    private void await() {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            try {
                this.blocker.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void await(long times) {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            try {
                this.blocker.await(times, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void unlock() {
        if (this.blocker != null && this.blocker.getCount() > 0L) {
            this.blocker.countDown();
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        this.frameData = data;
        QCloudLogger.debug((Logger)this.logger, (String)"frame data length is {}", (Object[])new Object[]{data.length});
    }

    private int StartDetection() {
        int startStatus = this.liveCheck.DoDetectionInit();
        this.timer = new Timer();
        long delayTime = 1000L;
        long periodTime = 70L;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Camera.Size previewSize = OcrLipDetectThread.this.videoCamera.getPreviewSize();
                int imageWidth = previewSize.width;
                int imageHeight = previewSize.height;
                OcrLipDetectThread.this.detectFrameCount++;
                if (OcrLipDetectThread.this.frameData != null) {
                    OcrLipDetectThread.this.faceStatus = OcrLipDetectThread.this.liveCheck.DoDetectionProcess(OcrLipDetectThread.this.frameData, imageWidth, imageHeight);
                    if (OcrLipDetectThread.this.faceStatus != null && !OcrLipDetectThread.this.hasDetectFace) {
                        OcrLipDetectThread.this.hasDetectFace = true;
                        OcrLipDetectThread.this.unlock();
                        OcrLipDetectThread.this.detectFrameCount = 0;
                        OcrLipDetectThread.this.timer.cancel();
                    }
                    if (OcrLipDetectThread.this.detectFrameCount > 80) {
                        OcrLipDetectThread.this.detectListener.onDetectFaceTimeout(OcrLipDetectThread.this);
                        OcrLipDetectThread.this.detectFrameCount = 0;
                    }
                }
            }
        }, delayTime, periodTime);
        return startStatus;
    }

    private void initModel() {
        byte[] ufdmtccbin = null;
        byte[] ufatbin = null;
        try {
            InputStream assetsInputStream = this.context.getAssets().open("ufdmtcc.bin");
            int available = assetsInputStream.available();
            ufdmtccbin = new byte[available];
            int byteCode = assetsInputStream.read(ufdmtccbin);
            assetsInputStream.close();
            assetsInputStream = this.context.getAssets().open("ufat.bin");
            available = assetsInputStream.available();
            ufatbin = new byte[available];
            byteCode = assetsInputStream.read(ufatbin);
            assetsInputStream.close();
            this.liveCheck.Init(ufdmtccbin, ufatbin);
        }
        catch (IOException e) {
            Log.e((String)"LiveCheck", (String)"initModel error");
        }
    }

    public static interface OcrLipDetectListener {
        public void onDetectFaceTimeout(OcrLipDetectThread var1);

        public void onDetectFace(OcrLipDetectThread var1);

        public void onGetLip(OcrLipDetectThread var1, String var2);

        public void onFinishRecord(OcrLipDetectThread var1);

        public void onSuccess(OcrLipDetectThread var1, VideoRecognizeResult var2);

        public void onFailed(OcrLipDetectThread var1, FaceInSaasException var2);
    }
}

