/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.hardware;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import com.tencent.qcloud.facein.hardware.QCloudCameraHelper;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudCameraStatus;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QCloudCamera {
    private Logger logger = LoggerFactory.getLogger(QCloudCamera.class);
    protected volatile QCloudCameraStatus cameraStatus = QCloudCameraStatus.RELEASED;
    protected int facing;
    protected Camera camera;
    protected Camera.Size previewSize;
    private String focusMode;
    private int pictureRotation;
    private int takePhotoOrientation;
    protected int windowRotation;
    private CameraIdHolder cameraIdHolder;
    private Camera.FaceDetectionListener faceDetectionListener;

    public QCloudCamera(int windowRotation, int facing) {
        this.facing = facing;
        this.windowRotation = windowRotation;
        this.cameraIdHolder = new CameraIdHolder();
        this.pictureRotation = 0;
        this.focusMode = "auto";
    }

    public synchronized void setFocusMode(String focusMode) {
        this.focusMode = focusMode;
    }

    protected abstract boolean _prepare(QCloudCameraPreview var1);

    public synchronized boolean prepare(QCloudCameraPreview cameraPreview) {
        QCloudLogger.debug((Logger)this.logger, (String)"camera is start prepare");
        QCloudLogger.debug((Logger)this.logger, (String)("camera status is " + (Object)((Object)this.cameraStatus)));
        if (this.cameraStatus != QCloudCameraStatus.RELEASED) {
            QCloudLogger.warn((Logger)this.logger, (String)"camera is not released");
            return false;
        }
        this.camera = QCloudCameraHelper.getDefaultCamera(this.facing, this.cameraIdHolder);
        if (this.camera == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"the camera with this facing is not exist");
            return false;
        }
        if (this.faceDetectionListener != null) {
            QCloudLogger.debug((Logger)this.logger, (String)"set face detect listener");
            this.camera.setFaceDetectionListener(this.faceDetectionListener);
        }
        if (cameraPreview == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"camera preview is null");
            return false;
        }
        SurfaceTexture texture = cameraPreview.getSurface();
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters != null) {
            Camera.Size optimalPreviewSize;
            List list = parameters.getSupportedPreviewSizes();
            Camera camera = this.camera;
            camera.getClass();
            this.previewSize = optimalPreviewSize = QCloudCameraHelper.getOptimalSize(list, new Camera.Size(camera, cameraPreview.getWidth(), cameraPreview.getHeight()));
            if (optimalPreviewSize != null) {
                parameters.setPreviewSize(optimalPreviewSize.width, optimalPreviewSize.height);
                QCloudLogger.debug((Logger)this.logger, (String)"the optimal preview width is {}, the optimal preview height is {}", (Object[])new Object[]{optimalPreviewSize.width, optimalPreviewSize.height});
            }
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.cameraIdHolder.cameraId, (Camera.CameraInfo)info);
            this.takePhotoOrientation = QCloudCameraHelper.getTakePictureOrientation(this.windowRotation, info.orientation, this.facing);
            QCloudLogger.debug((Logger)this.logger, (String)"windowRotation = {}", (Object[])new Object[]{this.windowRotation});
            QCloudLogger.debug((Logger)this.logger, (String)"info.orientation = {}", (Object[])new Object[]{info.orientation});
            QCloudLogger.debug((Logger)this.logger, (String)"takePhotoOrientation = {}", (Object[])new Object[]{this.takePhotoOrientation});
            parameters.setRotation(this.takePhotoOrientation);
            QCloudLogger.debug((Logger)this.logger, (String)"the preview width is {}, the preview height is {}", (Object[])new Object[]{cameraPreview.getWidth(), cameraPreview.getHeight()});
            QCloudLogger.debug((Logger)this.logger, (String)"focus mode is {}", (Object[])new Object[]{this.focusMode});
            List supportedFocusModes = parameters.getSupportedFocusModes();
            this.focusMode = QCloudCameraHelper.getOptimalFocusMode(supportedFocusModes, this.focusMode);
            if (this.focusMode != null) {
                QCloudLogger.debug((Logger)this.logger, (String)"set focus mode is {}", (Object[])new Object[]{this.focusMode});
                parameters.setFocusMode(this.focusMode);
            }
            try {
                this.camera.setParameters(parameters);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        this.camera.setDisplayOrientation(QCloudCameraHelper.getCameraDisplayOrientation(this.windowRotation, this.facing));
        if (!this._prepare(cameraPreview)) {
            QCloudLogger.warn((Logger)this.logger, (String)"_prepare failed.");
            return false;
        }
        try {
            this.camera.setPreviewTexture(texture);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.cameraStatus = QCloudCameraStatus.CREATED;
        QCloudLogger.info((Logger)this.logger, (String)"prepare success.");
        return true;
    }

    protected abstract boolean _start();

    public synchronized boolean start() {
        QCloudLogger.debug((Logger)this.logger, (String)"camera status is {}", (Object[])new Object[]{this.cameraStatus});
        if (this.cameraStatus != QCloudCameraStatus.CREATED && this.cameraStatus != QCloudCameraStatus.PAUSED) {
            QCloudLogger.warn((Logger)this.logger, (String)"camera is not created or pause");
            return false;
        }
        this.camera.startPreview();
        if (!this._start()) {
            return false;
        }
        if (this.cameraStatus == QCloudCameraStatus.CREATED) {
            this.cameraStatus = QCloudCameraStatus.STARTED;
        } else if (this.cameraStatus == QCloudCameraStatus.PAUSED) {
            this.cameraStatus = QCloudCameraStatus.RESUME;
        }
        Log.i((String)"TAG", (String)("camera start success, now the status is " + (Object)((Object)this.cameraStatus)));
        return true;
    }

    protected abstract boolean _stop();

    public synchronized boolean stop() {
        if (this.cameraStatus != QCloudCameraStatus.STARTED && this.cameraStatus != QCloudCameraStatus.PAUSED && this.cameraStatus != QCloudCameraStatus.RESUME) {
            QCloudLogger.warn((Logger)this.logger, (String)"camera is not started or resume");
            return false;
        }
        if (!this._stop()) {
            return false;
        }
        this.camera.stopPreview();
        this.cameraStatus = QCloudCameraStatus.STOPPED;
        return true;
    }

    protected abstract boolean _release();

    public synchronized boolean release() {
        if (this.cameraStatus != QCloudCameraStatus.STOPPED) {
            QCloudLogger.warn((Logger)this.logger, (String)"camera is not stopped");
            return false;
        }
        if (!this._release()) {
            return false;
        }
        this.camera.release();
        this.camera = null;
        this.cameraStatus = QCloudCameraStatus.RELEASED;
        QCloudLogger.debug((Logger)this.logger, (String)"camera is released.");
        return true;
    }

    public synchronized boolean isStarted() {
        return this.cameraStatus == QCloudCameraStatus.STARTED || this.cameraStatus == QCloudCameraStatus.RESUME;
    }

    public boolean setPreviewCallback(Camera.PreviewCallback previewCallback) {
        if (this.camera != null) {
            this.camera.setPreviewCallback(previewCallback);
            return true;
        }
        return false;
    }

    public synchronized void setFaceDetectionListener(Camera.FaceDetectionListener faceDetectionListener) {
        this.faceDetectionListener = faceDetectionListener;
    }

    public synchronized boolean startFaceDetection() {
        if (this.camera == null) {
            return false;
        }
        Camera.Parameters params = this.camera.getParameters();
        if (params.getMaxNumDetectedFaces() > 0) {
            Log.i((String)"TAG", (String)"\u652f\u6301\u4eba\u8138\u68c0\u6d4b");
            this.camera.startFaceDetection();
            return true;
        }
        Log.i((String)"TAG", (String)"\u4e0d\u652f\u6301\u4eba\u8138\u68c0\u6d4b");
        return false;
    }

    public synchronized void stopFaceDetection() {
        if (this.camera == null) {
            return;
        }
        this.camera.stopFaceDetection();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Camera.Size getPreviewSize() {
        return this.previewSize;
    }

    public synchronized int getTakePhotoOrientation() {
        return this.takePhotoOrientation;
    }

    public void setPictureRotation(int pictureRotation) {
        this.pictureRotation = pictureRotation;
    }

    static class CameraIdHolder {
        public int cameraId;

        public CameraIdHolder(int cameraId) {
            this.cameraId = cameraId;
        }

        public CameraIdHolder() {
            this(0);
        }

        public int getCameraId() {
            return this.cameraId;
        }

        public void setCameraId(int cameraId) {
            this.cameraId = cameraId;
        }
    }
}

