/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.widget.TextView;
import android.widget.Toast;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.activity.FaceAliveDetectFailedActivity;
import com.tencent.qcloud.facein.activity.FaceAliveDetectSuccessActivity;
import com.tencent.qcloud.facein.activity.modelview.OneLineTip;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.controler.FaceAliveDetectThread;
import com.tencent.qcloud.facein.dialog.FaceInDialogs;
import com.tencent.qcloud.facein.exception.FaceInSaasException;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardCompareResult;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.facein.user.FaceInFailedType;
import com.tencent.qcloud.facein.user.FaceInModelType;
import com.tencent.qcloud.facein.user.FaceInResultListener;
import com.tencent.qcloud.facein.user.IdCardInfo;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceAliveDetectActivity
extends Activity {
    private Logger logger = LoggerFactory.getLogger(FaceAliveDetectActivity.class);
    private OneLineTip tip;
    private FaceAliveDetectThread detectThread;
    private Handler handler;
    private FaceInService saasService;
    private QCloudCameraPreview cameraPreview;
    private int rotation;
    private Dialog dialog;
    private TextView tipText;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.tip = new OneLineTip(this.getResources().getString(R.string.please_shake_head));
        this.tipText.setText((CharSequence)this.tip.getTipMessage());
        this.handler = new Handler(this.getMainLooper());
        this.saasService = new FaceInService((Context)this, FaceInConfig.getFaceInServiceConfig(), FaceInConfig.getCredentialProvider());
        this.cameraPreview = (QCloudCameraPreview)this.findViewById(R.id.preview);
        this.rotation = this.getWindowManager().getDefaultDisplay().getRotation();
    }

    protected void onResume() {
        super.onResume();
        this.detectThread = new FaceAliveDetectThread((Context)this, this.saasService, this.cameraPreview, this.rotation, this.handler);
        this.detectThread.setDetectListener(new FaceAliveDetectThread.FaceAliveDetectListener(){

            @Override
            public void onHeadShake(FaceAliveDetectThread detectThread) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        FaceAliveDetectActivity.this.tip.setTipMessage(FaceAliveDetectActivity.this.getResources().getString(R.string.please_wink));
                        FaceAliveDetectActivity.this.tipText.setText((CharSequence)FaceAliveDetectActivity.this.tip.getTipMessage());
                    }
                });
            }

            @Override
            public void onDetectHeadShakeTimeout(FaceAliveDetectThread detectThread) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)FaceAliveDetectActivity.this, (CharSequence)FaceAliveDetectActivity.this.getResources().getString(R.string.please_shake_your_head), (int)0).show();
                    }
                });
            }

            @Override
            public void onWink(FaceAliveDetectThread detectThread) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        FaceAliveDetectActivity.this.dialog = FaceInDialogs.simpleProgressDialog((Context)FaceAliveDetectActivity.this);
                        QCloudLogger.debug((Logger)FaceAliveDetectActivity.this.logger, (String)"show dialog");
                        FaceAliveDetectActivity.this.dialog.show();
                    }
                });
            }

            @Override
            public void onDetectWinkTimeout(FaceAliveDetectThread detectThread) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)FaceAliveDetectActivity.this, (CharSequence)FaceAliveDetectActivity.this.getResources().getString(R.string.please_wink_your_eye), (int)0).show();
                    }
                });
            }

            @Override
            public void onNullResultImage(FaceAliveDetectThread detectThread) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)FaceAliveDetectActivity.this, (CharSequence)FaceAliveDetectActivity.this.getResources().getString(R.string.please_keep_regular_head_or_good_light), (int)0).show();
                    }
                });
            }

            @Override
            public void onSuccess(FaceAliveDetectThread detectThread, IdCardCompareResult result) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (FaceAliveDetectActivity.this.dialog != null) {
                            FaceAliveDetectActivity.this.dialog.dismiss();
                            QCloudLogger.debug((Logger)FaceAliveDetectActivity.this.logger, (String)"dialog dismiss");
                        } else {
                            QCloudLogger.debug((Logger)FaceAliveDetectActivity.this.logger, (String)"dialog is null");
                        }
                        QCloudLogger.debug((Logger)FaceAliveDetectActivity.this.logger, (String)"face alive detect success");
                        FaceAliveDetectActivity.this.sendSuccessMessage(0.0f);
                        Intent intent = new Intent((Context)FaceAliveDetectActivity.this, FaceAliveDetectSuccessActivity.class);
                        FaceAliveDetectActivity.this.startActivity(intent);
                        FaceAliveDetectActivity.this.finish();
                    }
                });
            }

            @Override
            public void onFailed(FaceAliveDetectThread detectThread, FaceInSaasException code) {
                FaceAliveDetectActivity.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (FaceAliveDetectActivity.this.dialog != null) {
                            FaceAliveDetectActivity.this.dialog.dismiss();
                        }
                        QCloudLogger.debug((Logger)FaceAliveDetectActivity.this.logger, (String)"face alive detect failed");
                        FaceAliveDetectActivity.this.sendFailedMessage();
                        Intent intent = new Intent((Context)FaceAliveDetectActivity.this, FaceAliveDetectFailedActivity.class);
                        FaceAliveDetectActivity.this.startActivity(intent);
                        FaceAliveDetectActivity.this.finish();
                    }
                });
            }
        });
        this.detectThread.start();
    }

    private void sendSuccessMessage(float similarity) {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IdCardInfo idCardInfo = new IdCardInfo(UserIdCardInfo.name, UserIdCardInfo.id, UserIdCardInfo.addr, UserIdCardInfo.authority, UserIdCardInfo.date);
                    resultListener.onSuccess(FaceInModelType.OCR_ID_CARD_FACE_ALIVE_COMPARE, idCardInfo);
                }
            }).start();
        }
    }

    private void sendFailedMessage() {
        final FaceInResultListener resultListener = FaceInConfig.getFaceInResultListener();
        if (resultListener != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    IdCardInfo idCardInfo = new IdCardInfo(UserIdCardInfo.name, UserIdCardInfo.id, UserIdCardInfo.addr, UserIdCardInfo.authority, UserIdCardInfo.date);
                    resultListener.onFailed(FaceInModelType.OCR_ID_CARD_FACE_ALIVE_COMPARE, FaceInFailedType.FACE_IN_SIMILARITY_LOW);
                }
            }).start();
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.detectThread != null) {
            this.detectThread.stop();
        }
        this.saasService.release();
    }
}

