/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtulivecheck;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.Looper;
import com.tencent.youtulivecheck.Config;
import com.tencent.youtulivecheck.HttpUtil;
import com.tencent.youtulivecheck.Log;
import com.tencent.youtulivecheck.StatisticsUtils;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class YoutuLiveCheck {
    private static YoutuLiveCheck instance = null;
    private static long handle = 0L;
    public Context context = null;
    private static final String SDK_NAME = "YoutuLiveCheck";
    private static final String SDK_PREFIX = "YT";
    private static final String LICENCE_SUFFIX = "SDK.licence";
    private static final String DAT_SUFFIX = "SDK.dat";
    private Timer timerFlush;
    private Timer timerReport;
    private static final String TAG = "log_print";
    private static String licenceStr = "";
    private static HttpUtil.HttpResponseListener mListener = new HttpUtil.HttpResponseListener(){

        public void onSuccess(String responseStr) {
            try {
                Log.d(YoutuLiveCheck.TAG, "response: " + responseStr);
                Log.d(YoutuLiveCheck.TAG, "handle: " + handle);
                YoutuLiveCheck.nativeUpdateFromServer(handle, responseStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void onFail(int statusCode) {
            try {
                Log.d(YoutuLiveCheck.TAG, "http request error : " + statusCode);
                Log.d(YoutuLiveCheck.TAG, "handle: " + handle);
                YoutuLiveCheck.nativeUpdateFromServer(handle, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private long nativePtr;

    public static int initLicenceStr(Context context, String licence) {
        licenceStr = licence;
        int res = -1;
        try {
            byte[] buffer = licence.getBytes();
            int available = buffer.length;
            if (available <= 0) {
                throw new IOException("licence error");
            }
            String path = context.getFilesDir().getPath() + "/" + SDK_PREFIX + SDK_NAME + DAT_SUFFIX;
            String bundle = context.getPackageName();
            String uuid = StatisticsUtils.getDeviceUid(context);
            Log.d(TAG, "Package name: " + bundle);
            Log.d(TAG, "Device id: " + uuid);
            res = YoutuLiveCheck.nativePreInitAndCheck(buffer, available, bundle, uuid, path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static synchronized YoutuLiveCheck getInstance() {
        if (instance == null) {
            instance = new YoutuLiveCheck();
        }
        return instance;
    }

    public void init(Context context, String licence, int initType, boolean debug) {
        Config.DEBUG = debug;
        String path = context.getFilesDir().getPath() + "/" + SDK_PREFIX + SDK_NAME + DAT_SUFFIX;
        handle = YoutuLiveCheck.nativeInitN(context, initType, licence, context.getAssets(), path);
        Log.d(TAG, "handleinit: " + handle);
        TimerTask taskReport = new TimerTask(){

            public void run() {
                String reportContent = YoutuLiveCheck.getReportContent();
                Log.d(YoutuLiveCheck.TAG, "report content : " + reportContent);
                if (reportContent != "") {
                    YoutuLiveCheck.report(reportContent);
                }
            }
        };
        this.timerReport = new Timer(true);
        this.timerReport.schedule(taskReport, 600000L, 600000L);
        TimerTask taskFlush = new TimerTask(){

            public void run() {
                Log.d(YoutuLiveCheck.TAG, "flush in java ");
                YoutuLiveCheck.nativeFlush();
            }
        };
        this.timerFlush = new Timer(true);
        this.timerFlush.schedule(taskFlush, 600000L, 600000L);
    }

    public static long getHandle() {
        return handle;
    }

    public static boolean check() {
        boolean b = YoutuLiveCheck.nativeCheck(handle);
        android.util.Log.d((String)"sdk", (String)"--------------check");
        return b;
    }

    public static native long nativeInitN(Context var0, int var1, String var2, AssetManager var3, String var4);

    public static native long nativeUpdateFromServer(long var0, String var2);

    public static native boolean nativeCheck(long var0);

    public static native String getReportContent();

    public static native long nativeFlush();

    public static native int nativePreInitAndCheck(byte[] var0, int var1, String var2, String var3, String var4);

    public static boolean isInMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static void report(final String data) {
        Log.d(TAG, "report: " + data);
        String url = "https://api.youtu.qq.com/auth/report";
        if (YoutuLiveCheck.isInMainThread()) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        HttpUtil.post("https://api.youtu.qq.com/auth/report", data, mListener);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
        } else {
            try {
                HttpUtil.post("https://api.youtu.qq.com/auth/report", data, mListener);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public YoutuLiveCheck() {
        this.NativeConstructor();
    }

    public void destroy() {
        this.NativeDestructor();
    }

    protected void finalize() throws Throwable {
        this.NativeDestructor();
    }

    public native int DoDetectionInit();

    public native boolean Init(byte[] var1, byte[] var2);

    public native FaceStatus DoDetectionProcess(byte[] var1, int var2, int var3);

    public native FaceStatus DoDetectionProcessRGBA(byte[] var1, int var2, int var3);

    public native Bitmap GetResultImage();

    public native void StartLiveCheck();

    public native void EndLiveCheck();

    public native Bitmap GetResultLiveCheckImage();

    private native void NativeConstructor();

    private native void NativeDestructor();

    private static native boolean nativeInit();

    static {
        System.loadLibrary("youtulivecheck");
        YoutuLiveCheck.nativeInit();
    }

    public static class FaceStatus {
        public int x;
        public int y;
        public int w;
        public int h;
        public PointF lefteye;
        public PointF righteye;
        public float pitch;
        public float yaw;
        public float roll;
        public int illumination_score;
        public int blur_score;
        public int save_photo;
        public int liveness_head;
        public int liveness_mouth;
        public int liveness_eye;
    }
}

