/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtulivecheck;

import android.text.TextUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpUtil {
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private static final String CHARSET_UTF8 = "UTF-8";

    public static String post(String url, String str, HttpResponseListener listener) throws IOException {
        HttpURLConnection conn = HttpUtil.buildConnection(url, 10000);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestMethod("POST");
        if (!TextUtils.isEmpty((CharSequence)str)) {
            OutputStream os = conn.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, CHARSET_UTF8));
            writer.write(str);
            writer.flush();
            writer.close();
            os.close();
        }
        return HttpUtil.getResponse(conn, listener);
    }

    private static HttpURLConnection buildConnection(String url, int timeoutMillis) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(timeoutMillis);
        conn.setReadTimeout(timeoutMillis);
        return conn;
    }

    private static String getResponse(HttpURLConnection conn, HttpResponseListener listener) throws IOException {
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            int x;
            InputStream is = conn.getInputStream();
            StringBuilder buf = new StringBuilder();
            byte[] buffer = new byte[1024];
            while ((x = is.read(buffer)) != -1) {
                buf.append(new String(buffer, 0, x));
            }
            is.close();
            String str = buf.toString();
            if (listener != null) {
                listener.onSuccess(str);
            }
            return str;
        }
        if (listener != null) {
            listener.onFail(responseCode);
        }
        return null;
    }

    public static interface HttpResponseListener {
        public void onSuccess(String var1);

        public void onFail(int var1);
    }
}

