/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.content.Context;
import android.os.Handler;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.util.AttributeSet;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberMarquee
extends AppCompatTextView {
    private Logger logger = LoggerFactory.getLogger(NumberMarquee.class);
    private char[] friends;
    private int interval;
    private Timer timer;
    private int count;
    private Handler mainHandler;
    private boolean hasStarted;
    private int spaceInterval;
    private int number;
    private MarqueeFinishListener finishListener;

    public NumberMarquee(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public synchronized void start(int value, int number, int interval, Handler handler, int spaceInterval) {
        if (this.hasStarted) {
            return;
        }
        this.hasStarted = true;
        this.spaceInterval = spaceInterval;
        this.interval = interval;
        this.number = number;
        this.initFriends(value, number);
        this.initSpannableString();
        this.mainHandler = handler;
        this.hasStarted = false;
        TimerTask task = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (NumberMarquee.this.count <= NumberMarquee.this.number) {
                    NumberMarquee.this.marqueeStep();
                    NumberMarquee.this.count++;
                    QCloudLogger.debug((Logger)NumberMarquee.this.logger, (String)"run task");
                } else {
                    QCloudLogger.debug((Logger)NumberMarquee.this.logger, (String)"schedule task is stop");
                    NumberMarquee numberMarquee = NumberMarquee.this;
                    synchronized (numberMarquee) {
                        NumberMarquee.this.timer.cancel();
                    }
                }
            }
        };
        this.timer = new Timer();
        this.timer.schedule(task, 0L, (long)interval);
    }

    private void marqueeStep() {
        int i;
        final SpannableString spannableString = new SpannableString((CharSequence)new String(this.friends));
        if (this.finishListener != null) {
            this.finishListener.onFinish(this, this.count);
        }
        for (i = 0; i < this.count; ++i) {
            spannableString.setSpan((Object)new ForegroundColorSpan(-16776961), i * (this.spaceInterval + 1), i * (this.spaceInterval + 1) + 1, 17);
        }
        if (this.count < this.number) {
            spannableString.setSpan((Object)new ForegroundColorSpan(-16776961), this.count * (this.spaceInterval + 1), this.count * (this.spaceInterval + 1) + 1, 17);
        }
        for (i = this.count + 1; i < this.number; ++i) {
            spannableString.setSpan((Object)new ForegroundColorSpan(-1), i * (this.spaceInterval + 1), i * (this.spaceInterval + 1) + 1, 17);
        }
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                NumberMarquee.this.setText((CharSequence)spannableString);
            }
        });
    }

    private void initSpannableString() {
        SpannableString spannableString = new SpannableString((CharSequence)new String(this.friends));
        for (int i = 0; i < this.number; ++i) {
            spannableString.setSpan((Object)new RelativeSizeSpan(1.5f), i * (this.spaceInterval + 1), i * (this.spaceInterval + 1) + 1, 17);
        }
        this.setText((CharSequence)spannableString);
    }

    private void initFriends(int value, int number) {
        int i;
        if (number <= 0) {
            this.friends = new char[0];
            return;
        }
        int numberOfSpace = (number - 1) * this.spaceInterval;
        this.friends = new char[number + numberOfSpace];
        for (i = 0; i < this.friends.length; ++i) {
            this.friends[i] = 32;
        }
        for (i = 0; i < number; ++i) {
            this.friends[this.getFriend((int)(number - i - 1))] = (char)(value % 10 + 48);
            value /= 10;
        }
    }

    private int getFriend(int seq) {
        return seq * (this.spaceInterval + 1);
    }

    public void setFinishListener(MarqueeFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public static interface MarqueeFinishListener {
        public void onFinish(NumberMarquee var1, int var2);
    }
}

