/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.ui;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.EditText;
import android.widget.TextView;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import java.util.Calendar;
import java.util.List;

public class IdCardMessageConfirmAdapter
extends BaseAdapter {
    private List<ItemMessage> messages;
    private LayoutInflater inflater;
    private int currentPosition = -1;

    public IdCardMessageConfirmAdapter(Context context, List<ItemMessage> messages) {
        this.messages = messages;
        this.inflater = LayoutInflater.from((Context)context);
    }

    public int getCount() {
        return this.messages.size();
    }

    public Object getItem(int position) {
        return this.messages.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        View item = null;
        if (position <= 4) {
            item = this.inflater.inflate(R.layout.adaptor_id_card_message_layout1, null);
            TextView key = (TextView)item.findViewById(R.id.id_card_message_key);
            key.setText((CharSequence)this.messages.get(position).getKey());
            EditText value = (EditText)item.findViewById(R.id.id_card_message_value);
            value.setTag((Object)position);
            value.setText((CharSequence)this.messages.get(position).getValue());
            value.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    IdCardMessageConfirmAdapter.this.currentPosition = (Integer)v.getTag();
                    return false;
                }
            });
            value.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                }

                public void onTextChanged(CharSequence s, int start, int before, int count) {
                }

                public void afterTextChanged(Editable s) {
                    ItemMessage itemMessage = (ItemMessage)IdCardMessageConfirmAdapter.this.messages.get(position);
                    switch (position) {
                        case 0: {
                            UserIdCardInfo.name = s.toString();
                            break;
                        }
                        case 1: {
                            UserIdCardInfo.id = s.toString();
                            break;
                        }
                        case 2: {
                            UserIdCardInfo.addr = s.toString();
                            break;
                        }
                        case 3: {
                            UserIdCardInfo.authority = s.toString();
                            break;
                        }
                        case 4: {
                            UserIdCardInfo.date = s.toString();
                        }
                    }
                    itemMessage.setValue(s.toString());
                }
            });
            if (this.currentPosition == position) {
                value.requestFocus();
                value.setSelection(value.getText().length());
            } else {
                value.clearFocus();
            }
        } else {
            item = this.inflater.inflate(R.layout.adaptor_id_card_message_layout2, null);
            TextView key = (TextView)item.findViewById(R.id.id_card_message_key);
            key.setText((CharSequence)this.messages.get(position).getKey());
        }
        return item;
    }

    public static class ItemMessage {
        private String key;
        private String value;
        private Calendar start;
        private Calendar end;

        public ItemMessage(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public ItemMessage(String key, Calendar start, Calendar end) {
            this.key = key;
            this.start = start;
            this.end = end;
        }

        public Calendar getEnd() {
            return this.end;
        }

        public Calendar getStart() {
            return this.start;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setEnd(Calendar end) {
            this.end = end;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setStart(Calendar start) {
            this.start = start;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

