/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.pass.model;

import com.tencent.qcloud.facein.pass.model.FaceInRequest;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeRequest;
import com.tencent.qcloud.facein.pass.model.VideoRecognizeResult;
import com.tencent.qcloud.network.QCloudProgressListener;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.cosv4.CosV4SignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestFormDataSerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseJsonBodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoRecognizeRequest
extends FaceInRequest {
    private Logger logger = LoggerFactory.getLogger(IdCardRecognizeRequest.class);
    private String bucket;
    private String validateData;
    private String localVideoPath;
    private String idCardNumber;
    private String idCardName;

    public VideoRecognizeRequest(String bucket, String validateData, String localVideoPath, String idCardName, String idCardNumber) {
        this.bucket = bucket;
        this.validateData = validateData;
        this.localVideoPath = localVideoPath;
        this.idCardName = idCardName;
        this.idCardNumber = idCardNumber;
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.requestOriginBuilder.method("POST");
        if (this.sourceSerializer == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"source serializer is null, instead with once signature serializer");
            this.sourceSerializer = new CosV4SignatureSourceSerializer(600L);
        }
        CosV4SignatureSourceSerializer cosV4SignatureSourceSerializer = (CosV4SignatureSourceSerializer)this.sourceSerializer;
        cosV4SignatureSourceSerializer.setBucket(this.bucket);
        cosV4SignatureSourceSerializer.setCosPath("");
        RequestFormDataSerializer formDataSerializer = new RequestFormDataSerializer();
        formDataSerializer.bodyKeyValue("bucket", this.bucket);
        formDataSerializer.bodyKeyValue("validate_data", this.validateData);
        formDataSerializer.bodyKeyValue("idcard_number", this.idCardNumber);
        formDataSerializer.bodyKeyValue("idcard_name", this.idCardName);
        formDataSerializer.setProgressListener(new QCloudProgressListener(){

            public void onProgress(long progress, long max) {
                QCloudLogger.debug((Logger)VideoRecognizeRequest.this.logger, (String)"progress = {}, max = {}", (Object[])new Object[]{progress, max});
            }
        });
        formDataSerializer.uploadFile(this.localVideoPath, "video");
        this.setRequestBodySerializer((RequestBodySerializer)formDataSerializer);
        this.requestOriginBuilder.header("Host", "service.image.myqcloud.com");
        this.requestOriginBuilder.pathAddRear("/face/idcardlivedetectfour");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseJsonBodySerializer(VideoRecognizeResult.class);
    }
}

