/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.pass.model;

import com.tencent.qcloud.facein.pass.model.FaceInRequest;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.cosv4.CosV4SignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestFormDataSerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseJsonBodySerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeRequest
extends FaceInRequest {
    private Logger logger = LoggerFactory.getLogger(IdCardRecognizeRequest.class);
    private String bucket;
    private boolean faceSide;
    private String localImagePath;
    private long requestSeq;

    public void setRequestSeq(long requestSeq) {
        this.requestSeq = requestSeq;
    }

    public long getRequestSeq() {
        return this.requestSeq;
    }

    public IdCardRecognizeRequest(String bucket, String localImagePath, boolean faceSide) {
        this.bucket = bucket;
        this.faceSide = faceSide;
        this.localImagePath = localImagePath;
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.requestOriginBuilder.method("POST");
        if (this.sourceSerializer == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"source serializer is null, instead with once signature serializer");
            this.sourceSerializer = new CosV4SignatureSourceSerializer(600L);
        }
        CosV4SignatureSourceSerializer cosV4SignatureSourceSerializer = (CosV4SignatureSourceSerializer)this.sourceSerializer;
        cosV4SignatureSourceSerializer.setBucket(this.bucket);
        cosV4SignatureSourceSerializer.setCosPath("");
        RequestFormDataSerializer formDataSerializer = new RequestFormDataSerializer();
        formDataSerializer.bodyKeyValue("bucket", this.bucket);
        formDataSerializer.bodyKeyValue("card_type", this.faceSide ? "0" : "1");
        formDataSerializer.uploadFile(this.localImagePath, "image[0]");
        this.setRequestBodySerializer((RequestBodySerializer)formDataSerializer);
        this.requestOriginBuilder.header("Host", "service.image.myqcloud.com");
        this.requestOriginBuilder.pathAddRear("/ocr/idcard");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseJsonBodySerializer(IdCardRecognizeResult.class);
    }
}

