/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.pass.model;

import com.tencent.qcloud.facein.pass.model.FaceInRequest;
import com.tencent.qcloud.facein.pass.model.IdCardCompareResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.cosv4.CosV4SignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestFormDataSerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseJsonBodyLowestSerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardCompareRequest
extends FaceInRequest {
    private Logger logger = LoggerFactory.getLogger(IdCardCompareRequest.class);
    private String bucket;
    private String idCardNumber;
    private String idCardName;
    private String localImagePath;

    public IdCardCompareRequest(String bucket, String idCardName, String idCardNumber, String localImagePath) {
        this.bucket = bucket;
        this.idCardName = idCardName;
        this.idCardNumber = idCardNumber;
        this.localImagePath = localImagePath;
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.requestOriginBuilder.method("POST");
        if (this.sourceSerializer == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"source serializer is null, instead with once signature serializer");
            this.sourceSerializer = new CosV4SignatureSourceSerializer(600L);
        }
        CosV4SignatureSourceSerializer cosV4SignatureSourceSerializer = (CosV4SignatureSourceSerializer)this.sourceSerializer;
        cosV4SignatureSourceSerializer.setBucket(this.bucket);
        cosV4SignatureSourceSerializer.setCosPath("");
        RequestFormDataSerializer formDataSerializer = new RequestFormDataSerializer();
        formDataSerializer.bodyKeyValue("bucket", this.bucket);
        formDataSerializer.bodyKeyValue("idcard_number", this.idCardNumber);
        formDataSerializer.bodyKeyValue("idcard_name", this.idCardName);
        formDataSerializer.uploadFile(this.localImagePath, "image");
        this.setRequestBodySerializer((RequestBodySerializer)formDataSerializer);
        this.requestOriginBuilder.header("Host", "service.image.myqcloud.com");
        this.requestOriginBuilder.pathAddRear("face/idcardcompare");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseJsonBodyLowestSerializer(IdCardCompareResult.class);
    }
}

