/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.pass.model;

import com.tencent.qcloud.facein.pass.model.FaceInRequest;
import com.tencent.qcloud.facein.pass.model.GetLipResult;
import com.tencent.qcloud.network.QCloudRequest;
import com.tencent.qcloud.network.cosv4.CosV4SignatureSourceSerializer;
import com.tencent.qcloud.network.logger.QCloudLogger;
import com.tencent.qcloud.network.request.serializer.body.RequestBodySerializer;
import com.tencent.qcloud.network.request.serializer.body.RequestJsonBodySerializer;
import com.tencent.qcloud.network.response.serializer.body.ResponseJsonBodyLowestSerializer;
import com.tencent.qcloud.network.response.serializer.http.HttpPassAllSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLipRequest
extends FaceInRequest {
    private Logger logger = LoggerFactory.getLogger(GetLipRequest.class);
    private String bucket;

    public GetLipRequest(String bucket) {
        this.bucket = bucket;
    }

    public void build() {
        this.priority = QCloudRequest.QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.requestOriginBuilder.method("POST");
        if (this.sourceSerializer == null) {
            QCloudLogger.warn((Logger)this.logger, (String)"source serializer is null, instead with once signature serializer");
            this.sourceSerializer = new CosV4SignatureSourceSerializer(600L);
        }
        CosV4SignatureSourceSerializer cosV4SignatureSourceSerializer = (CosV4SignatureSourceSerializer)this.sourceSerializer;
        cosV4SignatureSourceSerializer.setBucket(this.bucket);
        cosV4SignatureSourceSerializer.setCosPath("");
        RequestJsonBodySerializer jsonBodySerializer = new RequestJsonBodySerializer();
        jsonBodySerializer.bodyKeyValue("bucket", this.bucket);
        this.setRequestBodySerializer((RequestBodySerializer)jsonBodySerializer);
        this.requestOriginBuilder.header("Host", "service.image.myqcloud.com");
        this.requestOriginBuilder.pathAddRear("face/livegetfour");
        this.responseSerializer = new HttpPassAllSerializer();
        this.responseBodySerializer = new ResponseJsonBodyLowestSerializer(GetLipResult.class);
    }
}

