/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.hardware;

import android.hardware.Camera;
import com.tencent.qcloud.facein.hardware.QCloudCamera;
import com.tencent.qcloud.facein.hardware.QCloudCameraHelper;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudCameraStatus;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudPictureCamera
extends QCloudCamera {
    private Logger logger = LoggerFactory.getLogger(QCloudPictureCamera.class);
    private CountDownLatch waitForPicture;
    private CountDownLatch waitForFocus;
    private byte[] pictureData;
    private boolean focusSuccess;

    public QCloudPictureCamera(int rotation, int facing) {
        super(rotation, facing);
    }

    public synchronized byte[] takePicture() {
        this.waitForPicture = new CountDownLatch(1);
        if (this.cameraStatus != QCloudCameraStatus.STARTED && this.cameraStatus != QCloudCameraStatus.RESUME) {
            QCloudLogger.warn((Logger)this.logger, (String)"can't take picture in this status, you should start camera first");
            return null;
        }
        this.camera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, Camera camera) {
                QCloudPictureCamera.access$002(QCloudPictureCamera.this, data);
                QCloudPictureCamera.this.waitForPicture.countDown();
            }
        });
        try {
            this.waitForPicture.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.cameraStatus = QCloudCameraStatus.PAUSED;
        return this.pictureData;
    }

    public synchronized boolean autoFocus() {
        this.waitForFocus = new CountDownLatch(1);
        if (this.cameraStatus != QCloudCameraStatus.STARTED && this.cameraStatus != QCloudCameraStatus.RESUME) {
            QCloudLogger.warn((Logger)this.logger, (String)"can't auto focus in this status, you should start camera first");
            return false;
        }
        this.camera.autoFocus(new Camera.AutoFocusCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAutoFocus(boolean success, Camera camera) {
                QCloudPictureCamera.this.waitForFocus.countDown();
                QCloudPictureCamera qCloudPictureCamera = QCloudPictureCamera.this;
                synchronized (qCloudPictureCamera) {
                    QCloudPictureCamera.this.focusSuccess = success;
                }
            }
        });
        try {
            this.waitForFocus.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        QCloudLogger.debug((Logger)this.logger, (String)"auto focus is {}", (Object[])new Object[]{this.focusSuccess});
        return this.focusSuccess;
    }

    @Override
    protected synchronized boolean _prepare(QCloudCameraPreview cameraPreview) {
        Camera.Parameters parameters = this.camera.getParameters();
        Camera camera = this.camera;
        camera.getClass();
        Camera.Size targetSize = new Camera.Size(camera, cameraPreview.getWidth(), cameraPreview.getHeight());
        List supportedPictureSize = parameters.getSupportedPictureSizes();
        Camera.Size optimalSize = QCloudCameraHelper.getOptimalSize(supportedPictureSize, targetSize);
        if (optimalSize != null) {
            parameters.setPictureSize(optimalSize.width, optimalSize.height);
        }
        this.camera.setParameters(parameters);
        return true;
    }

    @Override
    protected synchronized boolean _start() {
        return true;
    }

    @Override
    protected synchronized boolean _stop() {
        return true;
    }

    @Override
    protected synchronized boolean _release() {
        return true;
    }

    static /* synthetic */ byte[] access$002(QCloudPictureCamera x0, byte[] x1) {
        x0.pictureData = x1;
        return x1;
    }
}

