/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.hardware;

import android.hardware.Camera;
import com.tencent.qcloud.facein.hardware.QCloudCamera;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QCloudCameraHelper {
    private static Logger logger = LoggerFactory.getLogger(QCloudCameraHelper.class);

    static Camera getDefaultCamera(int facing) {
        return QCloudCameraHelper.getDefaultCamera(facing, null);
    }

    static Camera getDefaultCamera(int facing, QCloudCamera.CameraIdHolder cameraIdHolder) {
        int mNumberOfCameras = Camera.getNumberOfCameras();
        QCloudLogger.debug((Logger)logger, (String)"the number of cameras is {}", (Object[])new Object[]{mNumberOfCameras});
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        for (int i = 0; i < mNumberOfCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != facing) continue;
            Camera camera = null;
            try {
                camera = Camera.open((int)i);
            }
            catch (RuntimeException r) {
                r.printStackTrace();
                QCloudLogger.debug((Logger)logger, (String)"open camera failed");
            }
            if (cameraIdHolder != null && camera != null) {
                cameraIdHolder.setCameraId(i);
            }
            return camera;
        }
        QCloudLogger.warn((Logger)logger, (String)"the camera is not supported.");
        return null;
    }

    static int getCameraDisplayOrientation(int rotation, int facing) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)facing, (Camera.CameraInfo)info);
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    public static int getTakePictureOrientation(int screenOrientation, int cameraOrientation, int facing) {
        switch (screenOrientation) {
            case 0: {
                screenOrientation = 0;
                break;
            }
            case 1: {
                screenOrientation = 270;
                break;
            }
            case 2: {
                screenOrientation = 180;
                break;
            }
            case 3: {
                screenOrientation = 90;
            }
        }
        int rotation = 0;
        rotation = facing == 1 ? (cameraOrientation - screenOrientation + 360) % 360 : (cameraOrientation + screenOrientation) % 360;
        return rotation;
    }

    private static void printList(List<Camera.Size> sizes) {
        for (Camera.Size size : sizes) {
            QCloudLogger.debug((Logger)logger, (String)"width = {}, height = {}", (Object[])new Object[]{size.width, size.height});
        }
    }

    static Camera.Size getOptimalSize(List<Camera.Size> supportedSizes, Camera.Size targetSize) {
        if (supportedSizes == null || supportedSizes.isEmpty()) {
            return null;
        }
        QCloudCameraHelper.printList(supportedSizes);
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)targetSize.width / (double)targetSize.height;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = targetSize.height;
        boolean hasGet = false;
        for (Camera.Size size : supportedSizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            targetSize.width = size.width;
            targetSize.height = size.height;
            minDiff = Math.abs(size.height - targetHeight);
            hasGet = true;
        }
        if (!hasGet) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : supportedSizes) {
                if (!((double)Math.abs(size.height * size.width - targetHeight * targetSize.width) < minDiff)) continue;
                targetSize.width = size.width;
                targetSize.height = size.height;
                minDiff = Math.abs(size.height * size.width - targetHeight * targetSize.width);
            }
        }
        return targetSize;
    }

    public static Camera.Size getOptimalVideoSize(List<Camera.Size> supportedVideoSizes, List<Camera.Size> previewSizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)w / (double)h;
        List<Camera.Size> videoSizes = supportedVideoSizes != null ? supportedVideoSizes : previewSizes;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : videoSizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff) || !previewSizes.contains(size)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : videoSizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff) || !previewSizes.contains(size)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public static String getOptimalFocusMode(List<String> supportedFocusMode, String targetFocusMode) {
        for (String mode : supportedFocusMode) {
            System.out.println("support " + mode);
        }
        if (supportedFocusMode.contains(targetFocusMode)) {
            return targetFocusMode;
        }
        if (supportedFocusMode.contains("continuous-video")) {
            return "continuous-video";
        }
        if (supportedFocusMode.contains("auto")) {
            return "auto";
        }
        return null;
    }
}

