/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.dialog;

import android.app.Dialog;
import android.content.Context;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.network.logger.QCloudLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceInDialogs {
    private static Logger logger = LoggerFactory.getLogger(FaceInDialogs.class);

    public static void idCardScanFailedDialog(Context context, final View.OnClickListener leftListener, final View.OnClickListener rightListener, String title) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.dialog_id_card_recognize_failed, null);
        Button leftButton = (Button)view.findViewById(R.id.left_bt);
        TextView titleTextView = (TextView)view.findViewById(R.id.title);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            titleTextView.setText((CharSequence)title);
        }
        Button rightButton = (Button)view.findViewById(R.id.right_bt);
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setCancelable(false);
        builder.setView(view);
        final AlertDialog alertDialog = builder.create();
        leftButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (leftListener != null) {
                    leftListener.onClick(v);
                }
                alertDialog.cancel();
            }
        });
        rightButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (rightListener != null) {
                    rightListener.onClick(v);
                }
                alertDialog.dismiss();
            }
        });
        QCloudLogger.debug((Logger)logger, (String)"id card recognize dialog");
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        float screenDensity = displayMetrics.density;
        alertDialog.show();
        WindowManager.LayoutParams lp = alertDialog.getWindow().getAttributes();
        lp.width = (int)(screenDensity * 240.0f);
        lp.height = (int)(screenDensity * 180.0f);
        alertDialog.getWindow().setAttributes(lp);
    }

    public static void idCardScanFailedDialog(Context context, View.OnClickListener leftListener, View.OnClickListener rightListener) {
        FaceInDialogs.idCardScanFailedDialog(context, leftListener, rightListener, null);
    }

    public static void permissionCheckFailedDialog(Context context, final View.OnClickListener listener) {
        final Dialog dialog = new Dialog(context, R.style.dialog);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(R.layout.dialog_check_permission_failed, null);
        dialog.setContentView(view);
        dialog.setCancelable(false);
        dialog.show();
        Button ok = (Button)view.findViewById(R.id.confirm);
        ok.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (dialog != null) {
                    dialog.dismiss();
                }
                listener.onClick(v);
            }
        });
    }

    public static Dialog simpleProgressDialog(Context context) {
        Dialog dialog = new Dialog(context, R.style.dialog);
        dialog.setContentView(R.layout.dialog_simple_progress_bar);
        dialog.setCancelable(false);
        dialog.show();
        return dialog;
    }
}

