/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.activity;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.activity.FaceInEntryActivity;
import com.tencent.qcloud.facein.activity.IdCardRecognizeSuccessActivity;
import com.tencent.qcloud.facein.common.UserIdCardInfo;
import com.tencent.qcloud.facein.controler.IdCardRecognizeHelper;
import com.tencent.qcloud.facein.dialog.FaceInDialogs;
import com.tencent.qcloud.facein.hardware.QCloudCameraPreview;
import com.tencent.qcloud.facein.hardware.QCloudPictureCamera;
import com.tencent.qcloud.facein.pass.FaceInService;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeRequest;
import com.tencent.qcloud.facein.pass.model.IdCardRecognizeResult;
import com.tencent.qcloud.facein.pass.model.assist.IdCardMessage;
import com.tencent.qcloud.facein.ui.IdCardRecognizeMaskView;
import com.tencent.qcloud.facein.ui.IdCardRecognizeTopView;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.exception.QCloudException;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardRecognizeActivity
extends Activity {
    Logger logger = LoggerFactory.getLogger(IdCardRecognizeActivity.class);
    private QCloudPictureCamera camera;
    private QCloudCameraPreview preview;
    private IdCardRecognizeMaskView maskView;
    private IdCardRecognizeTopView topView;
    private FaceInService saasService;
    private Handler mainHandler;
    private volatile boolean success = false;
    int rotation;
    private int pattern;
    private IdCardRecognizeHelper recognizeHelper;
    private Dialog recognizingDialog;
    private boolean isScan;
    private int scanFailedTime;
    private long avaliableSeq = 0L;
    private Timer timer;
    private volatile boolean isScanBegin;
    private TimerTask task;
    private IdCardRecognizeHelper.IdCardRecognizeListener scanRecognizeListener = new IdCardRecognizeHelper.IdCardRecognizeListener(){

        @Override
        public void onSuccess(IdCardRecognizeRequest request, boolean isScan, boolean isFaceSide, IdCardRecognizeResult recognizeResult, String imagePath) {
            if (request == null) {
                return;
            }
            QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"scan success, the available seq is {}, the request seq is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.avaliableSeq, request.getRequestSeq()});
            if (request.getRequestSeq() < IdCardRecognizeActivity.this.avaliableSeq) {
                return;
            }
            if (isFaceSide && IdCardRecognizeActivity.this.pattern == 0) {
                IdCardMessage faceSideMessage = recognizeResult.getIdCardMessage();
                if (faceSideMessage != null) {
                    UserIdCardInfo.name = faceSideMessage.getName();
                    UserIdCardInfo.id = faceSideMessage.getId();
                    UserIdCardInfo.addr = faceSideMessage.getAddress();
                }
                if (IdCardRecognizeActivity.this.maskView != null) {
                    IdCardRecognizeActivity.this.maskView.setFaceImagePath(imagePath);
                }
                if (IdCardRecognizeActivity.this.topView != null) {
                    IdCardRecognizeActivity.this.topView.setFaceSideImagePath(imagePath);
                }
                QCloudLogger.info((Logger)IdCardRecognizeActivity.this.logger, (String)"id card face side scan recognize success");
                IdCardRecognizeActivity.this.pattern = 4;
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
                    }
                });
            } else if (!isFaceSide && IdCardRecognizeActivity.this.pattern == 1) {
                IdCardRecognizeActivity.this.pattern = 5;
                if (IdCardRecognizeActivity.this.maskView != null) {
                    IdCardRecognizeActivity.this.maskView.setBackImagePath(imagePath);
                } else {
                    QCloudLogger.warn((Logger)IdCardRecognizeActivity.this.logger, (String)"mask view is null");
                }
                if (IdCardRecognizeActivity.this.topView != null) {
                    IdCardRecognizeActivity.this.topView.setBackSideImagePath(imagePath);
                }
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IdCardRecognizeActivity.this.changePattern(5);
                    }
                });
                IdCardMessage backSideResult = recognizeResult.getIdCardMessage();
                if (backSideResult != null) {
                    UserIdCardInfo.authority = backSideResult.getAuthority();
                    UserIdCardInfo.date = backSideResult.getValidDate();
                }
                QCloudLogger.info((Logger)IdCardRecognizeActivity.this.logger, (String)"id card nation side scan recognize success.");
            }
        }

        @Override
        public void onFailed(IdCardRecognizeRequest request, boolean isScan, boolean isFaceSide, final QCloudException exception) {
            QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"scan failed, the available seq is {}, the request seq is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.avaliableSeq, request.getRequestSeq()});
            if (request.getRequestSeq() < IdCardRecognizeActivity.this.avaliableSeq) {
                return;
            }
            if (exception != null) {
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)("exception message is" + exception.getMessage()));
            }
            if (exception != null) {
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)IdCardRecognizeActivity.this, (CharSequence)exception.toString(), (int)0).show();
                    }
                });
            }
            if (isFaceSide && IdCardRecognizeActivity.this.pattern == 0) {
                IdCardRecognizeActivity.this.scanFailedTime++;
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"scan failed time is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.scanFailedTime});
                if (IdCardRecognizeActivity.this.scanFailedTime > 5) {
                    QCloudLogger.warn((Logger)IdCardRecognizeActivity.this.logger, (String)"face side scan failed");
                    IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            IdCardRecognizeActivity.this.maskView.setShowTip(false);
                            IdCardRecognizeActivity.this.maskView.stopAnimation();
                            IdCardRecognizeActivity.this.maskView.removeScanAnimation();
                            FaceInDialogs.idCardScanFailedDialog((Context)IdCardRecognizeActivity.this, new View.OnClickListener(){

                                public void onClick(View v) {
                                    IdCardRecognizeActivity.this.faceTake();
                                }
                            }, new View.OnClickListener(){

                                public void onClick(View v) {
                                    IdCardRecognizeActivity.this.faceScan();
                                }
                            });
                        }
                    });
                    IdCardRecognizeActivity.this.scanFailedTime = 0;
                } else {
                    IdCardRecognizeActivity.this.recognizeHelper.scan(isFaceSide, IdCardRecognizeActivity.this.getSeq(), IdCardRecognizeActivity.this.scanRecognizeListener);
                    QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"id card face side scan recognize failed. try again");
                }
            } else if (!isFaceSide && IdCardRecognizeActivity.this.pattern == 1) {
                IdCardRecognizeActivity.this.scanFailedTime++;
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"scan failed time is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.scanFailedTime});
                if (IdCardRecognizeActivity.this.scanFailedTime > 5) {
                    QCloudLogger.warn((Logger)IdCardRecognizeActivity.this.logger, (String)"nation side scan failed");
                    IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            IdCardRecognizeActivity.this.maskView.setShowTip(false);
                            IdCardRecognizeActivity.this.maskView.stopAnimation();
                            IdCardRecognizeActivity.this.maskView.removeScanAnimation();
                            FaceInDialogs.idCardScanFailedDialog((Context)IdCardRecognizeActivity.this, new View.OnClickListener(){

                                public void onClick(View v) {
                                    IdCardRecognizeActivity.this.nationTake();
                                }
                            }, new View.OnClickListener(){

                                public void onClick(View v) {
                                    IdCardRecognizeActivity.this.nationScan();
                                }
                            });
                        }
                    });
                    IdCardRecognizeActivity.this.scanFailedTime = 0;
                } else {
                    IdCardRecognizeActivity.this.recognizeHelper.scan(isFaceSide, IdCardRecognizeActivity.this.getSeq(), IdCardRecognizeActivity.this.scanRecognizeListener);
                    QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"id card nation side scan recognize failed. try again.");
                }
            }
        }
    };
    private IdCardRecognizeHelper.IdCardRecognizeListener takeRecognizeListener = new IdCardRecognizeHelper.IdCardRecognizeListener(){

        @Override
        public void onSuccess(IdCardRecognizeRequest request, boolean isScan, boolean isFaceSide, IdCardRecognizeResult recognizeResult, String imagePath) {
            QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"take success, the available seq is {}, the request seq is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.avaliableSeq, request.getRequestSeq()});
            if (request.getRequestSeq() < IdCardRecognizeActivity.this.avaliableSeq) {
                return;
            }
            if (isFaceSide && IdCardRecognizeActivity.this.pattern == 2) {
                IdCardMessage faceSideResult = recognizeResult.getIdCardMessage();
                if (faceSideResult != null) {
                    UserIdCardInfo.name = faceSideResult.getName();
                    UserIdCardInfo.id = faceSideResult.getId();
                    UserIdCardInfo.addr = faceSideResult.getAddress();
                }
                QCloudLogger.info((Logger)IdCardRecognizeActivity.this.logger, (String)"id card face side take photo recognize success");
                IdCardRecognizeActivity.this.pattern = 4;
                if (IdCardRecognizeActivity.this.maskView != null) {
                    IdCardRecognizeActivity.this.maskView.setFaceImagePath(imagePath);
                }
                if (IdCardRecognizeActivity.this.topView != null) {
                    IdCardRecognizeActivity.this.topView.setFaceSideImagePath(imagePath);
                }
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
                    }
                });
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (IdCardRecognizeActivity.this.recognizingDialog != null) {
                            IdCardRecognizeActivity.this.recognizingDialog.dismiss();
                        }
                    }
                });
            } else if (!isFaceSide && IdCardRecognizeActivity.this.pattern == 3) {
                IdCardRecognizeActivity.this.pattern = 5;
                if (IdCardRecognizeActivity.this.maskView != null) {
                    IdCardRecognizeActivity.this.maskView.setBackImagePath(imagePath);
                }
                if (IdCardRecognizeActivity.this.topView != null) {
                    IdCardRecognizeActivity.this.topView.setBackSideImagePath(imagePath);
                }
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        IdCardRecognizeActivity.this.changePattern(5);
                    }
                });
                IdCardMessage backSideResult = recognizeResult.getIdCardMessage();
                if (backSideResult != null) {
                    UserIdCardInfo.authority = backSideResult.getAuthority();
                    UserIdCardInfo.date = backSideResult.getValidDate();
                }
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (IdCardRecognizeActivity.this.recognizingDialog != null) {
                            IdCardRecognizeActivity.this.recognizingDialog.dismiss();
                        }
                    }
                });
                QCloudLogger.warn((Logger)IdCardRecognizeActivity.this.logger, (String)"id card nation side take photo recognize success");
            }
        }

        @Override
        public void onFailed(IdCardRecognizeRequest request, boolean isScan, boolean isFaceSide, final QCloudException exception) {
            QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"take failed, the available seq is {}, the request seq is {}", (Object[])new Object[]{IdCardRecognizeActivity.this.avaliableSeq, request.getRequestSeq()});
            if (request.getRequestSeq() < IdCardRecognizeActivity.this.avaliableSeq) {
                return;
            }
            if (exception != null) {
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Toast.makeText((Context)IdCardRecognizeActivity.this, (CharSequence)exception.toString(), (int)0).show();
                    }
                });
            }
            if (isFaceSide && IdCardRecognizeActivity.this.pattern == 2) {
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (IdCardRecognizeActivity.this.recognizingDialog != null) {
                            IdCardRecognizeActivity.this.recognizingDialog.dismiss();
                        }
                        IdCardRecognizeActivity.this.maskView.setShowTip(false);
                        FaceInDialogs.idCardScanFailedDialog((Context)IdCardRecognizeActivity.this, new View.OnClickListener(){

                            public void onClick(View v) {
                                IdCardRecognizeActivity.this.faceTake();
                            }
                        }, new View.OnClickListener(){

                            public void onClick(View v) {
                                IdCardRecognizeActivity.this.faceScan();
                            }
                        });
                    }
                });
                QCloudLogger.warn((Logger)IdCardRecognizeActivity.this.logger, (String)"id card face side take photo recognize failed.");
            } else if (!isFaceSide && IdCardRecognizeActivity.this.pattern == 3) {
                IdCardRecognizeActivity.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (IdCardRecognizeActivity.this.recognizingDialog != null) {
                            IdCardRecognizeActivity.this.recognizingDialog.dismiss();
                        }
                        IdCardRecognizeActivity.this.maskView.setShowTip(false);
                        FaceInDialogs.idCardScanFailedDialog((Context)IdCardRecognizeActivity.this, new View.OnClickListener(){

                            public void onClick(View v) {
                                IdCardRecognizeActivity.this.nationTake();
                            }
                        }, new View.OnClickListener(){

                            public void onClick(View v) {
                                IdCardRecognizeActivity.this.nationScan();
                            }
                        });
                    }
                });
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"id card nation side take photo recognize failed");
            }
        }
    };
    private long seq = 0L;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_id_card_recognize);
        this.success = false;
        this.scanFailedTime = 0;
        this.preview = (QCloudCameraPreview)this.findViewById(R.id.id_card_recognize_preview);
        this.maskView = (IdCardRecognizeMaskView)this.findViewById(R.id.id_card_recognize_mask_view);
        this.topView = (IdCardRecognizeTopView)this.findViewById(R.id.id_card_recognize_top_view);
        this.topView.prepare(this.maskView.getMaskViewRect());
        this.topView.onBackTextViewClicked(new View.OnClickListener(){

            public void onClick(View v) {
                IdCardRecognizeActivity.this.onBack();
            }
        });
        this.mainHandler = new Handler(this.getMainLooper());
        this.topView.onTakePhotoTextClicked(new View.OnClickListener(){

            public void onClick(View v) {
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"on take photo text clicked");
                if (IdCardRecognizeActivity.this.pattern == 0) {
                    IdCardRecognizeActivity.this.faceTake();
                } else if (IdCardRecognizeActivity.this.pattern == 1) {
                    IdCardRecognizeActivity.this.nationTake();
                }
            }
        });
        this.topView.onScanTextClicked(new View.OnClickListener(){

            public void onClick(View v) {
                QCloudLogger.debug((Logger)IdCardRecognizeActivity.this.logger, (String)"on scan text clicked");
                if (IdCardRecognizeActivity.this.pattern == 2) {
                    IdCardRecognizeActivity.this.faceScan();
                } else if (IdCardRecognizeActivity.this.pattern == 3) {
                    IdCardRecognizeActivity.this.nationScan();
                }
            }
        });
        this.rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        QCloudLogger.debug((Logger)this.logger, (String)"rotation is {}", (Object[])new Object[]{this.rotation});
        this.pattern = 0;
        this.topView.onRightBottomButtonClicked(new View.OnClickListener(){

            public void onClick(View v) {
                if (IdCardRecognizeActivity.this.pattern == 4) {
                    IdCardRecognizeActivity.this.nationScan();
                } else if (IdCardRecognizeActivity.this.pattern == 5) {
                    Intent intent = new Intent((Context)IdCardRecognizeActivity.this, IdCardRecognizeSuccessActivity.class);
                    IdCardRecognizeActivity.this.startActivity(intent);
                    IdCardRecognizeActivity.this.finish();
                }
            }
        });
        this.topView.onLeftBottomButtonClicked(new View.OnClickListener(){

            public void onClick(View v) {
                if (IdCardRecognizeActivity.this.pattern == 4) {
                    if (IdCardRecognizeActivity.this.isScan) {
                        IdCardRecognizeActivity.this.faceScan();
                    } else {
                        IdCardRecognizeActivity.this.faceTake();
                    }
                } else if (IdCardRecognizeActivity.this.pattern == 5) {
                    if (IdCardRecognizeActivity.this.isScan) {
                        IdCardRecognizeActivity.this.nationScan();
                    } else {
                        IdCardRecognizeActivity.this.nationTake();
                    }
                }
            }
        });
        this.topView.onTakePhotoClicked(new View.OnClickListener(){

            public void onClick(View v) {
                IdCardRecognizeActivity.this.recognizingDialog = FaceInDialogs.simpleProgressDialog((Context)IdCardRecognizeActivity.this);
                IdCardRecognizeActivity.this.recognizingDialog.show();
                IdCardRecognizeActivity.this.recognizeHelper.take(IdCardRecognizeActivity.this.isFaceSide(), IdCardRecognizeActivity.this.getSeq(), IdCardRecognizeActivity.this.takeRecognizeListener);
            }
        });
        this.task = new TimerTask(){

            @Override
            public void run() {
                if (IdCardRecognizeActivity.this.isScanBegin) {
                    IdCardRecognizeActivity.this.isScanBegin = false;
                    IdCardRecognizeActivity.this.scan(IdCardRecognizeActivity.this.isFaceSide());
                }
            }
        };
    }

    private boolean isFaceSide() {
        return this.pattern == 0 || this.pattern == 2;
    }

    private void changePattern(int pattern) {
        if (pattern == 0 || pattern == 1) {
            this.isScan = true;
        } else if (pattern == 2 || pattern == 3) {
            this.isScan = false;
        }
        this.pattern = pattern;
        this.topView.changePattern(pattern);
        this.maskView.changePattern(pattern);
    }

    private void faceScan() {
        this.isScanBegin = true;
        QCloudLogger.debug((Logger)this.logger, (String)"face scan, the available seq is {}", (Object[])new Object[]{this.avaliableSeq});
        this.avaliableSeq = this.seq();
        this.scanFailedTime = 0;
        this.maskView.setShowTip(true);
        this.pattern = 0;
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
            }
        });
        this.recognizeHelper.isCameraStarted();
    }

    private void nationScan() {
        this.isScanBegin = true;
        this.avaliableSeq = this.seq();
        QCloudLogger.debug((Logger)this.logger, (String)"nation scan, the available seq is {}", (Object[])new Object[]{this.avaliableSeq});
        this.scanFailedTime = 0;
        this.maskView.setShowTip(true);
        this.pattern = 1;
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
            }
        });
        this.recognizeHelper.isCameraStarted();
    }

    private void scan(boolean isFaceSide) {
        this.recognizeHelper.scan(isFaceSide, this.getSeq(), this.scanRecognizeListener);
    }

    private synchronized long getSeq() {
        return this.seq++;
    }

    private synchronized long seq() {
        return this.seq;
    }

    private synchronized void setSeq(long seq) {
        this.seq = seq;
    }

    private void faceTake() {
        this.isScanBegin = false;
        this.avaliableSeq = this.seq();
        QCloudLogger.debug((Logger)this.logger, (String)"face take, the available seq is {}", (Object[])new Object[]{this.avaliableSeq});
        this.scanFailedTime = 0;
        this.maskView.setShowTip(true);
        this.pattern = 2;
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
            }
        });
        this.recognizeHelper.isCameraStarted();
    }

    private void nationTake() {
        this.isScanBegin = false;
        this.avaliableSeq = this.seq();
        QCloudLogger.debug((Logger)this.logger, (String)"nation take, the available seq is {}", (Object[])new Object[]{this.avaliableSeq});
        this.scanFailedTime = 0;
        this.maskView.setShowTip(true);
        this.pattern = 3;
        this.mainHandler.post(new Runnable(){

            @Override
            public void run() {
                IdCardRecognizeActivity.this.changePattern(IdCardRecognizeActivity.this.pattern);
            }
        });
        this.recognizeHelper.isCameraStarted();
    }

    protected void onResume() {
        super.onResume();
        this.isScan = true;
        this.isScanBegin = true;
        this.saasService = new FaceInService((Context)this, FaceInConfig.getFaceInServiceConfig(), FaceInConfig.getCredentialProvider());
        this.avaliableSeq = 0L;
        this.recognizeHelper = new IdCardRecognizeHelper(this.saasService, this.preview, this.rotation);
        this.timer = new Timer();
        this.timer.schedule(this.task, 1000L, 2000L);
    }

    protected void onPause() {
        super.onPause();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.avaliableSeq = Long.MAX_VALUE;
        this.recognizeHelper.release();
        this.saasService.release();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void onBack() {
        Intent intent = new Intent((Context)this, FaceInEntryActivity.class);
        this.startActivity(intent);
        this.finish();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.onBack();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

