/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.facein.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.tencent.qcloud.facein.R;
import com.tencent.qcloud.facein.activity.IdCardRecognizeActivity;
import com.tencent.qcloud.facein.activity.IdCardRecognizeSampleActivity;
import com.tencent.qcloud.facein.common.LocalPathHelper;
import com.tencent.qcloud.facein.dialog.FaceInDialogs;
import com.tencent.qcloud.facein.tools.FileTools;
import com.tencent.qcloud.facein.user.FaceInConfig;
import com.tencent.qcloud.network.logger.QCloudLogger;
import java.util.LinkedList;
import java.util.List;

public class FaceInEntryActivity
extends Activity {
    private void requestPermissions() {
        LinkedList<String> permissions = new LinkedList<String>();
        this.addPermission(permissions, "android.permission.WRITE_EXTERNAL_STORAGE");
        this.addPermission(permissions, "android.permission.CAMERA");
        this.addPermission(permissions, "android.permission.RECORD_AUDIO");
        this.addPermission(permissions, "android.permission.INTERNET");
        if (!permissions.isEmpty()) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissions.toArray(new String[permissions.size()]), (int)0);
        }
    }

    private void addPermission(List<String> permissionList, String permission2) {
        if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) != 0) {
            permissionList.add(permission2);
        }
    }

    private boolean checkPermission(String permission2) {
        return ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
    }

    private boolean checkPermissions() {
        return this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE") && this.checkPermission("android.permission.RECORD_AUDIO") && this.checkPermission("android.permission.INTERNET") && this.checkPermission("android.permission.CAMERA");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_face_in_entry);
        this.requestPermissions();
        if (FaceInConfig.isDebug()) {
            QCloudLogger.enableDebug();
        } else {
            QCloudLogger.disableDebug();
        }
        TextView lookUpSample = (TextView)this.findViewById(R.id.look_up_example);
        lookUpSample.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)FaceInEntryActivity.this, IdCardRecognizeSampleActivity.class);
                FaceInEntryActivity.this.startActivity(intent);
                FaceInEntryActivity.this.finish();
            }
        });
        Button takePhoto = (Button)this.findViewById(R.id.start_take_photo_bt);
        takePhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FaceInEntryActivity.this.checkPermissions()) {
                    Intent intent = new Intent((Context)FaceInEntryActivity.this, IdCardRecognizeActivity.class);
                    FaceInEntryActivity.this.startActivity(intent);
                    FaceInEntryActivity.this.finish();
                } else {
                    FaceInDialogs.permissionCheckFailedDialog((Context)FaceInEntryActivity.this, new View.OnClickListener(){

                        public void onClick(View v) {
                            FaceInEntryActivity.this.requestPermissions();
                        }
                    });
                }
            }
        });
        TextView back = (TextView)this.findViewById(R.id.back);
        back.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaceInEntryActivity.this.finish();
            }
        });
        FileTools.deleteAllFiles(LocalPathHelper.getLocalImagePath());
        FileTools.deleteAllFiles(LocalPathHelper.getLocalVideoPath());
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.finish();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }
}

