/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.ci;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.GetObjectRequest;

public class PreviewDocumentRequest
extends GetObjectRequest {
    private int page;

    public PreviewDocumentRequest(String bucket, String cosPath, String savePath, int page) {
        this(bucket, cosPath, savePath, page + ".jpg", page);
    }

    public PreviewDocumentRequest(String bucket, String cosPath, String savePath, String fileName, int page) {
        super(bucket, cosPath, savePath, fileName);
        this.queryParameters.put("ci-process", "doc-preview");
        this.page = page;
        this.queryParameters.put("page", String.valueOf(page));
    }

    public PreviewDocumentRequest setSrcType(String srcType) {
        this.queryParameters.put("srcType", srcType);
        return this;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.page < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Please set a valid page number");
        }
    }

    @Override
    public String getMethod() {
        return "GET";
    }
}

