/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.tag.eventstreaming;

import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.tag.eventstreaming.Message;
import com.tencent.cos.xml.model.tag.eventstreaming.Prelude;
import com.tencent.cos.xml.model.tag.eventstreaming.Utils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class MessageDecoder {
    private static int defaultDecoderCapacity = 0x101400;
    private static int incrementDecoderCapacity = 524288;
    private ByteBuffer buf = ByteBuffer.allocate(defaultDecoderCapacity);

    public boolean hasPendingContent() {
        return this.buf.position() != 0;
    }

    public List<Message> feed(byte[] bytes) throws CosXmlServiceException {
        return this.feed(bytes, 0, bytes.length);
    }

    public List<Message> feed(byte[] bytes, int offset, int length) throws CosXmlServiceException {
        this.buf = this.safePut(this.buf, bytes, offset, length);
        ByteBuffer readView = (ByteBuffer)this.buf.duplicate().flip();
        int bytesConsumed = 0;
        ArrayList<Message> result = new ArrayList<Message>();
        while (readView.remaining() >= 15) {
            int totalMessageLength = Utils.toIntExact(Prelude.decode(readView.duplicate()).getTotalLength());
            if (readView.remaining() < totalMessageLength) break;
            Message decoded = Message.decode(readView);
            result.add(decoded);
            bytesConsumed += totalMessageLength;
        }
        if (bytesConsumed > 0) {
            this.buf.flip();
            this.buf.position(this.buf.position() + bytesConsumed);
            this.buf.compact();
        }
        return result;
    }

    private ByteBuffer safePut(ByteBuffer byteBuffer, byte[] bytes, int offset, int length) {
        if (byteBuffer.remaining() < length) {
            ByteBuffer newByteBuffer = ByteBuffer.allocate(byteBuffer.capacity() + incrementDecoderCapacity);
            this.byteBufferCopy(newByteBuffer, byteBuffer);
            newByteBuffer.put(bytes, offset, length);
            return newByteBuffer;
        }
        byteBuffer.put(bytes, offset, length);
        return byteBuffer;
    }

    private void byteBufferCopy(ByteBuffer dst, ByteBuffer src) {
        System.arraycopy(src.array(), 0, dst.array(), 0, src.position());
        dst.position(src.position());
    }
}

