/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.Tagging;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class PutObjectTaggingRequest
extends ObjectRequest {
    private String versionId;
    private Tagging tagging = new Tagging();

    public PutObjectTaggingRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public void addTag(String key, String value) {
        this.tagging.tagSet.addTag(new Tagging.Tag(key, value));
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("tagging", null);
        if (this.versionId != null) {
            this.queryParameters.put("versionId", this.versionId);
        }
        return super.getQueryString();
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildTagging(this.tagging));
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
    }
}

