/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.SimpleCosXml;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.GetObjectBytesRequest;
import com.tencent.cos.xml.model.object.GetObjectBytesResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PostObjectRequest;
import com.tencent.cos.xml.model.object.PostObjectResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.ResponseBytesConverter;
import com.tencent.cos.xml.transfer.ResponseFileBodySerializer;
import com.tencent.cos.xml.transfer.ResponseXmlS3BodySerializer;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudLifecycleCredentials;
import com.tencent.qcloud.core.auth.SessionQCloudCredentials;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudResultListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.QCloudHttpClient;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.LogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.net.UnknownHostException;
import java.util.List;

public class CosXmlSimpleService
implements SimpleCosXml {
    protected QCloudHttpClient client;
    protected QCloudCredentialProvider credentialProvider;
    protected String scheme;
    protected String region;
    protected String appid;
    protected String ip;
    protected String tag = "CosXml";
    public static String appCachePath;

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        QCloudLogger.addAdapter((LogAdapter)new FileLogAdapter(context, "QLog"));
        appCachePath = context.getApplicationContext().getExternalCacheDir().getPath();
        this.client = QCloudHttpClient.getDefault();
        this.client.addVerifiedHost("*.myqcloud.com");
        this.client.setDebuggable(configuration.isDebuggable());
        this.scheme = configuration.getProtocol();
        this.region = configuration.getRegion();
        this.appid = configuration.getAppid();
        this.ip = configuration.getIp();
        this.credentialProvider = qCloudCredentialProvider;
    }

    public void addCustomerDNS(String domainName, String[] ipList) throws CosXmlClientException {
        try {
            this.client.addDnsRecord(domainName, ipList);
        }
        catch (UnknownHostException e) {
            throw new CosXmlClientException(e);
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> QCloudHttpRequest buildHttpRequest(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException {
        cosXmlRequest.checkParameters();
        String headerHost = cosXmlRequest.getHost(this.appid, this.region);
        QCloudHttpRequest.Builder httpRequestBuilder = new QCloudHttpRequest.Builder().method(cosXmlRequest.getMethod()).scheme(this.scheme).host(this.ip == null ? headerHost : this.ip).path(cosXmlRequest.getPath()).addHeader("Host", headerHost).userAgent(CosXmlServiceConfig.DEFAULT_USER_AGENT).tag((Object)this.tag);
        if (this.credentialProvider == null) {
            httpRequestBuilder.signer(null, null);
        } else if (cosXmlRequest instanceof PostObjectRequest) {
            httpRequestBuilder.signer(null, null);
            QCloudLifecycleCredentials qCloudLifecycleCredentials = null;
            try {
                qCloudLifecycleCredentials = (QCloudLifecycleCredentials)this.credentialProvider.getCredentials();
            }
            catch (QCloudClientException e) {
                throw new CosXmlClientException(e);
            }
            ((PostObjectRequest)cosXmlRequest).setSecretIdAndKey(qCloudLifecycleCredentials.getSecretId(), qCloudLifecycleCredentials.getSignKey(), qCloudLifecycleCredentials.getKeyTime());
            if (this.credentialProvider instanceof SessionQCloudCredentials) {
                SessionQCloudCredentials sessionQCloudCredentials = (SessionQCloudCredentials)this.credentialProvider;
                httpRequestBuilder.addHeader("x-cos-security-token", sessionQCloudCredentials.getToken());
            }
        } else {
            httpRequestBuilder.signer("CosXmlSigner", cosXmlRequest.getSignSourceProvider());
        }
        httpRequestBuilder.query(cosXmlRequest.getQueryString());
        httpRequestBuilder.addHeaders(cosXmlRequest.getRequestHeaders());
        if (cosXmlRequest.isNeedMD5()) {
            httpRequestBuilder.contentMD5();
        }
        if (cosXmlRequest.getRequestBody() != null) {
            httpRequestBuilder.body(cosXmlRequest.getRequestBody());
        }
        if (cosXmlRequest instanceof GetObjectRequest) {
            String absolutePath = ((GetObjectRequest)cosXmlRequest).getDownloadPath();
            httpRequestBuilder.converter(new ResponseFileBodySerializer((GetObjectResult)cosXmlResult, absolutePath, 0L));
        } else if (cosXmlRequest instanceof GetObjectBytesRequest) {
            httpRequestBuilder.converter(new ResponseBytesConverter((GetObjectBytesResult)cosXmlResult));
        } else {
            httpRequestBuilder.converter(new ResponseXmlS3BodySerializer(cosXmlResult));
        }
        QCloudHttpRequest httpRequest = httpRequestBuilder.build();
        return httpRequest;
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> T2 execute(T1 cosXmlRequest, T2 cosXmlResult) throws CosXmlClientException, CosXmlServiceException {
        try {
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = cosXmlRequest instanceof PostObjectRequest ? this.client.resolveRequest(httpRequest, null) : this.client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            return (T2)((CosXmlResult)((HttpResult)httpTask.executeNow()).content());
        }
        catch (QCloudServiceException e) {
            throw (CosXmlServiceException)e;
        }
        catch (QCloudClientException e) {
            throw new CosXmlClientException(e);
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void schedule(final T1 cosXmlRequest, T2 cosXmlResult, final CosXmlResultListener cosXmlResultListener) {
        QCloudResultListener qCloudResultListener = new QCloudResultListener<HttpResult<T2>>(){

            public void onSuccess(HttpResult<T2> result) {
                cosXmlResultListener.onSuccess(cosXmlRequest, (CosXmlResult)result.content());
            }

            public void onFailure(QCloudClientException clientException, QCloudServiceException serviceException) {
                if (clientException != null) {
                    cosXmlResultListener.onFail(cosXmlRequest, new CosXmlClientException((Throwable)clientException), null);
                } else {
                    cosXmlResultListener.onFail(cosXmlRequest, null, (CosXmlServiceException)serviceException);
                }
            }
        };
        try {
            QCloudHttpRequest httpRequest = this.buildHttpRequest(cosXmlRequest, cosXmlResult);
            HttpTask httpTask = cosXmlRequest instanceof PostObjectRequest ? this.client.resolveRequest(httpRequest, null) : this.client.resolveRequest(httpRequest, this.credentialProvider);
            cosXmlRequest.setTask(httpTask);
            if (cosXmlRequest instanceof AppendObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PutObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PutObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof UploadPartRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((UploadPartRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof GetObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((GetObjectRequest)cosXmlRequest).getProgressListener());
            } else if (cosXmlRequest instanceof PostObjectRequest) {
                httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
            }
            httpTask.schedule().addResultListener(qCloudResultListener);
        }
        catch (QCloudClientException e) {
            cosXmlResultListener.onFail(cosXmlRequest, new CosXmlClientException(e), null);
        }
    }

    public String getAccessUrl(CosXmlRequest cosXmlRequest) {
        String host = cosXmlRequest.getHost(this.appid, this.region);
        String path = cosXmlRequest.getPath();
        return host + path;
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new InitMultipartUploadResult());
    }

    @Override
    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new InitMultipartUploadResult(), cosXmlResultListener);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new ListPartsResult());
    }

    @Override
    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListPartsResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartResult uploadPart(UploadPartRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new UploadPartResult());
    }

    @Override
    public void uploadPartAsync(UploadPartRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new UploadPartResult(), cosXmlResultListener);
    }

    @Override
    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new AbortMultiUploadResult());
    }

    @Override
    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new AbortMultiUploadResult(), cosXmlResultListener);
    }

    @Override
    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, completeMultiUploadResult);
    }

    @Override
    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, completeMultiUploadResult, cosXmlResultListener);
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteObjectResult());
    }

    @Override
    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteObjectResult(), cosXmlResultListener);
    }

    @Override
    public GetObjectResult getObject(GetObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetObjectResult());
    }

    @Override
    public void getObjectAsync(GetObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectResult(), cosXmlResultListener);
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        return this.execute(request, putObjectResult);
    }

    @Override
    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl(request);
        this.schedule(request, putObjectResult, cosXmlResultListener);
    }

    @Override
    public PostObjectResult postObject(PostObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PostObjectResult postObjectResult = new PostObjectResult();
        return this.execute(request, postObjectResult);
    }

    @Override
    public void postObjectAsync(PostObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PostObjectResult postObjectResult = new PostObjectResult();
        this.schedule(request, postObjectResult, cosXmlResultListener);
    }

    @Override
    public byte[] getObject(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        GetObjectBytesRequest getObjectBytesRequest = new GetObjectBytesRequest(bucketName, objectName);
        GetObjectBytesResult getObjectBytesResult = this.execute(getObjectBytesRequest, new GetObjectBytesResult());
        return getObjectBytesResult != null ? getObjectBytesResult.data : new byte[]{};
    }

    @Override
    public void cancel(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && cosXmlRequest.getHttpTask() != null) {
            cosXmlRequest.getHttpTask().cancel();
        }
    }

    @Override
    public void cancelAll() {
        List tasks = this.client.getTasksByTag(this.tag);
        for (HttpTask task : tasks) {
            task.cancel();
        }
    }

    @Override
    public void release() {
        this.cancelAll();
    }

    public String getAppid() {
        return this.appid;
    }

    public String getRegion() {
        return this.region;
    }
}

