/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.util.LinkedList;
import java.util.List;

public class NetworkMonitor {
    static final int MSG_DISCONNECT = 300;
    static final int MSG_CONNECT = 400;
    private NetworkInfoReceiver networkInfoReceiver;
    static final String INTENT_ACTION_TRANSFER_ADD = "add_transfer";
    private boolean isReceiverNotRegistered = true;
    private HandlerThread handlerThread;
    private Handler updateHandler;
    private List<NetworkListener> networkListeners = new LinkedList<NetworkListener>();

    NetworkMonitor() {
    }

    void addNetworkListener(NetworkListener networkListener) {
        this.networkListeners.add(networkListener);
    }

    void removeNetworkListener(NetworkListener networkListener) {
        this.networkListeners.remove(networkListener);
    }

    synchronized void register(Context context) {
        if (this.isReceiverNotRegistered) {
            QCloudLogger.i((String)"TransferUtility", (String)"registering receiver", (Object[])new Object[0]);
            this.handlerThread = new HandlerThread("COSTransferUpdateHandlerThread");
            this.handlerThread.start();
            this.setHandlerLooper(context, this.handlerThread.getLooper());
            try {
                context.registerReceiver((BroadcastReceiver)this.networkInfoReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            }
            catch (IllegalArgumentException iae) {
                QCloudLogger.w((String)"TransferUtility", (String)"Ignoring the exception trying to register the receiver for connectivity change.", (Object[])new Object[0]);
            }
            catch (IllegalStateException ise) {
                QCloudLogger.w((String)"TransferUtility", (String)"Ignoring the leak in registering the receiver.", (Object[])new Object[0]);
            }
            finally {
                this.isReceiverNotRegistered = false;
            }
        }
    }

    void unregister(Context context) {
        try {
            if (this.networkInfoReceiver != null) {
                QCloudLogger.i((String)"TransferUtility", (String)"unregistering receiver", (Object[])new Object[0]);
                context.unregisterReceiver((BroadcastReceiver)this.networkInfoReceiver);
                this.isReceiverNotRegistered = true;
            }
        }
        catch (IllegalArgumentException iae) {
            QCloudLogger.w((String)"TransferUtility", (String)"exception trying to destroy the service", (Object[])new Object[0]);
        }
    }

    private void notifyNetworkDisconnect() {
        QCloudLogger.i((String)"TransferUtility", (String)"pause transfer on network disconnect", (Object[])new Object[0]);
        for (NetworkListener listener : this.networkListeners) {
            listener.onDisconnect();
        }
    }

    private void notifyNetworkReconnect() {
        QCloudLogger.i((String)"TransferUtility", (String)"resume transfer on network reconnect", (Object[])new Object[0]);
        for (NetworkListener listener : this.networkListeners) {
            listener.onReconnect();
        }
    }

    private void setHandlerLooper(Context context, Looper looper) {
        this.updateHandler = new UpdateHandler(looper);
        this.networkInfoReceiver = new NetworkInfoReceiver(context.getApplicationContext(), this.updateHandler);
    }

    static interface NetworkListener {
        public void onReconnect();

        public void onDisconnect();
    }

    static class NetworkInfoReceiver
    extends BroadcastReceiver {
        private final Handler handler;
        private final ConnectivityManager connManager;

        public NetworkInfoReceiver(Context context, Handler handler) {
            this.handler = handler;
            this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                boolean networkConnected = this.isNetworkConnected();
                QCloudLogger.i((String)"TransferUtility", (String)("Network connected: " + networkConnected), (Object[])new Object[0]);
                this.handler.sendEmptyMessage(networkConnected ? 400 : 300);
            }
        }

        boolean isNetworkConnected() {
            NetworkInfo info = this.connManager.getActiveNetworkInfo();
            return info != null && info.isConnected();
        }
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (msg.what == 400) {
                NetworkMonitor.this.notifyNetworkReconnect();
            } else if (msg.what == 300) {
                NetworkMonitor.this.notifyNetworkDisconnect();
            }
        }
    }
}

