/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.StringUtils;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.AuthConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenerateGetObjectURLUtils {
    public static String getObjectUrl(boolean isHttps, String appid, String bucket, String region, String cosPath) throws CosXmlClientException {
        StringBuilder urlBuilder = new StringBuilder();
        if (StringUtils.isEmpty(appid) || StringUtils.isEmpty(bucket) || StringUtils.isEmpty(region) || StringUtils.isEmpty(cosPath)) {
            throw new CosXmlClientException("appid or bucket or or region or cosPath must not be null");
        }
        if (isHttps) {
            urlBuilder.append("https").append("://");
        } else {
            urlBuilder.append("http").append("://");
        }
        urlBuilder.append(bucket).append("-").append(appid).append(".");
        urlBuilder.append("cos").append(".").append(region).append(".").append("myqcloud.com");
        if (!cosPath.startsWith("/")) {
            cosPath = "/" + cosPath;
        }
        urlBuilder.append(URLEncodeUtils.cosPathEncode(cosPath));
        return urlBuilder.toString();
    }

    public static String getRequestUrlWithSign(boolean isHttps, String httpMethod, Map<String, String> headers, Map<String, String> queryParameters, String appid, String bucket, String region, String cosPath, long duration, QCloudAPI qCloudAPI) throws CosXmlClientException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(GenerateGetObjectURLUtils.getObjectUrl(isHttps, appid, bucket, region, cosPath));
        urlBuilder.append("?");
        String sign = GenerateGetObjectURLUtils.getSign(httpMethod, headers, queryParameters, cosPath, duration, qCloudAPI);
        urlBuilder.append(sign);
        return urlBuilder.toString();
    }

    public static String getObjectUrlWithSign(boolean isHttps, Map<String, String> headers, Map<String, String> queryParameters, String appid, String bucket, String region, String cosPath, long duration, QCloudAPI qCloudAPI) throws CosXmlClientException {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(GenerateGetObjectURLUtils.getObjectUrl(isHttps, appid, bucket, region, cosPath));
        urlBuilder.append("?sign=");
        String sign = GenerateGetObjectURLUtils.getSign("get", headers, queryParameters, cosPath, duration, qCloudAPI);
        sign = URLEncodeUtils.cosPathEncode(sign);
        urlBuilder.append(sign);
        return urlBuilder.toString();
    }

    public static String getSign(String httpMethod, String cosPath, Map<String, String> headers, Map<String, String> queryParameters, String signTime, String keyTime, String secretId, String signKey) throws CosXmlClientException {
        StringBuilder formatString = new StringBuilder(httpMethod.trim().toLowerCase());
        formatString.append("\n");
        if (!cosPath.startsWith("/")) {
            cosPath = "/" + cosPath;
        }
        formatString.append(cosPath);
        formatString.append("\n");
        String[] sortQueryParameters = GenerateGetObjectURLUtils.sort(queryParameters, false);
        if (sortQueryParameters != null) {
            formatString.append(sortQueryParameters[1]);
        }
        formatString.append("\n");
        String[] sortHeaders = GenerateGetObjectURLUtils.sort(headers, true);
        if (headers != null) {
            formatString.append(sortHeaders[1]);
        }
        formatString.append("\n");
        StringBuilder stringToSign = new StringBuilder();
        stringToSign.append("sha1");
        stringToSign.append("\n");
        stringToSign.append(signTime);
        stringToSign.append("\n");
        String formatStringSha1 = DigestUtils.getSha1(formatString.toString());
        stringToSign.append(formatStringSha1);
        stringToSign.append("\n");
        String signature = DigestUtils.getHmacSha1(stringToSign.toString(), signKey);
        StringBuilder authorization = new StringBuilder();
        authorization.append(AuthConstants.Q_SIGN_ALGORITHM).append("=").append(AuthConstants.SHA1).append("&").append(AuthConstants.Q_AK).append("=").append(secretId).append("&").append(AuthConstants.Q_SIGN_TIME).append("=").append(signTime).append("&").append(AuthConstants.Q_KEY_TIME).append("=").append(keyTime).append("&").append(AuthConstants.Q_HEADER_LIST).append("=").append(sortHeaders != null ? sortHeaders[0] : "").append("&").append(AuthConstants.Q_URL_PARAM_LIST).append("=").append(sortQueryParameters != null ? sortQueryParameters[0] : "").append("&").append(AuthConstants.Q_SIGNATURE).append("=").append(signature);
        return authorization.toString();
    }

    private static String getSign(String httpMethod, Map<String, String> headers, Map<String, String> queryParameters, String cosPath, long signDuration, QCloudAPI qCloudAPI) throws CosXmlClientException {
        String secretId = qCloudAPI.getSecretId();
        String secretKey = qCloudAPI.getSecretKey();
        long keyDuration = qCloudAPI.getKeyDuration();
        if (keyDuration <= 0L) {
            keyDuration = signDuration;
        }
        long current = System.currentTimeMillis() / 1000L;
        long expired = current + keyDuration;
        String keyTime = current + ";" + expired;
        String signKey = DigestUtils.getHmacSha1(keyTime, secretKey);
        long currentTime = System.currentTimeMillis() / 1000L;
        long expiredTime = currentTime + signDuration;
        String signTime = currentTime + ";" + expiredTime;
        return GenerateGetObjectURLUtils.getSign(httpMethod, cosPath, headers, queryParameters, signTime, keyTime, secretId, signKey);
    }

    private static String[] sort(Map<String, String> maps, boolean isHeader) throws CosXmlClientException {
        if (maps == null) {
            return null;
        }
        LinkedHashMap<String, String> temp = new LinkedHashMap<String, String>();
        if (isHeader) {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                temp.put(entry.getKey().toLowerCase().trim(), URLEncodeUtils.cosPathEncode(entry.getValue().trim()));
            }
        } else {
            for (Map.Entry<String, String> entry : maps.entrySet()) {
                temp.put(entry.getKey().toLowerCase().trim(), entry.getValue().toLowerCase().trim());
            }
        }
        ArrayList list = new ArrayList(temp.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Object>>(){

            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        StringBuilder keyStringBuilder = new StringBuilder();
        StringBuilder valueStringBuilder = new StringBuilder();
        for (Map.Entry entry : list) {
            keyStringBuilder.append((String)entry.getKey()).append(";");
            valueStringBuilder.append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        keyStringBuilder.deleteCharAt(keyStringBuilder.length() - 1);
        valueStringBuilder.deleteCharAt(valueStringBuilder.length() - 1);
        String[] strings = new String[]{keyStringBuilder.toString(), valueStringBuilder.toString()};
        return strings;
    }

    public static interface QCloudAPI {
        public String getSecretKey();

        public String getSecretId();

        public long getKeyDuration();

        @Deprecated
        public String getSessionToken();
    }
}

