/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.COSStorageClass;
import com.tencent.cos.xml.common.MetaDataDirective;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.http.RequestBodySerializer;

public class CopyObjectRequest
extends ObjectRequest {
    private CopySourceStruct copySourceStruct;

    public CopyObjectRequest(String bucket, String cosPath, CopySourceStruct copySourceStruct) throws CosXmlClientException {
        super(bucket, cosPath);
        this.copySourceStruct = copySourceStruct;
        this.setCopySource(copySourceStruct);
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        return RequestBodySerializer.bytes(null, (byte[])new byte[0]);
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.copySourceStruct == null) {
            throw new CosXmlClientException("copy source must not be null");
        }
        this.copySourceStruct.checkParameters();
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setCopySource(CopySourceStruct copySource) throws CosXmlClientException {
        this.copySourceStruct = copySource;
        if (this.copySourceStruct != null) {
            this.addHeader("x-cos-copy-source", this.copySourceStruct.getSource());
        }
    }

    public String getCopySource() {
        return this.copySourceStruct.toString();
    }

    public void setCopyMetaDataDirective(MetaDataDirective metaDataDirective) {
        if (metaDataDirective != null) {
            this.addHeader("x-cos-metadata-directive", metaDataDirective.getMetaDirective());
        }
    }

    public void setCopyIfModifiedSince(String sourceIfModifiedSince) {
        if (sourceIfModifiedSince != null) {
            this.addHeader("x-cos-copy-source-If-Modified-Since", sourceIfModifiedSince);
        }
    }

    public void setCopyIfUnmodifiedSince(String sourceIfUnmodifiedSince) {
        if (sourceIfUnmodifiedSince != null) {
            this.addHeader("x-cos-copy-source-If-Unmodified-Since", sourceIfUnmodifiedSince);
        }
    }

    public void setCopyIfMatch(String eTag) {
        if (eTag != null) {
            this.addHeader("x-cos-copy-source-If-Match", eTag);
        }
    }

    public void setCopyIfNoneMatch(String eTag) {
        if (eTag != null) {
            this.addHeader("x-cos-copy-source-If-None-Match", eTag);
        }
    }

    public void setCosStorageClass(COSStorageClass cosStorageClass) {
        if (cosStorageClass != null) {
            this.addHeader("x-cos-storage-class", cosStorageClass.getStorageClass());
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public static class CopySourceStruct {
        public String appid;
        public String bucket;
        public String region;
        public String cosPath;
        public String versionId;

        public CopySourceStruct(String appid, String bucket, String region, String cosPath) {
            this.appid = appid;
            this.bucket = bucket;
            this.region = region;
            this.cosPath = cosPath;
        }

        public CopySourceStruct(String appid, String bucket, String region, String cosPath, String versionId) {
            this.appid = appid;
            this.bucket = bucket;
            this.region = region;
            this.cosPath = cosPath;
            this.versionId = versionId;
        }

        public void checkParameters() throws CosXmlClientException {
            if (this.bucket == null) {
                throw new CosXmlClientException("copy source bucket must not be null");
            }
            if (this.cosPath == null) {
                throw new CosXmlClientException("copy source cosPath must not be null");
            }
            if (this.appid == null) {
                throw new CosXmlClientException("copy source appid must not be null");
            }
            if (this.region == null) {
                throw new CosXmlClientException("copy source region must not be null");
            }
            this.cosPath = URLEncodeUtils.cosPathEncode(this.cosPath);
        }

        public String getSource() throws CosXmlClientException {
            if (this.cosPath != null && !this.cosPath.startsWith("/")) {
                this.cosPath = "/" + this.cosPath;
            }
            this.cosPath = URLEncodeUtils.cosPathEncode(this.cosPath);
            StringBuilder copySource = new StringBuilder();
            if (this.bucket.endsWith("-" + this.appid)) {
                copySource.append(this.bucket).append(".");
            } else {
                copySource.append(this.bucket).append("-").append(this.appid).append(".");
            }
            copySource.append("cos").append(".").append(this.region).append(".").append("myqcloud.com").append(this.cosPath);
            if (this.versionId != null) {
                copySource.append("?versionId=").append(this.versionId);
            }
            return copySource.toString();
        }
    }
}

