/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.tag;

import java.util.Set;

public class InventoryConfiguration {
    public String id;
    public boolean isEnabled;
    public String includedObjectVersions;
    public Filter filter;
    public OptionalFields optionalFields;
    public Schedule schedule;
    public Destination destination;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{InventoryConfiguration:\n");
        stringBuilder.append("Id").append(this.id).append("\n");
        stringBuilder.append("IsEnabled:").append(this.isEnabled).append("\n");
        if (this.destination != null) {
            stringBuilder.append(this.destination.toString()).append("\n");
        }
        if (this.schedule != null) {
            stringBuilder.append(this.schedule.toString()).append("\n");
        }
        if (this.filter != null) {
            stringBuilder.append(this.filter.toString()).append("\n");
        }
        stringBuilder.append("IncludedObjectVersions:").append(this.includedObjectVersions).append("\n");
        if (this.optionalFields != null) {
            stringBuilder.append(this.optionalFields.toString()).append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static enum Frequency {
        DAILY("Daily");

        String value;

        private Frequency(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum IncludedObjectVersions {
        ALL("ALL"),
        CURRENT("Current");

        private String desc;

        private IncludedObjectVersions(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum Field {
        SIZE("Size"),
        LastModified_Date("LastModifiedDate"),
        StroageClass("StorageClass"),
        ETAG("Etag"),
        IS_MULTIPARTUPLOADed("IsMultipartUploaded"),
        REPLICATION_STATUS("ReplicationStatus");

        String value;

        private Field(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Encryption {
        public String sSECOS;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{Encryption:\n");
            stringBuilder.append("SSE-COS:").append(this.sSECOS).append("\n");
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class COSBucketDestination {
        public String format;
        public String accountId;
        public String bucket;
        public String prefix;
        public Encryption encryption;

        public void setBucket(String region, String bucket) {
            if (region != null && bucket != null) {
                this.bucket = String.format("qcs::cos:%s::%s", region, bucket);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{COSBucketDestination:\n");
            stringBuilder.append("Format:").append(this.format).append("\n");
            stringBuilder.append("AccountId:").append(this.accountId).append("\n");
            stringBuilder.append("Bucket:").append(this.bucket).append("\n");
            stringBuilder.append("Prefix:").append(this.prefix).append("\n");
            if (this.encryption != null) {
                stringBuilder.append(this.encryption.toString()).append("\n");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class Destination {
        public COSBucketDestination cosBucketDestination;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{Destination:\n");
            if (this.cosBucketDestination != null) {
                stringBuilder.append(this.cosBucketDestination.toString()).append("\n");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class Schedule {
        public String frequency;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{Schedule:\n");
            stringBuilder.append("Frequency:").append(this.frequency).append("\n");
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class OptionalFields {
        public Set<String> fields;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{OptionalFields:\n");
            if (this.fields != null) {
                for (String field : this.fields) {
                    stringBuilder.append("Field:").append(field).append("\n");
                }
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    public static class Filter {
        public String prefix;

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("{Filter:\n");
            stringBuilder.append("Prefix:").append(this.prefix).append("\n");
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

