/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.BaseMultipartUploadRequest;
import com.tencent.cos.xml.model.tag.CompleteMultipartUpload;
import com.tencent.cos.xml.transfer.XmlSlimBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class CompleteMultiUploadRequest
extends BaseMultipartUploadRequest {
    private CompleteMultipartUpload completeMultipartUpload;
    private String uploadId;

    public CompleteMultiUploadRequest(String bucket, String cosPath, String uploadId, Map<Integer, String> partNumberAndETag) {
        super(bucket, cosPath);
        this.uploadId = uploadId;
        this.completeMultipartUpload = new CompleteMultipartUpload();
        this.completeMultipartUpload.parts = new ArrayList<CompleteMultipartUpload.Part>();
        this.setPartNumberAndETag(partNumberAndETag);
    }

    public CompleteMultiUploadRequest() {
        super(null, null);
        this.completeMultipartUpload = new CompleteMultipartUpload();
        this.completeMultipartUpload.parts = new ArrayList<CompleteMultipartUpload.Part>();
    }

    public CompleteMultipartUpload getCompleteMultipartUpload() {
        return this.completeMultipartUpload;
    }

    public void setPartNumberAndETag(int partNumbers, String eTag) {
        CompleteMultipartUpload.Part part = new CompleteMultipartUpload.Part();
        part.partNumber = partNumbers;
        part.eTag = eTag;
        this.completeMultipartUpload.parts.add(part);
    }

    public void setPartNumberAndETag(Map<Integer, String> partNumberAndETag) {
        if (partNumberAndETag != null) {
            for (Map.Entry<Integer, String> entry : partNumberAndETag.entrySet()) {
                CompleteMultipartUpload.Part part = new CompleteMultipartUpload.Part();
                part.partNumber = entry.getKey();
                part.eTag = entry.getValue();
                this.completeMultipartUpload.parts.add(part);
            }
        }
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("uploadId", this.uploadId);
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.bytes((String)"application/xml", (byte[])XmlSlimBuilder.buildCompleteMultipartUpload(this.completeMultipartUpload).getBytes("utf-8"));
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.requestURL != null) {
            return;
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "uploadID must not be null");
        }
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

