/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.MTAProxy;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.CosError;
import com.tencent.cos.xml.transfer.XmlSlimParser;
import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParserException;

public class ResponseXmlS3BodySerializer<T>
extends ResponseBodyConverter<T> {
    private CosXmlResult cosXmlResult;

    public ResponseXmlS3BodySerializer(CosXmlResult cosXmlResult) {
        this.cosXmlResult = cosXmlResult;
    }

    public T convert(HttpResponse response) throws QCloudClientException, QCloudServiceException {
        this.parseCOSXMLError(response);
        this.cosXmlResult.parseResponseBody(response);
        return (T)this.cosXmlResult;
    }

    private void parseCOSXMLError(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        int httpCode = response.code();
        if (httpCode >= 200 && httpCode < 300) {
            return;
        }
        String message = response.message();
        CosXmlServiceException cosXmlServiceException = new CosXmlServiceException(message);
        cosXmlServiceException.setStatusCode(httpCode);
        cosXmlServiceException.setRequestId(response.header("x-cos-request-id"));
        InputStream inputStream = response.byteStream();
        if (inputStream != null) {
            CosError cosError = new CosError();
            try {
                XmlSlimParser.parseError(inputStream, cosError);
                if (cosError.code != null) {
                    cosXmlServiceException.setErrorCode(cosError.code);
                }
                if (cosError.message != null) {
                    cosXmlServiceException.setErrorMessage(cosError.message);
                }
                if (cosError.requestId != null) {
                    cosXmlServiceException.setRequestId(cosError.requestId);
                }
                if (cosError.resource != null) {
                    cosXmlServiceException.setServiceName(cosError.resource);
                }
            }
            catch (XmlPullParserException e) {
                String reportMessage = String.format(Locale.ENGLISH, "%d %s", ClientErrorCode.SERVERERROR.getCode(), e.getCause() == null ? ((Object)((Object)e)).getClass().getSimpleName() : e.getCause().getClass().getSimpleName());
                MTAProxy.getInstance().reportCosXmlClientException(ResponseXmlS3BodySerializer.class.getSimpleName(), reportMessage);
                throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
            }
            catch (IOException e) {
                String reportMessage = String.format(Locale.ENGLISH, "%d %s", ClientErrorCode.IO_ERROR.getCode(), e.getCause() == null ? e.getClass().getSimpleName() : e.getCause().getClass().getSimpleName());
                MTAProxy.getInstance().reportCosXmlClientException(ResponseXmlS3BodySerializer.class.getSimpleName(), reportMessage);
                throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
            }
        }
        MTAProxy.getInstance().reportCosXmlServerException(ResponseXmlS3BodySerializer.class.getSimpleName(), String.format(Locale.ENGLISH, "%s %s", cosXmlServiceException.getStatusCode(), cosXmlServiceException.getErrorCode()));
        throw cosXmlServiceException;
    }
}

