/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.UploadPartCopyRequest;
import com.tencent.cos.xml.model.object.UploadPartCopyResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class COSXMLCopyTask
extends COSXMLTask {
    protected long multiCopySizeDivision;
    private CopyObjectRequest.CopySourceStruct copySourceStruct;
    private long fileLength;
    private HeadObjectRequest headObjectRequest;
    private CopyObjectRequest copyObjectRequest;
    private boolean isLargeCopy = false;
    private String uploadId;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    protected long sliceSize;
    private Map<Integer, CopyPartStruct> copyPartStructMap;
    private List<UploadPartCopyRequest> uploadPartCopyRequestList;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private AtomicBoolean IS_EXIT = new AtomicBoolean(false);
    private AtomicInteger UPLOAD_PART_COUNT;
    private Object SYNC_UPLOAD_PART = new Object();
    private LargeCopyStateListener largeCopyStateListenerHandler = new LargeCopyStateListener(){

        @Override
        public void onInit() {
            COSXMLCopyTask.this.uploadPartCopy(COSXMLCopyTask.this.cosXmlService);
        }

        @Override
        public void onListParts() {
            COSXMLCopyTask.this.uploadPartCopy(COSXMLCopyTask.this.cosXmlService);
        }

        @Override
        public void onUploadPartCopy() {
            COSXMLCopyTask.this.completeMultiUpload(COSXMLCopyTask.this.cosXmlService);
        }

        @Override
        public void onCompleted(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
            COSXMLCopyTask.this.updateState(TransferState.COMPLETED, null, cosXmlResult, false);
        }

        @Override
        public void onFailed(CosXmlRequest cosXmlRequest, CosXmlClientException exception, CosXmlServiceException serviceException) {
            Object causeException = exception == null ? serviceException : exception;
            COSXMLCopyTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
        }
    };

    COSXMLCopyTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct) {
        this.cosXmlService = cosXmlService;
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.copySourceStruct = copySourceStruct;
    }

    COSXMLCopyTask(CosXmlSimpleService cosXmlService, CopyObjectRequest copyObjectRequest) {
        this(cosXmlService, copyObjectRequest.getRegion(), copyObjectRequest.getBucket(), copyObjectRequest.getPath(cosXmlService.getConfig()), copyObjectRequest.getCopySource());
        this.queries = copyObjectRequest.getQueryString();
        this.headers = copyObjectRequest.getRequestHeaders();
        this.isNeedMd5 = copyObjectRequest.isNeedMD5();
    }

    protected void copy() {
        this.run();
    }

    private void smallFileCopy() {
        this.copyObjectRequest = new CopyObjectRequest(this.bucket, this.cosPath, this.copySourceStruct);
        this.copyObjectRequest.setRegion(this.region);
        this.copyObjectRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.copyObjectRequest.setSign(this.onSignatureListener.onGetSign(this.copyObjectRequest));
        }
        this.getHttpMetrics(this.copyObjectRequest, "CopyObjectRequest");
        this.cosXmlService.copyObjectAsync(this.copyObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                COSXMLCopyTask.this.updateState(TransferState.COMPLETED, null, result, false);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                Object causeException = exception == null ? serviceException : exception;
                COSXMLCopyTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
            }
        });
    }

    private void largeFileCopy(CosXmlSimpleService cosXmlService) {
        this.initCopyPart();
        if (this.uploadId == null) {
            this.initMultiUpload(cosXmlService);
        } else {
            this.listMultiUpload(cosXmlService);
        }
    }

    private void initMultiUpload(CosXmlSimpleService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        this.initMultipartUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.initMultipartUploadRequest.setSign(this.onSignatureListener.onGetSign(this.initMultipartUploadRequest));
        }
        this.getHttpMetrics(this.initMultipartUploadRequest, "InitMultipartUploadRequest");
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.uploadId = ((InitMultipartUploadResult)result).initMultipartUpload.uploadId;
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onInit();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private synchronized void initCopyPart() {
        CopyPartStruct slicePartStruct;
        int i;
        int count = (int)(this.fileLength / this.sliceSize);
        for (i = 1; i < count; ++i) {
            slicePartStruct = new CopyPartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.start = (long)(i - 1) * this.sliceSize;
            slicePartStruct.end = (long)i * this.sliceSize - 1L;
            this.copyPartStructMap.put(i, slicePartStruct);
        }
        slicePartStruct = new CopyPartStruct();
        slicePartStruct.isAlreadyUpload = false;
        slicePartStruct.partNumber = i;
        slicePartStruct.start = (long)(i - 1) * this.sliceSize;
        slicePartStruct.end = this.fileLength - 1L;
        this.copyPartStructMap.put(i, slicePartStruct);
        this.UPLOAD_PART_COUNT.set(i);
    }

    private void listMultiUpload(CosXmlSimpleService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        this.listPartsRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.listPartsRequest.setSign(this.onSignatureListener.onGetSign(this.listPartsRequest));
        }
        this.getHttpMetrics(this.listPartsRequest, "ListPartsRequest");
        cosXmlService.listPartsAsync(this.listPartsRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.updateSlicePart((ListPartsResult)result);
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onListParts();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.copyPartStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                CopyPartStruct slicePartStruct = this.copyPartStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
            }
        }
    }

    private void uploadPartCopy(CosXmlSimpleService cosXmlService) {
        boolean isCopyFinished = true;
        for (Map.Entry<Integer, CopyPartStruct> entry : this.copyPartStructMap.entrySet()) {
            final CopyPartStruct copyPartStruct = entry.getValue();
            if (copyPartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isCopyFinished = false;
            UploadPartCopyRequest uploadPartCopyRequest = new UploadPartCopyRequest(this.bucket, this.cosPath, copyPartStruct.partNumber, this.uploadId, this.copySourceStruct, copyPartStruct.start, copyPartStruct.end);
            uploadPartCopyRequest.setRegion(this.region);
            uploadPartCopyRequest.setRequestHeaders(this.headers);
            if (this.onSignatureListener != null) {
                uploadPartCopyRequest.setSign(this.onSignatureListener.onGetSign(uploadPartCopyRequest));
            }
            this.getHttpMetrics(uploadPartCopyRequest, "UploadPartCopyRequest");
            this.uploadPartCopyRequestList.add(uploadPartCopyRequest);
            cosXmlService.copyObjectAsync(uploadPartCopyRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    if (COSXMLCopyTask.this.IS_EXIT.get()) {
                        return;
                    }
                    copyPartStruct.eTag = ((UploadPartCopyResult)result).copyObject.eTag;
                    copyPartStruct.isAlreadyUpload = true;
                    Object object = COSXMLCopyTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        COSXMLCopyTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (COSXMLCopyTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            COSXMLCopyTask.this.largeCopyStateListenerHandler.onUploadPartCopy();
                        }
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (COSXMLCopyTask.this.IS_EXIT.get()) {
                        return;
                    }
                    COSXMLCopyTask.this.IS_EXIT.set(true);
                    COSXMLCopyTask.this.largeCopyStateListenerHandler.onFailed(request, exception, serviceException);
                }
            });
        }
        if (isCopyFinished && !this.IS_EXIT.get()) {
            this.largeCopyStateListenerHandler.onUploadPartCopy();
        }
    }

    private void completeMultiUpload(CosXmlSimpleService cosXmlService) {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, CopyPartStruct> entry : this.copyPartStructMap.entrySet()) {
            CopyPartStruct copyPartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(copyPartStruct.partNumber, copyPartStruct.eTag);
        }
        this.completeMultiUploadRequest.setNeedMD5(this.isNeedMd5);
        this.completeMultiUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.completeMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(this.completeMultiUploadRequest));
        }
        this.getHttpMetrics(this.completeMultiUploadRequest, "CompleteMultiUploadRequest");
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onCompleted(request, result);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                COSXMLCopyTask.this.largeCopyStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void cancelAllRequest(CosXmlSimpleService cosXmlService) {
        if (this.headObjectRequest != null) {
            cosXmlService.cancel(this.headObjectRequest);
            this.headObjectRequest = null;
        }
        if (this.copyObjectRequest != null) {
            cosXmlService.cancel(this.copyObjectRequest);
            this.copyObjectRequest = null;
        }
        if (this.initMultipartUploadRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.initMultipartUploadRequest = null;
        }
        if (this.listPartsRequest != null) {
            cosXmlService.cancel(this.listPartsRequest);
            this.listPartsRequest = null;
        }
        if (this.uploadPartCopyRequestList != null) {
            for (UploadPartCopyRequest uploadPartCopyRequest : this.uploadPartCopyRequestList) {
                cosXmlService.cancel(uploadPartCopyRequest);
            }
        }
        if (this.completeMultiUploadRequest != null) {
            cosXmlService.cancel(this.completeMultiUploadRequest);
            this.completeMultiUploadRequest = null;
        }
    }

    private void abortMultiUpload(CosXmlSimpleService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        if (this.onSignatureListener != null) {
            abortMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(abortMultiUploadRequest));
        }
        this.getHttpMetrics(abortMultiUploadRequest, "AbortMultiUploadRequest");
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    private void clear() {
        if (this.uploadPartCopyRequestList != null) {
            this.uploadPartCopyRequestList.clear();
        }
        if (this.copyPartStructMap != null) {
            this.copyPartStructMap.clear();
        }
    }

    @Override
    protected void internalCompleted() {
        this.clear();
    }

    @Override
    protected void internalFailed() {
        this.cancelAllRequest(this.cosXmlService);
    }

    @Override
    protected void internalPause() {
        this.cancelAllRequest(this.cosXmlService);
    }

    @Override
    protected void internalCancel() {
        this.cancelAllRequest(this.cosXmlService);
        if (this.isLargeCopy) {
            this.abortMultiUpload(this.cosXmlService);
        }
    }

    @Override
    protected void internalResume() {
        this.taskState = TransferState.WAITING;
        this.IS_EXIT.set(false);
        this.copy();
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest() {
        COSXMLCopyTaskRequest cosxmlCopyTaskRequest = new COSXMLCopyTaskRequest(this.region, this.bucket, this.cosPath, this.copySourceStruct, this.headers, this.queries);
        return cosxmlCopyTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLCopyTaskResult cosxmlCopyTaskResult = new COSXMLCopyTaskResult();
        if (sourceResult != null && sourceResult instanceof CopyObjectResult) {
            CopyObjectResult copyObjectResult = (CopyObjectResult)sourceResult;
            cosxmlCopyTaskResult.httpCode = copyObjectResult.httpCode;
            cosxmlCopyTaskResult.httpMessage = copyObjectResult.httpMessage;
            cosxmlCopyTaskResult.headers = copyObjectResult.headers;
            cosxmlCopyTaskResult.eTag = copyObjectResult.copyObject.eTag;
            cosxmlCopyTaskResult.accessUrl = copyObjectResult.accessUrl;
        } else if (sourceResult != null && sourceResult instanceof CompleteMultiUploadResult) {
            CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)sourceResult;
            cosxmlCopyTaskResult.httpCode = completeMultiUploadResult.httpCode;
            cosxmlCopyTaskResult.httpMessage = completeMultiUploadResult.httpMessage;
            cosxmlCopyTaskResult.headers = completeMultiUploadResult.headers;
            cosxmlCopyTaskResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
            cosxmlCopyTaskResult.accessUrl = completeMultiUploadResult.accessUrl;
        }
        return cosxmlCopyTaskResult;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    protected void run() {
        this.headObjectRequest = new HeadObjectRequest(this.copySourceStruct.bucket, this.copySourceStruct.cosPath);
        this.headObjectRequest.setRegion(this.copySourceStruct.region);
        if (this.onSignatureListener != null) {
            this.headObjectRequest.setSign(this.onSignatureListener.onGetSign(this.headObjectRequest));
        }
        this.getHttpMetrics(this.headObjectRequest, "HeadObjectRequest");
        this.headObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.updateState(TransferState.IN_PROGRESS, null, null, false);
            }
        });
        this.cosXmlService.headObjectAsync(this.headObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                List<String> contentLengths = result.headers.get("Content-Length");
                if (contentLengths != null && contentLengths.size() > 0) {
                    COSXMLCopyTask.this.fileLength = Long.parseLong(contentLengths.get(0));
                }
                if (COSXMLCopyTask.this.fileLength > COSXMLCopyTask.this.multiCopySizeDivision) {
                    COSXMLCopyTask.this.isLargeCopy = true;
                    if (COSXMLCopyTask.this.copyPartStructMap != null) {
                        COSXMLCopyTask.this.copyPartStructMap.clear();
                    } else {
                        COSXMLCopyTask.this.copyPartStructMap = new LinkedHashMap();
                    }
                    if (COSXMLCopyTask.this.uploadPartCopyRequestList != null) {
                        COSXMLCopyTask.this.uploadPartCopyRequestList.clear();
                    } else {
                        COSXMLCopyTask.this.uploadPartCopyRequestList = new ArrayList();
                    }
                    if (COSXMLCopyTask.this.UPLOAD_PART_COUNT != null) {
                        COSXMLCopyTask.this.UPLOAD_PART_COUNT.set(0);
                    } else {
                        COSXMLCopyTask.this.UPLOAD_PART_COUNT = new AtomicInteger(0);
                    }
                    COSXMLCopyTask.this.largeFileCopy(COSXMLCopyTask.this.cosXmlService);
                } else {
                    COSXMLCopyTask.this.smallFileCopy();
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLCopyTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLCopyTask.this.IS_EXIT.set(true);
                Object causeException = exception == null ? serviceException : exception;
                COSXMLCopyTask.this.updateState(TransferState.FAILED, (Exception)causeException, null, false);
            }
        });
    }

    public static class COSXMLCopyTaskRequest
    extends CopyObjectRequest {
        protected COSXMLCopyTaskRequest(String region, String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, copySourceStruct);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }

    public static class COSXMLCopyTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLCopyTaskResult() {
        }
    }

    private static class CopyPartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long start;
        public long end;
        public String eTag;

        private CopyPartStruct() {
        }
    }

    private static interface LargeCopyStateListener {
        public void onInit();

        public void onListParts();

        public void onUploadPartCopy();

        public void onCompleted(CosXmlRequest var1, CosXmlResult var2);

        public void onFailed(CosXmlRequest var1, CosXmlClientException var2, CosXmlServiceException var3);
    }
}

