/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.COSXMLUploadTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.File;
import java.util.List;
import java.util.Map;

public final class COSXMLDownloadTask
extends COSXMLTask {
    private static final String TAG = COSXMLUploadTask.class.getSimpleName();
    private String localSaveDirPath;
    private String localSaveFileName;
    private long rangeStart = 0L;
    private long rangeEnd = -1L;
    private long fileOffset = 0L;
    private String eTag;
    private long hasWriteDataLen = 0L;
    private HeadObjectRequest headObjectRequest;
    private GetObjectRequest getObjectRequest;
    private SharedPreferences sharedPreferences;

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String localSaveDirPath, String localSaveFileName) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.localSaveDirPath = localSaveDirPath;
        this.localSaveFileName = localSaveFileName;
        this.cosXmlService = cosXmlService;
        if (context != null) {
            this.sharedPreferences = context.getSharedPreferences("COSXMLDOWNLOADTASK", 0);
        }
    }

    COSXMLDownloadTask(Context context, CosXmlSimpleService cosXmlService, GetObjectRequest getObjectRequest) {
        this(context, cosXmlService, getObjectRequest.getRegion(), getObjectRequest.getBucket(), getObjectRequest.getPath(cosXmlService.getConfig()), getObjectRequest.getSavePath(), getObjectRequest.getSaveFileName());
        this.queries = getObjectRequest.getQueryString();
        this.headers = getObjectRequest.getRequestHeaders();
        this.isNeedMd5 = getObjectRequest.isNeedMD5();
        if (this.headers != null && this.headers.containsKey("Range")) {
            List ranges = (List)this.headers.get("Range");
            String range = (String)ranges.get(0);
            int index1 = range.indexOf("=");
            int index2 = range.indexOf("-");
            this.rangeStart = Long.valueOf(range.substring(index1 + 1, index2));
            String end = range.substring(index2 + 1);
            if (!TextUtils.isEmpty((CharSequence)end)) {
                this.rangeEnd = Long.valueOf(end);
            }
        }
        this.fileOffset = getObjectRequest.getFileOffset();
    }

    protected void download() {
        this.run();
    }

    private void realDownload(long rangeStart, long rangeEnd, long fileOffset) {
        this.getObjectRequest = new GetObjectRequest(this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName);
        this.getObjectRequest.setRegion(this.region);
        if (rangeEnd > 0L || rangeStart > 0L) {
            this.getObjectRequest.setRange(rangeStart, rangeEnd);
        }
        this.getObjectRequest.setFileOffset(fileOffset);
        this.getObjectRequest.setQueryParameters(this.queries);
        this.getObjectRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.getObjectRequest.setSign(this.onSignatureListener.onGetSign(this.getObjectRequest));
        }
        this.getHttpMetrics(this.getObjectRequest, "GetObjectRequest");
        this.getObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                    COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(COSXMLDownloadTask.this.hasWriteDataLen + complete, COSXMLDownloadTask.this.hasWriteDataLen + target);
                }
            }
        });
        this.cosXmlService.getObjectAsync(this.getObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLDownloadTask.this.updateState(TransferState.COMPLETED)) {
                    COSXMLDownloadTask.this.clear();
                    QCloudLogger.d((String)TAG, (String)COSXMLDownloadTask.this.taskState.name(), (Object[])new Object[0]);
                    COSXMLDownloadTask.this.mResult = COSXMLDownloadTask.this.buildCOSXMLTaskResult(result);
                    if (COSXMLDownloadTask.this.cosXmlResultListener != null) {
                        COSXMLDownloadTask.this.cosXmlResultListener.onSuccess(COSXMLDownloadTask.this.buildCOSXMLTaskRequest(request), COSXMLDownloadTask.this.mResult);
                    }
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (exception != null && exception.getMessage().toUpperCase().contains("CANCELED")) {
                    return;
                }
                if (COSXMLDownloadTask.this.updateState(TransferState.FAILED)) {
                    Object object = COSXMLDownloadTask.this.mException = exception == null ? serviceException : exception;
                    if (COSXMLDownloadTask.this.cosXmlResultListener != null) {
                        COSXMLDownloadTask.this.cosXmlResultListener.onFail(COSXMLDownloadTask.this.buildCOSXMLTaskRequest(request), exception, serviceException);
                    }
                }
            }
        });
    }

    @Override
    public void pause() {
        if (this.updateState(TransferState.PAUSED)) {
            QCloudLogger.d((String)TAG, (String)this.taskState.name(), (Object[])new Object[0]);
            this.cosXmlService.cancel(this.headObjectRequest);
            this.headObjectRequest = null;
            this.cosXmlService.cancel(this.getObjectRequest);
            this.getObjectRequest = null;
        }
    }

    @Override
    public void cancel() {
        if (this.updateState(TransferState.CANCELED)) {
            QCloudLogger.d((String)TAG, (String)this.taskState.name(), (Object[])new Object[0]);
            CosXmlClientException cosXmlClientException = new CosXmlClientException(ClientErrorCode.USER_CANCELLED.getCode(), "canceled by user");
            this.mException = cosXmlClientException;
            this.clear();
            if (this.cosXmlResultListener != null) {
                this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(null), cosXmlClientException, null);
            }
            this.cosXmlService.cancel(this.headObjectRequest);
            this.headObjectRequest = null;
            this.cosXmlService.cancel(this.getObjectRequest);
            this.getObjectRequest = null;
        }
    }

    @Override
    public void resume() {
        if (this.updateState(TransferState.RESUMED_WAITING)) {
            QCloudLogger.d((String)TAG, (String)this.taskState.name(), (Object[])new Object[0]);
            this.download();
        }
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest(CosXmlRequest sourceRequest) {
        COSXMLDownloadTaskRequest cosxmlDownloadTaskRequest = new COSXMLDownloadTaskRequest(this.region, this.bucket, this.cosPath, this.localSaveDirPath, this.localSaveFileName, this.headers, this.queries);
        return cosxmlDownloadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLDownloadTaskResult cosxmlDownloadTaskResult = new COSXMLDownloadTaskResult();
        if (sourceResult != null) {
            cosxmlDownloadTaskResult.httpCode = sourceResult.httpCode;
            cosxmlDownloadTaskResult.httpMessage = sourceResult.httpMessage;
            cosxmlDownloadTaskResult.headers = sourceResult.headers;
            cosxmlDownloadTaskResult.eTag = this.eTag;
            cosxmlDownloadTaskResult.accessUrl = sourceResult.accessUrl;
        }
        return cosxmlDownloadTaskResult;
    }

    private String getKey() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("download").append("_").append(this.region).append("_").append(this.bucket).append("_").append(this.cosPath).append("_").append(this.rangeStart).append("_").append(this.rangeEnd).append("_").append(this.fileOffset).append("_").append(this.localSaveDirPath).append("_").append(this.localSaveFileName).append("_").append(this.eTag);
        try {
            return DigestUtils.getSha1(stringBuffer.toString());
        }
        catch (CosXmlClientException e) {
            return stringBuffer.toString();
        }
    }

    private synchronized String hasExisted() {
        if (this.sharedPreferences != null) {
            return this.sharedPreferences.getString(this.getKey(), null);
        }
        return null;
    }

    private synchronized void clear() {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().remove(this.getKey()).commit();
        }
    }

    private synchronized void save(String absolutePath) {
        if (this.sharedPreferences != null) {
            this.sharedPreferences.edit().putString(this.getKey(), absolutePath).commit();
        }
    }

    private String getDownloadPath() {
        String path = null;
        if (this.localSaveDirPath != null) {
            path = !this.localSaveDirPath.endsWith("/") ? this.localSaveDirPath + "/" : this.localSaveDirPath;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.localSaveFileName != null) {
                path = path + this.localSaveFileName;
                return path;
            }
            if (this.cosPath != null) {
                int separator = this.cosPath.lastIndexOf("/");
                path = separator >= 0 ? path + this.cosPath.substring(separator + 1) : path + this.cosPath;
            }
        }
        return path;
    }

    protected void run() {
        this.updateState(TransferState.WAITING);
        QCloudLogger.d((String)TAG, (String)this.taskState.name(), (Object[])new Object[0]);
        this.headObjectRequest = new HeadObjectRequest(this.bucket, this.cosPath);
        this.headObjectRequest.setRegion(this.region);
        if (this.onSignatureListener != null) {
            this.headObjectRequest.setSign(this.onSignatureListener.onGetSign(this.headObjectRequest));
        }
        this.getHttpMetrics(this.headObjectRequest, "HeadObjectRequest");
        this.headObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (state == 2) {
                    COSXMLDownloadTask.this.updateState(TransferState.IN_PROGRESS);
                    QCloudLogger.d((String)TAG, (String)COSXMLDownloadTask.this.taskState.name(), (Object[])new Object[0]);
                }
            }
        });
        this.cosXmlService.headObjectAsync(this.headObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                File file;
                String absolutePath;
                List<String> eTags = result.headers.get("ETag");
                if (eTags != null && eTags.size() > 0) {
                    COSXMLDownloadTask.this.eTag = eTags.get(0);
                }
                if ((absolutePath = COSXMLDownloadTask.this.hasExisted()) != null && (file = new File(absolutePath)).exists()) {
                    long fileLength = file.length();
                    List<String> contentLengths = result.headers.get("Content-Length");
                    if (contentLengths != null && contentLengths.size() > 0 && Long.valueOf(contentLengths.get(0)) == fileLength) {
                        if (COSXMLDownloadTask.this.updateState(TransferState.COMPLETED)) {
                            if (COSXMLDownloadTask.this.cosXmlProgressListener != null) {
                                COSXMLDownloadTask.this.cosXmlProgressListener.onProgress(fileLength, fileLength);
                            }
                            if (COSXMLDownloadTask.this.cosXmlResultListener != null) {
                                COSXMLDownloadTask.this.cosXmlResultListener.onSuccess(request, result);
                            }
                        }
                        COSXMLDownloadTask.this.clear();
                        return;
                    }
                    COSXMLDownloadTask.this.hasWriteDataLen = fileLength - COSXMLDownloadTask.this.fileOffset;
                    COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart + COSXMLDownloadTask.this.hasWriteDataLen, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset + COSXMLDownloadTask.this.hasWriteDataLen);
                    return;
                }
                COSXMLDownloadTask.this.save(COSXMLDownloadTask.this.getDownloadPath());
                COSXMLDownloadTask.this.hasWriteDataLen = 0L;
                COSXMLDownloadTask.this.realDownload(COSXMLDownloadTask.this.rangeStart, COSXMLDownloadTask.this.rangeEnd, COSXMLDownloadTask.this.fileOffset);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (exception != null && exception.getMessage().toUpperCase().contains("CANCELED")) {
                    return;
                }
                if (COSXMLDownloadTask.this.updateState(TransferState.FAILED)) {
                    Object object = COSXMLDownloadTask.this.mException = exception == null ? serviceException : exception;
                    if (COSXMLDownloadTask.this.cosXmlResultListener != null) {
                        COSXMLDownloadTask.this.cosXmlResultListener.onFail(COSXMLDownloadTask.this.buildCOSXMLTaskRequest(request), exception, serviceException);
                    }
                }
            }
        });
    }

    public static class COSXMLDownloadTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLDownloadTaskResult() {
        }
    }

    public static class COSXMLDownloadTaskRequest
    extends GetObjectRequest {
        protected COSXMLDownloadTaskRequest(String region, String bucket, String cosPath, String savePath, String saveFileName, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, savePath, saveFileName);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }
}

