package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.AccessControlPolicy;
import com.tencent.cos.xml.transfer.XmlParser;
import com.tencent.qcloud.core.http.HttpResponse;

import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

/**
 * <p>
 * 获取Bucket的ACL结果
 * </p>
 *
 * @see AccessControlPolicy
 */
final public class GetBucketACLResult extends CosXmlResult {

    public AccessControlPolicy accessControlPolicy;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        accessControlPolicy = new AccessControlPolicy();
        try {
            XmlParser.parseAccessControlPolicy(response.byteStream(), accessControlPolicy);
        } catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
        } catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
        }
    }

    @Override
    public String printResult() {
        return accessControlPolicy != null ? accessControlPolicy.toString() : super.printResult();
    }
}
