/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferStateListener;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import java.util.List;
import java.util.Map;

public abstract class COSXMLTask {
    protected CosXmlSimpleService cosXmlService;
    protected String region;
    protected String bucket;
    protected String cosPath;
    protected CosXmlResult mResult;
    protected Exception mException;
    protected Map<String, String> queries;
    protected Map<String, List<String>> headers;
    protected boolean isNeedMd5 = true;
    protected CosXmlProgressListener cosXmlProgressListener;
    protected CosXmlResultListener cosXmlResultListener;
    protected TransferStateListener transferStateListener;
    protected TransferState taskState = TransferState.WAITING;
    protected OnSignatureListener onSignatureListener;
    protected OnGetHttpTaskMetrics onGetHttpTaskMetrics;

    protected void setCosXmlService(CosXmlSimpleService cosXmlService) {
        this.cosXmlService = cosXmlService;
    }

    public void setCosXmlProgressListener(CosXmlProgressListener cosXmlProgressListener) {
        this.cosXmlProgressListener = cosXmlProgressListener;
    }

    public void setCosXmlResultListener(CosXmlResultListener cosXmlResultListener) {
        this.cosXmlResultListener = cosXmlResultListener;
        if (cosXmlResultListener != null) {
            if (this.mResult != null) {
                cosXmlResultListener.onSuccess(this.buildCOSXMLTaskRequest(null), this.mResult);
            }
            if (this.mException != null) {
                if (this.mException instanceof CosXmlClientException) {
                    cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(null), (CosXmlClientException)((Object)this.mException), null);
                } else {
                    cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(null), null, (CosXmlServiceException)((Object)this.mException));
                }
            }
        }
    }

    public void setTransferStateListener(TransferStateListener transferStateListener) {
        this.transferStateListener = transferStateListener;
        if (this.transferStateListener != null) {
            this.transferStateListener.onStateChanged(this.taskState);
        }
    }

    public void setOnSignatureListener(OnSignatureListener onSignatureListener) {
        this.onSignatureListener = onSignatureListener;
    }

    public void setOnGetHttpTaskMetrics(OnGetHttpTaskMetrics onGetHttpTaskMetrics) {
        this.onGetHttpTaskMetrics = onGetHttpTaskMetrics;
    }

    protected void getHttpMetrics(CosXmlRequest cosXmlRequest, final String requestName) {
        if (this.onGetHttpTaskMetrics != null) {
            cosXmlRequest.attachMetrics(new HttpTaskMetrics(){

                public void onDataReady() {
                    super.onDataReady();
                    COSXMLTask.this.onGetHttpTaskMetrics.onGetHttpMetrics(requestName, this);
                }
            });
        }
    }

    public abstract void pause();

    public abstract void cancel();

    public abstract void resume();

    public TransferState getTaskState() {
        return this.taskState;
    }

    public CosXmlResult getResult() {
        return this.mResult;
    }

    public Exception getException() {
        return this.mException;
    }

    protected abstract CosXmlRequest buildCOSXMLTaskRequest(CosXmlRequest var1);

    protected abstract CosXmlResult buildCOSXMLTaskResult(CosXmlResult var1);

    protected synchronized boolean updateState(TransferState newTaskState) {
        switch (newTaskState) {
            case WAITING: {
                if (this.taskState != TransferState.WAITING) {
                    this.taskState = TransferState.WAITING;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case IN_PROGRESS: {
                if (this.taskState == TransferState.WAITING) {
                    this.taskState = TransferState.IN_PROGRESS;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case COMPLETED: {
                if (this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.COMPLETED;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case FAILED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.FAILED;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case PAUSED: {
                if (this.taskState == TransferState.WAITING || this.taskState == TransferState.IN_PROGRESS) {
                    this.taskState = TransferState.PAUSED;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case CANCELED: {
                if (this.taskState != TransferState.CANCELED && this.taskState != TransferState.COMPLETED) {
                    this.taskState = TransferState.CANCELED;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
            case RESUMED_WAITING: {
                if (this.taskState == TransferState.PAUSED || this.taskState == TransferState.FAILED) {
                    this.taskState = TransferState.RESUMED_WAITING;
                    if (this.transferStateListener != null) {
                        this.transferStateListener.onStateChanged(this.taskState);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static interface OnGetHttpTaskMetrics {
        public void onGetHttpMetrics(String var1, HttpTaskMetrics var2);
    }

    @Deprecated
    public static interface OnSignatureListener {
        public String onGetSign(CosXmlRequest var1);
    }
}

