/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class COSXMLUploadTask
extends COSXMLTask
implements Runnable {
    protected long multiUploadSizeDivision;
    private String srcPath;
    private long fileLength;
    private PutObjectRequest putObjectRequest;
    private boolean isSliceUpload = false;
    protected long sliceSize;
    private String uploadId;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private AtomicBoolean IS_EXIT;
    private Object SYNC_UPLOAD_PART = new Object();
    private static ExecutorService executorService = Executors.newSingleThreadExecutor();
    private MultiUploadsStateListener multiUploadsStateListenerHandler = new MultiUploadsStateListener(){

        @Override
        public void onInit() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onListParts() {
            COSXMLUploadTask.this.multiUploadPart(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onUploadParts() {
            COSXMLUploadTask.this.completeMultiUpload(COSXMLUploadTask.this.cosXmlService);
        }

        @Override
        public void onCompleted(CosXmlRequest cosXmlRequest, CosXmlResult cosXmlResult) {
            COSXMLUploadTask.this.IS_EXIT.set(true);
            if (COSXMLUploadTask.this.updateState(TransferState.COMPLETED)) {
                COSXMLUploadTask.this.mResult = COSXMLUploadTask.this.buildCOSXMLTaskResult(cosXmlResult);
                if (COSXMLUploadTask.this.cosXmlResultListener != null) {
                    COSXMLUploadTask.this.cosXmlResultListener.onSuccess(COSXMLUploadTask.this.buildCOSXMLTaskRequest(cosXmlRequest), COSXMLUploadTask.this.mResult);
                }
            }
        }

        @Override
        public void onFailed(CosXmlRequest cosXmlRequest, CosXmlClientException exception, CosXmlServiceException serviceException) {
            COSXMLUploadTask.this.IS_EXIT.set(true);
            if (COSXMLUploadTask.this.updateState(TransferState.FAILED)) {
                Object object = COSXMLUploadTask.this.mException = exception == null ? serviceException : exception;
                if (COSXMLUploadTask.this.cosXmlResultListener != null) {
                    COSXMLUploadTask.this.cosXmlResultListener.onFail(COSXMLUploadTask.this.buildCOSXMLTaskRequest(COSXMLUploadTask.this.buildCOSXMLTaskRequest(cosXmlRequest)), exception, serviceException);
                }
                COSXMLUploadTask.this.cancelAllRequest(COSXMLUploadTask.this.cosXmlService);
            }
        }
    };

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, String region, String bucket, String cosPath, String srcPath, String uploadId) {
        this.region = region;
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.srcPath = srcPath;
        this.uploadId = uploadId;
        this.cosXmlService = cosXmlService;
    }

    COSXMLUploadTask(CosXmlSimpleService cosXmlService, PutObjectRequest putObjectRequest, String uploadId) {
        this(cosXmlService, putObjectRequest.getRegion(), putObjectRequest.getHostPrefix(), putObjectRequest.getPath(cosXmlService.getConfig()), putObjectRequest.getSrcPath(), uploadId);
        this.queries = putObjectRequest.getQueryString();
        this.headers = putObjectRequest.getRequestHeaders();
        this.cosXmlSignSourceProvider = putObjectRequest.getSignSourceProvider();
        this.isNeedMd5 = putObjectRequest.isNeedMD5();
    }

    protected void upload() {
        this.run();
    }

    private void simpleUpload(CosXmlSimpleService cosXmlService) {
        this.putObjectRequest = new PutObjectRequest(this.bucket, this.cosPath, this.srcPath);
        this.putObjectRequest.setRegion(this.region);
        this.putObjectRequest.setNeedMD5(this.isNeedMd5);
        this.putObjectRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.putObjectRequest.setSign(this.onSignatureListener.onGetSign(this.putObjectRequest));
        } else {
            this.putObjectRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
        }
        this.putObjectRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (state == 2) {
                    COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS);
                }
            }
        });
        this.putObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                if (COSXMLUploadTask.this.cosXmlProgressListener != null) {
                    COSXMLUploadTask.this.cosXmlProgressListener.onProgress(complete, target);
                }
            }
        });
        cosXmlService.putObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLUploadTask.this.updateState(TransferState.COMPLETED)) {
                    COSXMLUploadTask.this.mResult = COSXMLUploadTask.this.buildCOSXMLTaskResult(result);
                    if (COSXMLUploadTask.this.cosXmlResultListener != null) {
                        COSXMLUploadTask.this.cosXmlResultListener.onSuccess(COSXMLUploadTask.this.buildCOSXMLTaskRequest(null), COSXMLUploadTask.this.mResult);
                    }
                }
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (exception != null && exception.getMessage().toUpperCase().contains("CANCELED")) {
                    return;
                }
                if (COSXMLUploadTask.this.updateState(TransferState.FAILED)) {
                    Object object = COSXMLUploadTask.this.mException = exception == null ? serviceException : exception;
                    if (COSXMLUploadTask.this.cosXmlResultListener != null) {
                        COSXMLUploadTask.this.cosXmlResultListener.onFail(COSXMLUploadTask.this.buildCOSXMLTaskRequest(request), exception, serviceException);
                    }
                }
            }
        });
    }

    private void multiUpload(CosXmlSimpleService cosXmlService) {
        this.initSlicePart();
        if (this.uploadId != null) {
            this.listMultiUpload(cosXmlService);
        } else {
            this.initMultiUpload(cosXmlService);
        }
    }

    private void initMultiUpload(CosXmlSimpleService cosXmlService) {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.initMultipartUploadRequest.setRegion(this.region);
        this.initMultipartUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.initMultipartUploadRequest.setSign(this.onSignatureListener.onGetSign(this.initMultipartUploadRequest));
        } else {
            this.initMultipartUploadRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
        }
        this.initMultipartUploadRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (state == 2) {
                    COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS);
                }
            }
        });
        cosXmlService.initMultipartUploadAsync(this.initMultipartUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.uploadId = ((InitMultipartUploadResult)result).initMultipartUpload.uploadId;
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onInit();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void listMultiUpload(CosXmlSimpleService cosXmlService) {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        this.listPartsRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.listPartsRequest.setSign(this.onSignatureListener.onGetSign(this.listPartsRequest));
        } else {
            this.listPartsRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
        }
        this.listPartsRequest.setTaskStateListener(new QCloudTaskStateListener(){

            public void onStateChanged(String taskId, int state) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                if (state == 2) {
                    COSXMLUploadTask.this.updateState(TransferState.IN_PROGRESS);
                }
            }
        });
        cosXmlService.listPartsAsync(this.listPartsRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.updateSlicePart((ListPartsResult)result);
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onListParts();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void multiUploadPart(CosXmlSimpleService cosXmlService) {
        boolean isUploadFinished = true;
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = entry.getValue();
            if (slicePartStruct.isAlreadyUpload || this.IS_EXIT.get()) continue;
            isUploadFinished = false;
            final UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, slicePartStruct.partNumber, this.srcPath, slicePartStruct.offset, slicePartStruct.sliceSize, this.uploadId);
            uploadPartRequest.setNeedMD5(this.isNeedMd5);
            uploadPartRequest.setRequestHeaders(this.headers);
            if (this.onSignatureListener != null) {
                uploadPartRequest.setSign(this.onSignatureListener.onGetSign(uploadPartRequest));
            } else {
                uploadPartRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
            }
            this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
            uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    try {
                        long dataLen = COSXMLUploadTask.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)COSXMLUploadTask.this.uploadPartRequestLongMap.get(uploadPartRequest));
                        COSXMLUploadTask.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                        if (COSXMLUploadTask.this.cosXmlProgressListener != null) {
                            COSXMLUploadTask.this.cosXmlProgressListener.onProgress(dataLen, COSXMLUploadTask.this.fileLength);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            cosXmlService.uploadPartAsync(uploadPartRequest, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                    slicePartStruct.isAlreadyUpload = true;
                    Object object = COSXMLUploadTask.this.SYNC_UPLOAD_PART;
                    synchronized (object) {
                        COSXMLUploadTask.this.UPLOAD_PART_COUNT.decrementAndGet();
                        if (COSXMLUploadTask.this.UPLOAD_PART_COUNT.get() == 0) {
                            if (COSXMLUploadTask.this.IS_EXIT.get()) {
                                return;
                            }
                            COSXMLUploadTask.this.multiUploadsStateListenerHandler.onUploadParts();
                        }
                    }
                }

                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    if (COSXMLUploadTask.this.IS_EXIT.get()) {
                        return;
                    }
                    COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
                }
            });
        }
        if (isUploadFinished && !this.IS_EXIT.get()) {
            if (this.cosXmlProgressListener != null) {
                this.cosXmlProgressListener.onProgress(this.fileLength, this.fileLength);
            }
            this.multiUploadsStateListenerHandler.onUploadParts();
        }
    }

    private void completeMultiUpload(CosXmlSimpleService cosXmlService) {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        this.completeMultiUploadRequest.setNeedMD5(this.isNeedMd5);
        this.completeMultiUploadRequest.setRequestHeaders(this.headers);
        if (this.onSignatureListener != null) {
            this.completeMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(this.completeMultiUploadRequest));
        } else {
            this.completeMultiUploadRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
        }
        cosXmlService.completeMultiUploadAsync(this.completeMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onCompleted(request, result);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                if (COSXMLUploadTask.this.IS_EXIT.get()) {
                    return;
                }
                COSXMLUploadTask.this.multiUploadsStateListenerHandler.onFailed(request, exception, serviceException);
            }
        });
    }

    private void cancelAllRequest(CosXmlSimpleService cosXmlService) {
        if (this.putObjectRequest != null) {
            cosXmlService.cancel(this.putObjectRequest);
            this.putObjectRequest = null;
        }
        if (this.initMultipartUploadRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.initMultipartUploadRequest = null;
        }
        if (this.listPartsRequest != null) {
            cosXmlService.cancel(this.initMultipartUploadRequest);
            this.listPartsRequest = null;
        }
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                cosXmlService.cancel(iterator.next());
            }
            this.uploadPartRequestLongMap.clear();
        }
        if (this.completeMultiUploadRequest != null) {
            cosXmlService.cancel(this.completeMultiUploadRequest);
            this.completeMultiUploadRequest = null;
        }
    }

    private void abortMultiUpload(CosXmlSimpleService cosXmlService) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        if (this.onSignatureListener != null) {
            abortMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(abortMultiUploadRequest));
        } else {
            abortMultiUploadRequest.setSignSourceProvider(this.cosXmlSignSourceProvider);
        }
        cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
            }
        });
    }

    @Override
    public void pause() {
        if (this.updateState(TransferState.PAUSED)) {
            if (this.isSliceUpload) {
                this.IS_EXIT.set(true);
                this.cancelAllRequest(this.cosXmlService);
            } else {
                this.cosXmlService.cancel(this.putObjectRequest);
                this.putObjectRequest = null;
            }
        }
    }

    @Override
    public void cancel() {
        if (this.updateState(TransferState.CANCELED)) {
            CosXmlClientException cosXmlClientException = new CosXmlClientException(ClientErrorCode.USER_CANCELLED.getCode(), "cancelled by user");
            this.mException = cosXmlClientException;
            if (this.cosXmlResultListener != null) {
                this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(null), cosXmlClientException, null);
            }
            if (this.isSliceUpload) {
                this.IS_EXIT.set(true);
                this.cancelAllRequest(this.cosXmlService);
                this.abortMultiUpload(this.cosXmlService);
            } else {
                this.cosXmlService.cancel(this.putObjectRequest);
                this.putObjectRequest = null;
            }
        }
    }

    @Override
    public void resume() {
        if (this.updateState(TransferState.RESUMED_WAITING)) {
            this.upload();
        }
    }

    @Override
    protected CosXmlRequest buildCOSXMLTaskRequest(CosXmlRequest sourceRequest) {
        COSXMLUploadTaskRequest cosxmlUploadTaskRequest = new COSXMLUploadTaskRequest(this.region, this.bucket, this.cosPath, this.srcPath, this.headers, this.queries);
        return cosxmlUploadTaskRequest;
    }

    @Override
    protected CosXmlResult buildCOSXMLTaskResult(CosXmlResult sourceResult) {
        COSXMLUploadTaskResult cosxmlUploadTaskResult = new COSXMLUploadTaskResult();
        if (sourceResult != null && sourceResult instanceof PutObjectResult) {
            PutObjectResult putObjectResult = (PutObjectResult)sourceResult;
            cosxmlUploadTaskResult.httpCode = putObjectResult.httpCode;
            cosxmlUploadTaskResult.httpMessage = putObjectResult.httpMessage;
            cosxmlUploadTaskResult.headers = putObjectResult.headers;
            cosxmlUploadTaskResult.eTag = putObjectResult.eTag;
            cosxmlUploadTaskResult.accessUrl = putObjectResult.accessUrl;
        } else if (sourceResult != null && sourceResult instanceof CompleteMultiUploadResult) {
            CompleteMultiUploadResult completeMultiUploadResult = (CompleteMultiUploadResult)sourceResult;
            cosxmlUploadTaskResult.httpCode = completeMultiUploadResult.httpCode;
            cosxmlUploadTaskResult.httpMessage = completeMultiUploadResult.httpMessage;
            cosxmlUploadTaskResult.headers = completeMultiUploadResult.headers;
            cosxmlUploadTaskResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
            cosxmlUploadTaskResult.accessUrl = completeMultiUploadResult.accessUrl;
        }
        return cosxmlUploadTaskResult;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    private void initSlicePart() {
        SlicePartStruct slicePartStruct;
        int i;
        int count = (int)(this.fileLength / this.sliceSize);
        for (i = 1; i < count; ++i) {
            slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
            slicePartStruct.sliceSize = this.sliceSize;
            this.partStructMap.put(i, slicePartStruct);
        }
        slicePartStruct = new SlicePartStruct();
        slicePartStruct.isAlreadyUpload = false;
        slicePartStruct.partNumber = i;
        slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
        slicePartStruct.sliceSize = this.fileLength - slicePartStruct.offset;
        this.partStructMap.put(i, slicePartStruct);
        this.UPLOAD_PART_COUNT.set(i);
        if (this.IS_EXIT.get()) {
            return;
        }
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
                this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
            }
        }
    }

    @Override
    public void run() {
        this.updateState(TransferState.WAITING);
        File file = new File(this.srcPath);
        if (!file.exists() || file.isDirectory() || !file.canRead()) {
            if (this.updateState(TransferState.FAILED)) {
                this.mException = new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), this.srcPath + " is invalid");
                if (this.cosXmlResultListener != null) {
                    this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(this.putObjectRequest), (CosXmlClientException)((Object)this.mException), null);
                }
            }
            return;
        }
        this.fileLength = file.length();
        if (this.fileLength < this.multiUploadSizeDivision) {
            this.simpleUpload(this.cosXmlService);
        } else {
            this.isSliceUpload = true;
            this.IS_EXIT = new AtomicBoolean(false);
            this.UPLOAD_PART_COUNT = new AtomicInteger(0);
            this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
            this.partStructMap = new LinkedHashMap<Integer, SlicePartStruct>();
            this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
            this.multiUpload(this.cosXmlService);
        }
    }

    public static class COSXMLUploadTaskResult
    extends CosXmlResult {
        public String eTag;

        protected COSXMLUploadTaskResult() {
        }
    }

    public static class COSXMLUploadTaskRequest
    extends PutObjectRequest {
        protected COSXMLUploadTaskRequest(String region, String bucket, String cosPath, String srcPath, Map<String, List<String>> headers, Map<String, String> queryStr) {
            super(bucket, cosPath, srcPath);
            this.setRegion(region);
            this.setRequestHeaders(headers);
            this.setQueryParameters(queryStr);
        }
    }

    private static interface MultiUploadsStateListener {
        public void onInit();

        public void onListParts();

        public void onUploadParts();

        public void onCompleted(CosXmlRequest var1, CosXmlResult var2);

        public void onFailed(CosXmlRequest var1, CosXmlClientException var2, CosXmlServiceException var3);
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }
}

