/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class PutObjectRequest
extends ObjectRequest {
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private String strData;
    private URL url;
    private long fileLength;
    private CosXmlProgressListener progressListener;

    private PutObjectRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
        this.setNeedMD5(true);
    }

    public PutObjectRequest(String bucket, String cosPath, String srcPath) {
        this(bucket, cosPath);
        this.srcPath = srcPath;
    }

    public PutObjectRequest(String bucket, String cosPath, byte[] data) {
        this(bucket, cosPath);
        this.data = data;
    }

    public PutObjectRequest(String bucket, String cosPath, StringBuilder stringBuilder) {
        this(bucket, cosPath);
        this.strData = stringBuilder.toString();
    }

    public PutObjectRequest(String bucket, String cosPath, InputStream inputStream) throws CosXmlClientException {
        this(bucket, cosPath);
        this.inputStream = inputStream;
    }

    public PutObjectRequest(String bucket, String cosPath, URL url) {
        this(bucket, cosPath);
        this.url = url;
    }

    public PutObjectRequest() {
        super(null, null);
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        if (this.srcPath != null) {
            return RequestBodySerializer.file(null, (File)new File(this.srcPath));
        }
        if (this.data != null) {
            return RequestBodySerializer.bytes(null, (byte[])this.data);
        }
        if (this.inputStream != null) {
            return RequestBodySerializer.stream(null, (File)new File(CosXmlSimpleService.appCachePath, String.valueOf(System.currentTimeMillis())), (InputStream)this.inputStream);
        }
        if (this.strData != null) {
            return RequestBodySerializer.bytes(null, (byte[])this.strData.getBytes());
        }
        if (this.url != null) {
            return RequestBodySerializer.url(null, (URL)this.url);
        }
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        File file;
        super.checkParameters();
        if (this.srcPath == null && this.data == null && this.inputStream == null && this.strData == null && this.url == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "upload file does not exist");
        }
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setStrData(String strData) {
        this.strData = strData;
    }

    public String getStrData() {
        return this.strData;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFileLength() {
        if (this.srcPath != null) {
            this.fileLength = new File(this.srcPath).length();
        } else if (this.data != null) {
            this.fileLength = this.data.length;
        } else if (this.strData != null) {
            this.fileLength = this.strData.getBytes().length;
        }
        return this.fileLength;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.addHeader("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.addHeader("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncoding) {
        if (contentEncoding == null) {
            return;
        }
        this.addHeader("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.addHeader("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }
}

