/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import android.util.Log;
import com.tencent.cos.xml.CosXml;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.MetaDataDirective;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlBooleanListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketCORSResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketReplicationRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketReplicationResult;
import com.tencent.cos.xml.model.bucket.DeleteBucketRequest;
import com.tencent.cos.xml.model.bucket.DeleteBucketResult;
import com.tencent.cos.xml.model.bucket.GetBucketACLRequest;
import com.tencent.cos.xml.model.bucket.GetBucketACLResult;
import com.tencent.cos.xml.model.bucket.GetBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.GetBucketCORSResult;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.GetBucketLocationRequest;
import com.tencent.cos.xml.model.bucket.GetBucketLocationResult;
import com.tencent.cos.xml.model.bucket.GetBucketReplicationRequest;
import com.tencent.cos.xml.model.bucket.GetBucketReplicationResult;
import com.tencent.cos.xml.model.bucket.GetBucketRequest;
import com.tencent.cos.xml.model.bucket.GetBucketResult;
import com.tencent.cos.xml.model.bucket.GetBucketVersioningRequest;
import com.tencent.cos.xml.model.bucket.GetBucketVersioningResult;
import com.tencent.cos.xml.model.bucket.HeadBucketRequest;
import com.tencent.cos.xml.model.bucket.HeadBucketResult;
import com.tencent.cos.xml.model.bucket.ListBucketVersionsRequest;
import com.tencent.cos.xml.model.bucket.ListBucketVersionsResult;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.cos.xml.model.bucket.PutBucketACLRequest;
import com.tencent.cos.xml.model.bucket.PutBucketACLResult;
import com.tencent.cos.xml.model.bucket.PutBucketCORSRequest;
import com.tencent.cos.xml.model.bucket.PutBucketCORSResult;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleRequest;
import com.tencent.cos.xml.model.bucket.PutBucketLifecycleResult;
import com.tencent.cos.xml.model.bucket.PutBucketReplicationRequest;
import com.tencent.cos.xml.model.bucket.PutBucketReplicationResult;
import com.tencent.cos.xml.model.bucket.PutBucketRequest;
import com.tencent.cos.xml.model.bucket.PutBucketResult;
import com.tencent.cos.xml.model.bucket.PutBucketVersioningRequest;
import com.tencent.cos.xml.model.bucket.PutBucketVersioningResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.DeleteMultiObjectRequest;
import com.tencent.cos.xml.model.object.DeleteMultiObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectACLRequest;
import com.tencent.cos.xml.model.object.GetObjectACLResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.OptionObjectRequest;
import com.tencent.cos.xml.model.object.OptionObjectResult;
import com.tencent.cos.xml.model.object.PutObjectACLRequest;
import com.tencent.cos.xml.model.object.PutObjectACLResult;
import com.tencent.cos.xml.model.object.RestoreRequest;
import com.tencent.cos.xml.model.object.RestoreResult;
import com.tencent.cos.xml.model.service.GetServiceRequest;
import com.tencent.cos.xml.model.service.GetServiceResult;
import com.tencent.cos.xml.model.tag.COSMetaData;
import com.tencent.cos.xml.model.tag.ListAllMyBuckets;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudSigner;
import java.util.List;

public class CosXmlService
extends CosXmlSimpleService
implements CosXml {
    public CosXmlService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        super(context, configuration, qCloudCredentialProvider);
    }

    public CosXmlService(Context context, CosXmlServiceConfig configuration, QCloudSigner qCloudSigner) {
        super(context, configuration, qCloudSigner);
    }

    public CosXmlService(Context context, CosXmlServiceConfig configuration) {
        super(context, configuration);
    }

    @Override
    public GetServiceResult getService(GetServiceRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetServiceResult());
    }

    @Override
    public void getServiceAsync(GetServiceRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetServiceResult(), cosXmlResultListener);
    }

    @Override
    public DeleteMultiObjectResult deleteMultiObject(DeleteMultiObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteMultiObjectResult());
    }

    @Override
    public void deleteMultiObjectAsync(DeleteMultiObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteMultiObjectResult(), cosXmlResultListener);
    }

    @Override
    public GetObjectACLResult getObjectACL(GetObjectACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetObjectACLResult());
    }

    @Override
    public void getObjectACLAsync(GetObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetObjectACLResult(), cosXmlResultListener);
    }

    @Override
    public OptionObjectResult optionObject(OptionObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new OptionObjectResult());
    }

    @Override
    public void optionObjectAsync(OptionObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new OptionObjectResult(), cosXmlResultListener);
    }

    @Override
    public PutObjectACLResult putObjectACL(PutObjectACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutObjectACLResult());
    }

    @Override
    public void putObjectACLAsync(PutObjectACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutObjectACLResult(), cosXmlResultListener);
    }

    @Override
    public RestoreResult restoreObject(RestoreRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new RestoreResult());
    }

    @Override
    public void restoreObjectAsync(RestoreRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new RestoreResult(), cosXmlResultListener);
    }

    @Override
    public DeleteBucketCORSResult deleteBucketCORS(DeleteBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteBucketCORSResult());
    }

    @Override
    public void deleteBucketCORSAsync(DeleteBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteBucketCORSResult(), cosXmlResultListener);
    }

    @Override
    public DeleteBucketLifecycleResult deleteBucketLifecycle(DeleteBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteBucketLifecycleResult());
    }

    @Override
    public void deleteBucketLifecycleAsync(DeleteBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteBucketLifecycleResult(), cosXmlResultListener);
    }

    @Override
    public DeleteBucketResult deleteBucket(DeleteBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteBucketResult());
    }

    @Override
    public void deleteBucketAsync(DeleteBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteBucketResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketACLResult getBucketACL(GetBucketACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketACLResult());
    }

    @Override
    public void getBucketACLAsync(GetBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketACLResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketCORSResult getBucketCORS(GetBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketCORSResult());
    }

    @Override
    public void getBucketCORSAsync(GetBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketCORSResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketLifecycleResult getBucketLifecycle(GetBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketLifecycleResult());
    }

    @Override
    public void getBucketLifecycleAsync(GetBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketLifecycleResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketLocationResult getBucketLocation(GetBucketLocationRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketLocationResult());
    }

    @Override
    public void getBucketLocationAsync(GetBucketLocationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketLocationResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketResult getBucket(GetBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketResult());
    }

    @Override
    public void getBucketAsync(GetBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketResult(), cosXmlResultListener);
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new HeadBucketResult());
    }

    @Override
    public void headBucketAsync(HeadBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new HeadBucketResult(), cosXmlResultListener);
    }

    @Override
    public ListMultiUploadsResult listMultiUploads(ListMultiUploadsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new ListMultiUploadsResult());
    }

    @Override
    public void listMultiUploadsAsync(ListMultiUploadsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListMultiUploadsResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketACLResult putBucketACL(PutBucketACLRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketACLResult());
    }

    @Override
    public void putBucketACLAsync(PutBucketACLRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketACLResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketCORSResult putBucketCORS(PutBucketCORSRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketCORSResult());
    }

    @Override
    public void putBucketCORSAsync(PutBucketCORSRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketCORSResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketLifecycleResult putBucketLifecycle(PutBucketLifecycleRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketLifecycleResult());
    }

    @Override
    public void putBucketLifecycleAsync(PutBucketLifecycleRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketLifecycleResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketResult putBucket(PutBucketRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketResult());
    }

    @Override
    public void putBucketAsync(PutBucketRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketVersioningResult getBucketVersioning(GetBucketVersioningRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketVersioningResult());
    }

    @Override
    public void getBucketVersioningAsync(GetBucketVersioningRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketVersioningResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketVersioningResult putBucketVersioning(PutBucketVersioningRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketVersioningResult());
    }

    @Override
    public void putBucketVersionAsync(PutBucketVersioningRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketVersioningResult(), cosXmlResultListener);
    }

    @Override
    public GetBucketReplicationResult getBucketReplication(GetBucketReplicationRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new GetBucketReplicationResult());
    }

    @Override
    public void getBucketReplicationAsync(GetBucketReplicationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new GetBucketReplicationResult(), cosXmlResultListener);
    }

    @Override
    public PutBucketReplicationResult putBucketReplication(PutBucketReplicationRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new PutBucketReplicationResult());
    }

    @Override
    public void putBucketReplicationAsync(PutBucketReplicationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new PutBucketReplicationResult(), cosXmlResultListener);
    }

    @Override
    public DeleteBucketReplicationResult deleteBucketReplication(DeleteBucketReplicationRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new DeleteBucketReplicationResult());
    }

    @Override
    public void deleteBucketReplicationAsync(DeleteBucketReplicationRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new DeleteBucketReplicationResult(), cosXmlResultListener);
    }

    @Override
    public ListBucketVersionsResult listBucketVersions(ListBucketVersionsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return this.execute(request, new ListBucketVersionsResult());
    }

    @Override
    public void listBucketVersionsAsync(ListBucketVersionsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListBucketVersionsResult(), cosXmlResultListener);
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws CosXmlClientException, CosXmlServiceException {
        GetBucketACLRequest getBucketACLRequest = new GetBucketACLRequest(bucketName);
        try {
            this.getBucketACL(getBucketACLRequest);
            return true;
        }
        catch (CosXmlServiceException serviceException) {
            if (serviceException.getStatusCode() == 301 || "AccessDenied".equals(serviceException.getErrorCode())) {
                return true;
            }
            if (serviceException.getStatusCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @Override
    public void doesBucketExistAsync(String bucketName, final CosXmlBooleanListener booleanListener) {
        GetBucketACLRequest getBucketACLRequest = new GetBucketACLRequest(bucketName);
        this.getBucketACLAsync(getBucketACLRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                booleanListener.onSuccess(true);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (clientException == null && serviceException != null) {
                    if (serviceException.getStatusCode() == 301 || "AccessDenied".equals(serviceException.getErrorCode())) {
                        booleanListener.onSuccess(true);
                    }
                    if (serviceException.getStatusCode() == 404) {
                        booleanListener.onSuccess(false);
                    }
                }
                booleanListener.onFail(clientException, serviceException);
            }
        });
    }

    @Deprecated
    private boolean doesBucketExistByGetService(GetServiceResult getServiceResult, String bucketName) {
        if (getServiceResult == null || getServiceResult.listAllMyBuckets == null) {
            return false;
        }
        ListAllMyBuckets listAllMyBuckets = getServiceResult.listAllMyBuckets;
        List<ListAllMyBuckets.Bucket> buckets = listAllMyBuckets.buckets;
        Log.d((String)"tag", (String)("buckets number is " + buckets.size()));
        if (buckets == null) {
            return false;
        }
        for (ListAllMyBuckets.Bucket bucket : buckets) {
            Log.d((String)"tag", (String)("bucket name is " + bucket.name));
            if (!bucket.name.equals(bucketName + "-" + this.appid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        HeadObjectRequest headObjectRequest = new HeadObjectRequest(bucketName, objectName);
        try {
            this.headObject(headObjectRequest);
        }
        catch (CosXmlServiceException serviceException) {
            if (serviceException.getStatusCode() == 404) {
                return false;
            }
            throw serviceException;
        }
        return true;
    }

    @Override
    public void doesObjectExistAsync(String bucketName, String objectName, final CosXmlBooleanListener booleanListener) {
        HeadObjectRequest headObjectRequest = new HeadObjectRequest(bucketName, objectName);
        this.headObjectAsync(headObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                booleanListener.onSuccess(true);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (serviceException != null && serviceException.getStatusCode() == 404) {
                    booleanListener.onSuccess(false);
                } else {
                    booleanListener.onFail(clientException, serviceException);
                }
            }
        });
    }

    @Override
    public boolean deleteObject(String bucketName, String objectName) throws CosXmlClientException, CosXmlServiceException {
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, objectName);
        this.deleteObject(deleteObjectRequest);
        return true;
    }

    @Override
    public void deleteObjectAsync(String bucketName, String objectName, final CosXmlBooleanListener booleanListener) {
        DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, objectName);
        this.deleteObjectAsync(deleteObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                booleanListener.onSuccess(true);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                booleanListener.onFail(exception, serviceException);
            }
        });
    }

    @Override
    public boolean updateObjectMeta(String bucketName, String objectName, COSMetaData metaData) throws CosXmlClientException, CosXmlServiceException {
        CopyObjectRequest.CopySourceStruct copySourceStruct = new CopyObjectRequest.CopySourceStruct(this.appid, bucketName, this.region, objectName);
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(bucketName, objectName, copySourceStruct);
        copyObjectRequest.setCopyMetaDataDirective(MetaDataDirective.REPLACED);
        for (String key : metaData.keySet()) {
            copyObjectRequest.setXCOSMeta(key, metaData.get(key));
        }
        this.copyObject(copyObjectRequest);
        return true;
    }

    @Override
    public void updateObjectMetaAsync(String bucketName, String objectName, COSMetaData metaData, final CosXmlBooleanListener booleanListener) {
        CopyObjectRequest.CopySourceStruct copySourceStruct = new CopyObjectRequest.CopySourceStruct(this.appid, bucketName, this.region, objectName);
        CopyObjectRequest copyObjectRequest = null;
        copyObjectRequest = new CopyObjectRequest(bucketName, objectName, copySourceStruct);
        copyObjectRequest.setCopyMetaDataDirective(MetaDataDirective.REPLACED);
        for (String key : metaData.keySet()) {
            copyObjectRequest.setXCOSMeta(key, metaData.get(key));
        }
        this.copyObjectAsync(copyObjectRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                booleanListener.onSuccess(true);
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                booleanListener.onFail(exception, serviceException);
            }
        });
    }
}

