/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mmkv;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.Nullable;
import com.tencent.mmkv.MMKVContentProvider;
import com.tencent.mmkv.ParcelableMMKV;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MMKV
implements SharedPreferences,
SharedPreferences.Editor {
    public static final int SINGLE_PROCESS_MODE = 1;
    public static final int MULTI_PROCESS_MODE = 2;
    private static final int ASHMEM_MODE = 4;
    private long nativeHandle;

    public static String initialize(Context context) {
        String rootDir = context.getFilesDir().getAbsolutePath() + "/mmkv";
        MMKV.initialize(rootDir);
        return rootDir;
    }

    public static native void onExit();

    public static MMKV mmkvWithID(String mmapID) {
        long handle = MMKV.getMMKVWithID(mmapID, 1, null);
        return new MMKV(handle);
    }

    public static MMKV mmkvWithID(String mmapID, int mode) {
        long handle = MMKV.getMMKVWithID(mmapID, mode, null);
        return new MMKV(handle);
    }

    public static MMKV mmkvWithID(String mmapID, int mode, String cryptKey) {
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey);
        return new MMKV(handle);
    }

    @Nullable
    public static MMKV mmkvWithAshmemID(Context context, String mmapID, int size, int mode, String cryptKey) {
        String processName = MMKVContentProvider.getProcessNameByPID(context, Process.myPid());
        if (processName == null || processName.length() == 0) {
            System.out.println("process name detect fail, try again later");
            return null;
        }
        if (processName.contains(":")) {
            ContentResolver resolver;
            Bundle result;
            Uri uri = MMKVContentProvider.contentUri(context);
            if (uri == null) {
                System.out.println("MMKVContentProvider has invalid authority");
                return null;
            }
            System.out.println("getting parcelable mmkv in process, Uri = " + uri);
            Bundle extras = new Bundle();
            extras.putInt("KEY_SIZE", size);
            extras.putInt("KEY_MODE", mode);
            if (cryptKey != null) {
                extras.putString("KEY_CRYPT", cryptKey);
            }
            if ((result = (resolver = context.getContentResolver()).call(uri, "mmkvFromAshmemID", mmapID, extras)) != null) {
                result.setClassLoader(ParcelableMMKV.class.getClassLoader());
                ParcelableMMKV parcelableMMKV = (ParcelableMMKV)result.getParcelable("KEY");
                if (parcelableMMKV != null) {
                    MMKV mmkv = parcelableMMKV.toMMKV();
                    if (mmkv != null) {
                        System.out.println(mmkv.mmapID() + " fd = " + mmkv.ashmemFD() + ", meta fd = " + mmkv.ashmemMetaFD());
                    }
                    return mmkv;
                }
            }
        } else {
            System.out.println("getting mmkv in main process");
            long handle = MMKV.getMMKVWithIDAndSize(mmapID, size, mode |= 4, cryptKey);
            return new MMKV(handle);
        }
        return null;
    }

    public static MMKV defaultMMKV() {
        long handle = MMKV.getDefaultMMKV(1, null);
        return new MMKV(handle);
    }

    public static MMKV defaultMMKV(int mode, String cryptKey) {
        long handle = MMKV.getDefaultMMKV(mode, cryptKey);
        return new MMKV(handle);
    }

    public native String cryptKey();

    public native boolean reKey(String var1);

    public native void checkReSetCryptKey(String var1);

    public static native int pageSize();

    public native String mmapID();

    public native void lock();

    public native void unlock();

    public native boolean tryLock();

    public boolean encode(String key, boolean value) {
        return this.encodeBool(this.nativeHandle, key, value);
    }

    public boolean decodeBool(String key) {
        return this.decodeBool(this.nativeHandle, key, false);
    }

    public boolean decodeBool(String key, boolean defaultValue) {
        return this.decodeBool(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, int value) {
        return this.encodeInt(this.nativeHandle, key, value);
    }

    public int decodeInt(String key) {
        return this.decodeInt(this.nativeHandle, key, 0);
    }

    public int decodeInt(String key, int defaultValue) {
        return this.decodeInt(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, long value) {
        return this.encodeLong(this.nativeHandle, key, value);
    }

    public long decodeLong(String key) {
        return this.decodeLong(this.nativeHandle, key, 0L);
    }

    public long decodeLong(String key, long defaultValue) {
        return this.decodeLong(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, float value) {
        return this.encodeFloat(this.nativeHandle, key, value);
    }

    public float decodeFloat(String key) {
        return this.decodeFloat(this.nativeHandle, key, 0.0f);
    }

    public float decodeFloat(String key, float defaultValue) {
        return this.decodeFloat(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, double value) {
        return this.encodeDouble(this.nativeHandle, key, value);
    }

    public double decodeDouble(String key) {
        return this.decodeDouble(this.nativeHandle, key, 0.0);
    }

    public double decodeDouble(String key, double defaultValue) {
        return this.decodeDouble(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, String value) {
        return this.encodeString(this.nativeHandle, key, value);
    }

    public String decodeString(String key) {
        return this.decodeString(this.nativeHandle, key, null);
    }

    public String decodeString(String key, String defaultValue) {
        return this.decodeString(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, Set<String> value) {
        return this.encodeSet(this.nativeHandle, key, value.toArray(new String[value.size()]));
    }

    public Set<String> decodeStringSet(String key) {
        return this.decodeStringSet(key, null);
    }

    public Set<String> decodeStringSet(String key, Set<String> defaultValue) {
        String[] result = this.decodeStringSet(this.nativeHandle, key);
        if (result == null) {
            return defaultValue;
        }
        return new HashSet<String>(Arrays.asList(result));
    }

    public boolean encode(String key, byte[] value) {
        return this.encodeBytes(this.nativeHandle, key, value);
    }

    public byte[] decodeBytes(String key) {
        return this.decodeBytes(this.nativeHandle, key);
    }

    public boolean containsKey(String key) {
        return this.containsKey(this.nativeHandle, key);
    }

    public native String[] allKeys();

    public long count() {
        return this.count(this.nativeHandle);
    }

    public long totalSize() {
        return this.totalSize(this.nativeHandle);
    }

    public void removeValueForKey(String key) {
        this.removeValueForKey(this.nativeHandle, key);
    }

    public native void removeValuesForKeys(String[] var1);

    public native void clearAll();

    public native void clearMemoryCache();

    public native void sync();

    public static native boolean isFileValid(String var0);

    public int importFromSharedPreferences(SharedPreferences preferences) {
        Map kvs = preferences.getAll();
        if (kvs == null || kvs.size() <= 0) {
            return 0;
        }
        for (Map.Entry entry : kvs.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Boolean) {
                this.encodeBool(this.nativeHandle, key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                this.encodeInt(this.nativeHandle, key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.encodeLong(this.nativeHandle, key, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                this.encodeFloat(this.nativeHandle, key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.encodeDouble(this.nativeHandle, key, (Double)value);
                continue;
            }
            if (value instanceof String) {
                this.encodeString(this.nativeHandle, key, (String)value);
                continue;
            }
            if (value instanceof Set) {
                this.encode(key, (Set)value);
                continue;
            }
            System.out.println("unknown type: " + value.getClass());
        }
        return kvs.size();
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException("use allKeys() instead, getAll() not implement because type-erasure inside mmkv");
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.decodeString(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putString(String key, @Nullable String value) {
        this.encodeString(this.nativeHandle, key, value);
        return this;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return this.decodeStringSet(key, defValues);
    }

    public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
        this.encode(key, values);
        return this;
    }

    public int getInt(String key, int defValue) {
        return this.decodeInt(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putInt(String key, int value) {
        this.encodeInt(this.nativeHandle, key, value);
        return this;
    }

    public long getLong(String key, long defValue) {
        return this.decodeLong(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putLong(String key, long value) {
        this.encodeLong(this.nativeHandle, key, value);
        return this;
    }

    public float getFloat(String key, float defValue) {
        return this.decodeFloat(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putFloat(String key, float value) {
        this.encodeFloat(this.nativeHandle, key, value);
        return this;
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.decodeBool(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putBoolean(String key, boolean value) {
        this.encodeBool(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor remove(String key) {
        this.removeValueForKey(key);
        return this;
    }

    public SharedPreferences.Editor clear() {
        this.clearAll();
        return this;
    }

    public boolean commit() {
        this.sync();
        return true;
    }

    public void apply() {
    }

    public boolean contains(String key) {
        return this.containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return this;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implement in MMKV");
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Not implement in MMKV");
    }

    public static MMKV mmkvWithAshmemFD(String mmapID, int fd, int metaFD, String cryptKey) {
        long handle = MMKV.getMMKVWithAshmemFD(mmapID, fd, metaFD, cryptKey);
        return new MMKV(handle);
    }

    public native int ashmemFD();

    public native int ashmemMetaFD();

    private MMKV(long handle) {
        this.nativeHandle = handle;
    }

    private static native void initialize(String var0);

    private static native long getMMKVWithID(String var0, int var1, String var2);

    private static native long getMMKVWithIDAndSize(String var0, int var1, int var2, String var3);

    private static native long getDefaultMMKV(int var0, String var1);

    private static native long getMMKVWithAshmemFD(String var0, int var1, int var2, String var3);

    private native boolean encodeBool(long var1, String var3, boolean var4);

    private native boolean decodeBool(long var1, String var3, boolean var4);

    private native boolean encodeInt(long var1, String var3, int var4);

    private native int decodeInt(long var1, String var3, int var4);

    private native boolean encodeLong(long var1, String var3, long var4);

    private native long decodeLong(long var1, String var3, long var4);

    private native boolean encodeFloat(long var1, String var3, float var4);

    private native float decodeFloat(long var1, String var3, float var4);

    private native boolean encodeDouble(long var1, String var3, double var4);

    private native double decodeDouble(long var1, String var3, double var4);

    private native boolean encodeString(long var1, String var3, String var4);

    private native String decodeString(long var1, String var3, String var4);

    private native boolean encodeSet(long var1, String var3, String[] var4);

    private native String[] decodeStringSet(long var1, String var3);

    private native boolean encodeBytes(long var1, String var3, byte[] var4);

    private native byte[] decodeBytes(long var1, String var3);

    private native boolean containsKey(long var1, String var3);

    private native long count(long var1);

    private native long totalSize(long var1);

    private native void removeValueForKey(long var1, String var3);

    static {
        System.loadLibrary("c++_shared");
        System.loadLibrary("mmkv");
    }
}

