/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mmkv;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.mmkv.MMKVContentChangeNotification;
import com.tencent.mmkv.MMKVContentProvider;
import com.tencent.mmkv.MMKVHandler;
import com.tencent.mmkv.MMKVLogLevel;
import com.tencent.mmkv.MMKVRecoverStrategic;
import com.tencent.mmkv.NameSpace;
import com.tencent.mmkv.NativeBuffer;
import com.tencent.mmkv.ParcelableMMKV;
import com.tencent.mmkv.UnsupportedArchitectureException;
import dalvik.annotation.optimization.FastNative;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;

public class MMKV
implements SharedPreferences,
SharedPreferences.Editor {
    private static final EnumMap<MMKVRecoverStrategic, Integer> recoverIndex = new EnumMap(MMKVRecoverStrategic.class);
    private static final EnumMap<MMKVLogLevel, Integer> logLevel2Index;
    private static final MMKVLogLevel[] index2LogLevel;
    private static final Set<Long> checkedHandleSet;
    private static boolean isNativeLibLoaded;
    private static String rootDir;
    public static final int SINGLE_PROCESS_MODE = 1;
    public static final int MULTI_PROCESS_MODE = 2;
    private static final int CONTEXT_MODE_MULTI_PROCESS = 4;
    private static final int ASHMEM_MODE = 8;
    private static final int BACKUP_MODE = 16;
    public static final int READ_ONLY_MODE = 32;
    private static boolean isProcessModeCheckerEnabled;
    private static final HashMap<String, Parcelable.Creator<?>> mCreators;
    public static final int ExpireNever = 0;
    public static final int ExpireInMinute = 60;
    public static final int ExpireInHour = 3600;
    public static final int ExpireInDay = 86400;
    public static final int ExpireInMonth = 2592000;
    public static final int ExpireInYear = 946080000;
    private static MMKVHandler gCallbackHandler;
    private static boolean gWantLogReDirecting;
    private static MMKVContentChangeNotification gContentChangeNotify;
    private final long nativeHandle;

    public static String initialize(@NonNull Context context) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(context, root, null, logLevel, null);
    }

    public static String initialize(@NonNull Context context, MMKVLogLevel logLevel) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        return MMKV.initialize(context, root, null, logLevel, null);
    }

    public static String initialize(@NonNull Context context, LibLoader loader) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(context, root, loader, logLevel, null);
    }

    public static String initialize(@NonNull Context context, LibLoader loader, MMKVLogLevel logLevel) {
        String root = context.getFilesDir().getAbsolutePath() + "/mmkv";
        return MMKV.initialize(context, root, loader, logLevel, null);
    }

    public static String initialize(Context context, String rootDir) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(context, rootDir, null, logLevel, null);
    }

    public static String initialize(Context context, String rootDir, MMKVLogLevel logLevel) {
        return MMKV.initialize(context, rootDir, null, logLevel, null);
    }

    public static String initialize(Context context, String rootDir, LibLoader loader) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.initialize(context, rootDir, loader, logLevel, null);
    }

    public static String initialize(Context context, String rootDir, LibLoader loader, MMKVLogLevel logLevel) {
        return MMKV.initialize(context, rootDir, loader, logLevel, null);
    }

    public static String initialize(@NonNull Context context, String rootDir, LibLoader loader, MMKVLogLevel logLevel, MMKVHandler handler) {
        if (!Process.is64Bit()) {
            throw new UnsupportedArchitectureException("MMKV 2.0+ requires 64-bit App, use 1.3.x instead.");
        }
        if ((context.getApplicationInfo().flags & 2) == 0) {
            MMKV.disableProcessModeChecker();
        } else {
            MMKV.enableProcessModeChecker();
        }
        String cacheDir = context.getCacheDir().getAbsolutePath();
        gCallbackHandler = handler;
        if (gCallbackHandler != null && gCallbackHandler.wantLogRedirecting()) {
            gWantLogReDirecting = true;
        }
        String ret = MMKV.doInitialize(rootDir, cacheDir, loader, logLevel, gWantLogReDirecting);
        if (gCallbackHandler != null) {
            MMKV.setCallbackHandler(gWantLogReDirecting, true);
        }
        return ret;
    }

    private static String doInitialize(String rootDir, String cacheDir, LibLoader loader, MMKVLogLevel logLevel, boolean wantLogReDirecting) {
        MMKV.tryLoadNativeLib(loader);
        MMKV.jniInitialize(rootDir, cacheDir, MMKV.logLevel2Int(logLevel), wantLogReDirecting);
        MMKV.rootDir = rootDir;
        return MMKV.rootDir;
    }

    private static void tryLoadNativeLib(@Nullable LibLoader loader) {
        if (isNativeLibLoaded) {
            return;
        }
        if (loader != null) {
            if ("StaticCpp".equals("SharedCpp")) {
                loader.loadLibrary("c++_shared");
            }
            loader.loadLibrary("mmkv");
        } else {
            if ("StaticCpp".equals("SharedCpp")) {
                System.loadLibrary("c++_shared");
            }
            System.loadLibrary("mmkv");
        }
        isNativeLibLoaded = true;
    }

    @Deprecated
    public static String initialize(String rootDir) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.doInitialize(rootDir, rootDir + "/.tmp", null, logLevel, false);
    }

    @Deprecated
    public static String initialize(String rootDir, MMKVLogLevel logLevel) {
        return MMKV.doInitialize(rootDir, rootDir + "/.tmp", null, logLevel, false);
    }

    @Deprecated
    public static String initialize(String rootDir, LibLoader loader) {
        MMKVLogLevel logLevel = MMKVLogLevel.LevelInfo;
        return MMKV.doInitialize(rootDir, rootDir + "/.tmp", loader, logLevel, false);
    }

    @Deprecated
    public static String initialize(String rootDir, LibLoader loader, MMKVLogLevel logLevel) {
        return MMKV.doInitialize(rootDir, rootDir + "/.tmp", loader, logLevel, false);
    }

    public static NameSpace nameSpace(String dir) throws RuntimeException {
        MMKV.tryLoadNativeLib(null);
        if (MMKV.getNameSpace(dir)) {
            return new NameSpace(dir);
        }
        throw new RuntimeException("Fail to get NameSpace[" + dir + "] in JNI.");
    }

    public static NameSpace defaultNameSpace() throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        return new NameSpace(rootDir);
    }

    public static String getRootDir() {
        return rootDir;
    }

    @Contract(pure=true)
    private static int logLevel2Int(@NonNull MMKVLogLevel level) {
        int realLevel;
        switch (level) {
            case LevelDebug: {
                realLevel = 0;
                break;
            }
            case LevelWarning: {
                realLevel = 2;
                break;
            }
            case LevelError: {
                realLevel = 3;
                break;
            }
            case LevelNone: {
                realLevel = 4;
                break;
            }
            default: {
                realLevel = 1;
            }
        }
        return realLevel;
    }

    public static void setLogLevel(MMKVLogLevel level) {
        int realLevel = MMKV.logLevel2Int(level);
        MMKV.setLogLevel(realLevel);
    }

    public static native void onExit();

    @NonNull
    public static MMKV mmkvWithID(String mmapID) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, 1, null, null, 0L);
        return MMKV.checkProcessMode(handle, mmapID, 1);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, int mode) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, null, null, 0L);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, int mode, long expectedCapacity) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, null, null, expectedCapacity);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, int mode, @Nullable String cryptKey) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey, null, 0L);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, String rootPath) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, 1, null, rootPath, 0L);
        return MMKV.checkProcessMode(handle, mmapID, 1);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, String rootPath, long expectedCapacity) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, 1, null, rootPath, expectedCapacity);
        return MMKV.checkProcessMode(handle, mmapID, 1);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, int mode, @Nullable String cryptKey, String rootPath, long expectedCapacity) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey, rootPath, expectedCapacity);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV mmkvWithID(String mmapID, int mode, @Nullable String cryptKey, String rootPath) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode, cryptKey, rootPath, 0L);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV backedUpMMKVWithID(String mmapID, int mode, @Nullable String cryptKey, String rootPath) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getMMKVWithID(mmapID, mode |= 0x10, cryptKey, rootPath, 0L);
        return MMKV.checkProcessMode(handle, mmapID, mode);
    }

    @NonNull
    public static MMKV mmkvWithAshmemID(Context context, String mmapID, int size, int mode, @Nullable String cryptKey) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        String processName = MMKVContentProvider.getProcessNameByPID(context, Process.myPid());
        if (processName == null || processName.isEmpty()) {
            String message = "process name detect fail, try again later";
            MMKV.simpleLog(MMKVLogLevel.LevelError, message);
            throw new IllegalStateException(message);
        }
        if (processName.contains(":")) {
            ContentResolver resolver;
            Bundle result;
            Uri uri = MMKVContentProvider.contentUri(context);
            if (uri == null) {
                String message = "MMKVContentProvider has invalid authority";
                MMKV.simpleLog(MMKVLogLevel.LevelError, message);
                throw new IllegalStateException(message);
            }
            MMKV.simpleLog(MMKVLogLevel.LevelInfo, "getting parcelable mmkv in process, Uri = " + uri);
            Bundle extras = new Bundle();
            extras.putInt("KEY_SIZE", size);
            extras.putInt("KEY_MODE", mode);
            if (cryptKey != null) {
                extras.putString("KEY_CRYPT", cryptKey);
            }
            if ((result = (resolver = context.getContentResolver()).call(uri, "mmkvFromAshmemID", mmapID, extras)) != null) {
                MMKV mmkv;
                result.setClassLoader(ParcelableMMKV.class.getClassLoader());
                ParcelableMMKV parcelableMMKV = (ParcelableMMKV)result.getParcelable("KEY");
                if (parcelableMMKV != null && (mmkv = parcelableMMKV.toMMKV()) != null) {
                    MMKV.simpleLog(MMKVLogLevel.LevelInfo, mmkv.mmapID() + " fd = " + mmkv.ashmemFD() + ", meta fd = " + mmkv.ashmemMetaFD());
                    return mmkv;
                }
            }
        }
        MMKV.simpleLog(MMKVLogLevel.LevelInfo, "getting mmkv in main process");
        long handle = MMKV.getMMKVWithIDAndSize(mmapID, size, mode |= 8, cryptKey);
        if (handle != 0L) {
            return new MMKV(handle);
        }
        throw new IllegalStateException("Fail to create an Ashmem MMKV instance [" + mmapID + "]");
    }

    @NonNull
    public static MMKV defaultMMKV() throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getDefaultMMKV(1, null);
        return MMKV.checkProcessMode(handle, "DefaultMMKV", 1);
    }

    @NonNull
    public static MMKV defaultMMKV(int mode, @Nullable String cryptKey) throws RuntimeException {
        if (rootDir == null) {
            throw new IllegalStateException("You should Call MMKV.initialize() first.");
        }
        long handle = MMKV.getDefaultMMKV(mode, cryptKey);
        return MMKV.checkProcessMode(handle, "DefaultMMKV", mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Contract(value="_, _, _ -> new")
    static MMKV checkProcessMode(long handle, String mmapID, int mode) throws RuntimeException {
        if (handle == 0L) {
            throw new RuntimeException("Fail to create an MMKV instance [" + mmapID + "] in JNI");
        }
        if (!isProcessModeCheckerEnabled) {
            return new MMKV(handle);
        }
        Set<Long> set = checkedHandleSet;
        synchronized (set) {
            if (!checkedHandleSet.contains(handle)) {
                if (!MMKV.checkProcessMode(handle)) {
                    String message;
                    if (mode == 1) {
                        message = "Opening a multi-process MMKV instance [" + mmapID + "] with SINGLE_PROCESS_MODE!";
                    } else {
                        message = "Opening an MMKV instance [" + mmapID + "] with MULTI_PROCESS_MODE, ";
                        message = message + "while it's already been opened with SINGLE_PROCESS_MODE by someone somewhere else!";
                    }
                    throw new IllegalArgumentException(message);
                }
                checkedHandleSet.add(handle);
            }
        }
        return new MMKV(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableProcessModeChecker() {
        Set<Long> set = checkedHandleSet;
        synchronized (set) {
            isProcessModeCheckerEnabled = true;
        }
        MMKV.enableDisableProcessMode(true);
        Log.i((String)"MMKV", (String)"Enable checkProcessMode()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableProcessModeChecker() {
        Set<Long> set = checkedHandleSet;
        synchronized (set) {
            isProcessModeCheckerEnabled = false;
        }
        MMKV.enableDisableProcessMode(false);
        Log.i((String)"MMKV", (String)"Disable checkProcessMode()");
    }

    @Nullable
    public native String cryptKey();

    public native boolean reKey(@Nullable String var1);

    public native void checkReSetCryptKey(@Nullable String var1);

    public static native int pageSize();

    public static native String version();

    public native String mmapID();

    public native void lock();

    public native void unlock();

    public native boolean tryLock();

    public boolean encode(String key, boolean value) {
        return this.encodeBool(this.nativeHandle, key, value);
    }

    public boolean encode(String key, boolean value, int expireDurationInSecond) {
        return this.encodeBool_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    public boolean decodeBool(String key) {
        return this.decodeBool(this.nativeHandle, key, false);
    }

    public boolean decodeBool(String key, boolean defaultValue) {
        return this.decodeBool(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, int value) {
        return this.encodeInt(this.nativeHandle, key, value);
    }

    public boolean encode(String key, int value, int expireDurationInSecond) {
        return this.encodeInt_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    public int decodeInt(String key) {
        return this.decodeInt(this.nativeHandle, key, 0);
    }

    public int decodeInt(String key, int defaultValue) {
        return this.decodeInt(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, long value) {
        return this.encodeLong(this.nativeHandle, key, value);
    }

    public boolean encode(String key, long value, int expireDurationInSecond) {
        return this.encodeLong_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    public long decodeLong(String key) {
        return this.decodeLong(this.nativeHandle, key, 0L);
    }

    public long decodeLong(String key, long defaultValue) {
        return this.decodeLong(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, float value) {
        return this.encodeFloat(this.nativeHandle, key, value);
    }

    public boolean encode(String key, float value, int expireDurationInSecond) {
        return this.encodeFloat_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    public float decodeFloat(String key) {
        return this.decodeFloat(this.nativeHandle, key, 0.0f);
    }

    public float decodeFloat(String key, float defaultValue) {
        return this.decodeFloat(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, double value) {
        return this.encodeDouble(this.nativeHandle, key, value);
    }

    public boolean encode(String key, double value, int expireDurationInSecond) {
        return this.encodeDouble_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    public double decodeDouble(String key) {
        return this.decodeDouble(this.nativeHandle, key, 0.0);
    }

    public double decodeDouble(String key, double defaultValue) {
        return this.decodeDouble(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, @Nullable String value) {
        return this.encodeString(this.nativeHandle, key, value);
    }

    public boolean encode(String key, @Nullable String value, int expireDurationInSecond) {
        return this.encodeString_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    @Nullable
    public String decodeString(String key) {
        return this.decodeString(this.nativeHandle, key, null);
    }

    @Nullable
    public String decodeString(String key, @Nullable String defaultValue) {
        return this.decodeString(this.nativeHandle, key, defaultValue);
    }

    public boolean encode(String key, @Nullable Set<String> value) {
        return this.encodeSet(this.nativeHandle, key, value == null ? null : value.toArray(new String[0]));
    }

    public boolean encode(String key, @Nullable Set<String> value, int expireDurationInSecond) {
        return this.encodeSet_2(this.nativeHandle, key, value == null ? null : value.toArray(new String[0]), expireDurationInSecond);
    }

    @Nullable
    public Set<String> decodeStringSet(String key) {
        return this.decodeStringSet(key, null);
    }

    @Nullable
    public Set<String> decodeStringSet(String key, @Nullable Set<String> defaultValue) {
        return this.decodeStringSet(key, defaultValue, HashSet.class);
    }

    @Nullable
    public Set<String> decodeStringSet(String key, @Nullable Set<String> defaultValue, Class<? extends Set> cls) {
        Set a;
        String[] result = this.decodeStringSet(this.nativeHandle, key);
        if (result == null) {
            return defaultValue;
        }
        try {
            a = cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return defaultValue;
        }
        a.addAll(Arrays.asList(result));
        return a;
    }

    public boolean encode(String key, @Nullable byte[] value) {
        return this.encodeBytes(this.nativeHandle, key, value);
    }

    public boolean encode(String key, @Nullable byte[] value, int expireDurationInSecond) {
        return this.encodeBytes_2(this.nativeHandle, key, value, expireDurationInSecond);
    }

    @Nullable
    public byte[] decodeBytes(String key) {
        return this.decodeBytes(key, null);
    }

    @Nullable
    public byte[] decodeBytes(String key, @Nullable byte[] defaultValue) {
        byte[] ret = this.decodeBytes(this.nativeHandle, key);
        return ret != null ? ret : defaultValue;
    }

    private byte[] getParcelableByte(@NonNull Parcelable value) {
        Parcel source = Parcel.obtain();
        value.writeToParcel(source, 0);
        byte[] bytes = source.marshall();
        source.recycle();
        return bytes;
    }

    public boolean encode(String key, @Nullable Parcelable value) {
        if (value == null) {
            return this.encodeBytes(this.nativeHandle, key, null);
        }
        byte[] bytes = this.getParcelableByte(value);
        return this.encodeBytes(this.nativeHandle, key, bytes);
    }

    public boolean encode(String key, @Nullable Parcelable value, int expireDurationInSecond) {
        if (value == null) {
            return this.encodeBytes_2(this.nativeHandle, key, null, expireDurationInSecond);
        }
        byte[] bytes = this.getParcelableByte(value);
        return this.encodeBytes_2(this.nativeHandle, key, bytes, expireDurationInSecond);
    }

    @Nullable
    public <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass) {
        return this.decodeParcelable(key, tClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass, @Nullable T defaultValue) {
        String name;
        Parcel source;
        block11: {
            Parcelable.Creator creator;
            if (tClass == null) {
                return defaultValue;
            }
            byte[] bytes = this.decodeBytes(this.nativeHandle, key);
            if (bytes == null) {
                return defaultValue;
            }
            source = Parcel.obtain();
            source.unmarshall(bytes, 0, bytes.length);
            source.setDataPosition(0);
            name = tClass.toString();
            Parcelable parcelable = mCreators;
            synchronized (parcelable) {
                Field f;
                creator = mCreators.get(name);
                if (creator == null && (creator = (Parcelable.Creator)(f = tClass.getField("CREATOR")).get(null)) != null) {
                    mCreators.put(name, creator);
                }
            }
            if (creator == null) break block11;
            parcelable = (Parcelable)creator.createFromParcel(source);
            source.recycle();
            return (T)parcelable;
        }
        try {
            try {
                throw new Exception("Parcelable protocol requires a non-null static Parcelable.Creator object called CREATOR on class " + name);
            }
            catch (Exception e) {
                MMKV.simpleLog(MMKVLogLevel.LevelError, e.toString());
                source.recycle();
            }
        }
        catch (Throwable throwable) {
            source.recycle();
            throw throwable;
        }
        return defaultValue;
    }

    public int getValueSize(String key) {
        return this.valueSize(this.nativeHandle, key, false);
    }

    public int getValueActualSize(String key) {
        return this.valueSize(this.nativeHandle, key, true);
    }

    public boolean containsKey(String key) {
        return this.containsKey(this.nativeHandle, key);
    }

    @Nullable
    public String[] allKeys() {
        return this.allKeys(this.nativeHandle, false);
    }

    @Nullable
    public String[] allNonExpireKeys() {
        return this.allKeys(this.nativeHandle, true);
    }

    public long count() {
        return this.count(this.nativeHandle, false);
    }

    public long countNonExpiredKeys() {
        return this.count(this.nativeHandle, true);
    }

    public long totalSize() {
        return this.totalSize(this.nativeHandle);
    }

    public long actualSize() {
        return this.actualSize(this.nativeHandle);
    }

    public void removeValueForKey(String key) {
        this.removeValueForKey(this.nativeHandle, key);
    }

    public native void removeValuesForKeys(String[] var1);

    public native void clearAll();

    public native void clearAllWithKeepingSpace();

    public native void trim();

    public native void close();

    public native void clearMemoryCache();

    public void sync() {
        this.sync(true);
    }

    public void async() {
        this.sync(false);
    }

    private native void sync(boolean var1);

    public static boolean isFileValid(String mmapID) {
        return MMKV.isFileValid(mmapID, null);
    }

    public static native boolean isFileValid(String var0, @Nullable String var1);

    public static boolean removeStorage(String mmapID) {
        return MMKV.removeStorage(mmapID, null);
    }

    public static native boolean removeStorage(String var0, @Nullable String var1);

    public static boolean checkExist(String mmapID) {
        return MMKV.checkExist(mmapID, null);
    }

    public static native boolean checkExist(String var0, @Nullable String var1);

    public int importFromSharedPreferences(@NonNull SharedPreferences preferences) {
        Map kvs = preferences.getAll();
        if (kvs == null || kvs.size() <= 0) {
            return 0;
        }
        for (Map.Entry entry : kvs.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (value instanceof Boolean) {
                this.encodeBool(this.nativeHandle, key, (Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                this.encodeInt(this.nativeHandle, key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                this.encodeLong(this.nativeHandle, key, (Long)value);
                continue;
            }
            if (value instanceof Float) {
                this.encodeFloat(this.nativeHandle, key, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                this.encodeDouble(this.nativeHandle, key, (Double)value);
                continue;
            }
            if (value instanceof String) {
                this.encodeString(this.nativeHandle, key, (String)value);
                continue;
            }
            if (value instanceof Set) {
                this.encode(key, (Set)value);
                continue;
            }
            MMKV.simpleLog(MMKVLogLevel.LevelError, "unknown type: " + value.getClass());
        }
        return kvs.size();
    }

    public static native boolean backupOneToDirectory(String var0, String var1, @Nullable String var2);

    public static native boolean restoreOneMMKVFromDirectory(String var0, String var1, @Nullable String var2);

    public static native long backupAllToDirectory(String var0);

    public static native long restoreAllFromDirectory(String var0);

    public native boolean enableAutoKeyExpire(int var1);

    public native boolean disableAutoKeyExpire();

    public void enableCompareBeforeSet() {
        if (this.isExpirationEnabled()) {
            Log.e((String)"MMKV", (String)"enableCompareBeforeSet is invalid when Expiration is on");
        }
        if (this.isEncryptionEnabled()) {
            Log.e((String)"MMKV", (String)"enableCompareBeforeSet is invalid when key encryption is on");
        }
        this.nativeEnableCompareBeforeSet();
    }

    @FastNative
    private native void nativeEnableCompareBeforeSet();

    public native void disableCompareBeforeSet();

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException("Intentionally Not Supported. Use allKeys() instead, getAll() not implement because type-erasure inside mmkv");
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.decodeString(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putString(String key, @Nullable String value) {
        this.encodeString(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor putString(String key, @Nullable String value, int expireDurationInSecond) {
        this.encodeString_2(this.nativeHandle, key, value, expireDurationInSecond);
        return this;
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return this.decodeStringSet(key, defValues);
    }

    public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
        this.encode(key, values);
        return this;
    }

    public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values, int expireDurationInSecond) {
        this.encode(key, values, expireDurationInSecond);
        return this;
    }

    public SharedPreferences.Editor putBytes(String key, @Nullable byte[] bytes) {
        this.encode(key, bytes);
        return this;
    }

    public SharedPreferences.Editor putBytes(String key, @Nullable byte[] bytes, int expireDurationInSecond) {
        this.encode(key, bytes, expireDurationInSecond);
        return this;
    }

    public byte[] getBytes(String key, @Nullable byte[] defValue) {
        return this.decodeBytes(key, defValue);
    }

    public int getInt(String key, int defValue) {
        return this.decodeInt(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putInt(String key, int value) {
        this.encodeInt(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor putInt(String key, int value, int expireDurationInSecond) {
        this.encodeInt_2(this.nativeHandle, key, value, expireDurationInSecond);
        return this;
    }

    public long getLong(String key, long defValue) {
        return this.decodeLong(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putLong(String key, long value) {
        this.encodeLong(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor putLong(String key, long value, int expireDurationInSecond) {
        this.encodeLong_2(this.nativeHandle, key, value, expireDurationInSecond);
        return this;
    }

    public float getFloat(String key, float defValue) {
        return this.decodeFloat(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putFloat(String key, float value) {
        this.encodeFloat(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor putFloat(String key, float value, int expireDurationInSecond) {
        this.encodeFloat_2(this.nativeHandle, key, value, expireDurationInSecond);
        return this;
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.decodeBool(this.nativeHandle, key, defValue);
    }

    public SharedPreferences.Editor putBoolean(String key, boolean value) {
        this.encodeBool(this.nativeHandle, key, value);
        return this;
    }

    public SharedPreferences.Editor putBoolean(String key, boolean value, int expireDurationInSecond) {
        this.encodeBool_2(this.nativeHandle, key, value, expireDurationInSecond);
        return this;
    }

    public SharedPreferences.Editor remove(String key) {
        this.removeValueForKey(key);
        return this;
    }

    public SharedPreferences.Editor clear() {
        this.clearAll();
        return this;
    }

    @Deprecated
    public boolean commit() {
        this.sync(true);
        return true;
    }

    @Deprecated
    public void apply() {
        this.sync(false);
    }

    public boolean contains(String key) {
        return this.containsKey(key);
    }

    public SharedPreferences.Editor edit() {
        return this;
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Intentionally Not implement in MMKV");
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException("Intentionally Not implement in MMKV");
    }

    @NonNull
    @Contract(value="_, _, _, _ -> new")
    public static MMKV mmkvWithAshmemFD(String mmapID, int fd, int metaFD, String cryptKey) throws RuntimeException {
        long handle = MMKV.getMMKVWithAshmemFD(mmapID, fd, metaFD, cryptKey);
        if (handle == 0L) {
            throw new RuntimeException("Fail to create an ashmem MMKV instance [" + mmapID + "] in JNI");
        }
        return new MMKV(handle);
    }

    public native int ashmemFD();

    public native int ashmemMetaFD();

    @Nullable
    public static NativeBuffer createNativeBuffer(int size) {
        long pointer = MMKV.createNB(size);
        if (pointer <= 0L) {
            return null;
        }
        return new NativeBuffer(pointer, size);
    }

    public static void destroyNativeBuffer(@NonNull NativeBuffer buffer) {
        MMKV.destroyNB(buffer.pointer, buffer.size);
    }

    public int writeValueToNativeBuffer(String key, @NonNull NativeBuffer buffer) {
        return this.writeValueToNB(this.nativeHandle, key, buffer.pointer, buffer.size);
    }

    public static void registerHandler(MMKVHandler handler) {
        gCallbackHandler = handler;
        gWantLogReDirecting = gCallbackHandler.wantLogRedirecting();
        MMKV.setCallbackHandler(gWantLogReDirecting, true);
    }

    public static void unregisterHandler() {
        gCallbackHandler = null;
        MMKV.setCallbackHandler(false, false);
        gWantLogReDirecting = false;
    }

    private static int onMMKVCRCCheckFail(String mmapID) {
        MMKVRecoverStrategic strategic = MMKVRecoverStrategic.OnErrorDiscard;
        if (gCallbackHandler != null) {
            strategic = gCallbackHandler.onMMKVCRCCheckFail(mmapID);
        }
        MMKV.simpleLog(MMKVLogLevel.LevelInfo, "Recover strategic for " + mmapID + " is " + (Object)((Object)strategic));
        Integer value = recoverIndex.get((Object)strategic);
        return value == null ? 0 : value;
    }

    private static int onMMKVFileLengthError(String mmapID) {
        MMKVRecoverStrategic strategic = MMKVRecoverStrategic.OnErrorDiscard;
        if (gCallbackHandler != null) {
            strategic = gCallbackHandler.onMMKVFileLengthError(mmapID);
        }
        MMKV.simpleLog(MMKVLogLevel.LevelInfo, "Recover strategic for " + mmapID + " is " + (Object)((Object)strategic));
        Integer value = recoverIndex.get((Object)strategic);
        return value == null ? 0 : value;
    }

    private static void mmkvLogImp(int level, String file, int line, String function, String message) {
        if (gCallbackHandler != null && gWantLogReDirecting) {
            gCallbackHandler.mmkvLog(index2LogLevel[level], file, line, function, message);
        } else {
            switch (index2LogLevel[level]) {
                case LevelDebug: {
                    Log.d((String)"MMKV", (String)message);
                    break;
                }
                case LevelInfo: {
                    Log.i((String)"MMKV", (String)message);
                    break;
                }
                case LevelWarning: {
                    Log.w((String)"MMKV", (String)message);
                    break;
                }
                case LevelError: {
                    Log.e((String)"MMKV", (String)message);
                    break;
                }
            }
        }
    }

    private static void simpleLog(MMKVLogLevel level, String message) {
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stacktrace[stacktrace.length - 1];
        Integer i = logLevel2Index.get((Object)level);
        int intLevel = i == null ? 0 : i;
        MMKV.mmkvLogImp(intLevel, e.getFileName(), e.getLineNumber(), e.getMethodName(), message);
    }

    public static void registerContentChangeNotify(MMKVContentChangeNotification notify) {
        gContentChangeNotify = notify;
        MMKV.setWantsContentChangeNotify(gContentChangeNotify != null);
    }

    public static void unregisterContentChangeNotify() {
        gContentChangeNotify = null;
        MMKV.setWantsContentChangeNotify(false);
    }

    private static void onContentChangedByOuterProcess(String mmapID) {
        if (gContentChangeNotify != null) {
            gContentChangeNotify.onContentChangedByOuterProcess(mmapID);
        }
    }

    private static native void setWantsContentChangeNotify(boolean var0);

    public native void checkContentChangedByOuterProcess();

    public native boolean isMultiProcess();

    public native boolean isReadOnly();

    private MMKV(long handle) {
        this.nativeHandle = handle;
    }

    private static native void jniInitialize(String var0, String var1, int var2, boolean var3);

    static native long getMMKVWithID(String var0, int var1, @Nullable String var2, @Nullable String var3, long var4);

    private static native long getMMKVWithIDAndSize(String var0, int var1, int var2, @Nullable String var3);

    private static native long getDefaultMMKV(int var0, @Nullable String var1);

    private static native long getMMKVWithAshmemFD(String var0, int var1, int var2, @Nullable String var3);

    private native boolean encodeBool(long var1, String var3, boolean var4);

    private native boolean encodeBool_2(long var1, String var3, boolean var4, int var5);

    private native boolean decodeBool(long var1, String var3, boolean var4);

    private native boolean encodeInt(long var1, String var3, int var4);

    private native boolean encodeInt_2(long var1, String var3, int var4, int var5);

    private native int decodeInt(long var1, String var3, int var4);

    private native boolean encodeLong(long var1, String var3, long var4);

    private native boolean encodeLong_2(long var1, String var3, long var4, int var6);

    private native long decodeLong(long var1, String var3, long var4);

    private native boolean encodeFloat(long var1, String var3, float var4);

    private native boolean encodeFloat_2(long var1, String var3, float var4, int var5);

    private native float decodeFloat(long var1, String var3, float var4);

    private native boolean encodeDouble(long var1, String var3, double var4);

    private native boolean encodeDouble_2(long var1, String var3, double var4, int var6);

    private native double decodeDouble(long var1, String var3, double var4);

    private native boolean encodeString(long var1, String var3, @Nullable String var4);

    private native boolean encodeString_2(long var1, String var3, @Nullable String var4, int var5);

    @Nullable
    private native String decodeString(long var1, String var3, @Nullable String var4);

    private native boolean encodeSet(long var1, String var3, @Nullable String[] var4);

    private native boolean encodeSet_2(long var1, String var3, @Nullable String[] var4, int var5);

    @Nullable
    private native String[] decodeStringSet(long var1, String var3);

    private native boolean encodeBytes(long var1, String var3, @Nullable byte[] var4);

    private native boolean encodeBytes_2(long var1, String var3, @Nullable byte[] var4, int var5);

    @Nullable
    private native byte[] decodeBytes(long var1, String var3);

    private native boolean containsKey(long var1, String var3);

    private native String[] allKeys(long var1, boolean var3);

    private native long count(long var1, boolean var3);

    private native long totalSize(long var1);

    private native long actualSize(long var1);

    private native void removeValueForKey(long var1, String var3);

    private native int valueSize(long var1, String var3, boolean var4);

    private static native void setLogLevel(int var0);

    private static native void setCallbackHandler(boolean var0, boolean var1);

    private static native long createNB(int var0);

    private static native void destroyNB(long var0, int var2);

    private native int writeValueToNB(long var1, String var3, long var4, int var6);

    private native boolean isCompareBeforeSetEnabled();

    @FastNative
    private native boolean isEncryptionEnabled();

    @FastNative
    private native boolean isExpirationEnabled();

    private static native void enableDisableProcessMode(boolean var0);

    private static native boolean checkProcessMode(long var0);

    private static native boolean getNameSpace(String var0);

    static {
        recoverIndex.put(MMKVRecoverStrategic.OnErrorDiscard, 0);
        recoverIndex.put(MMKVRecoverStrategic.OnErrorRecover, 1);
        logLevel2Index = new EnumMap(MMKVLogLevel.class);
        logLevel2Index.put(MMKVLogLevel.LevelDebug, 0);
        logLevel2Index.put(MMKVLogLevel.LevelInfo, 1);
        logLevel2Index.put(MMKVLogLevel.LevelWarning, 2);
        logLevel2Index.put(MMKVLogLevel.LevelError, 3);
        logLevel2Index.put(MMKVLogLevel.LevelNone, 4);
        index2LogLevel = new MMKVLogLevel[]{MMKVLogLevel.LevelDebug, MMKVLogLevel.LevelInfo, MMKVLogLevel.LevelWarning, MMKVLogLevel.LevelError, MMKVLogLevel.LevelNone};
        checkedHandleSet = new HashSet<Long>();
        isNativeLibLoaded = false;
        rootDir = null;
        isProcessModeCheckerEnabled = true;
        mCreators = new HashMap();
        gWantLogReDirecting = false;
    }

    public static interface LibLoader {
        public void loadLibrary(String var1);
    }
}

