/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import org.json.JSONArray;
import org.json.JSONObject;

class WXAPiSecurityHelper {
    private static final String TAG = "MicroMsg.SDK.WXAPiSecurityHelper";
    private static final String SECURITY_KEY_TIMESTAMP_SECOND = "security_key_timestamp_second";
    private static final String STORE_VALUE_DATA = "security_key_resp";
    private static final int MAX_STORE_KEY = 100;
    private static final int MAX_STORE_VALUE = 2048;
    private final SharedPreferences sp;
    private final Context context;
    private final CopyOnWriteArraySet<String> overtimeSyncReqSet = new CopyOnWriteArraySet();

    public WXAPiSecurityHelper(Context context) {
        this.context = context;
        this.sp = context.getSharedPreferences("__wx_opensdk_sp__", 0);
    }

    private String getStoreKey(String string) {
        return "security_key_appid_".concat(String.valueOf(string));
    }

    public String extractMayNeedDoSecurityCheckUrl(String object, BaseReq baseReq) {
        if (baseReq.getType() != 2) {
            return "";
        }
        object = (SendMessageToWX.Req)baseReq;
        if (((SendMessageToWX.Req)object).message.getType() != 5) {
            return "";
        }
        object = (WXWebpageObject)((SendMessageToWX.Req)object).message.mediaObject;
        if (d.b(((WXWebpageObject)object).webpageUrl)) {
            Log.i(TAG, "webpageUrl empty, don't need check.");
            return "";
        }
        Log.i(TAG, "need check.");
        return ((WXWebpageObject)object).webpageUrl;
    }

    public int doExtraSecurityCheck(String object, String string, String string2, final ISecurityCheck iSecurityCheck) {
        Log.i(TAG, "doExtraSecurityCheck: start!");
        if (d.b((String)object) || d.b(string2)) {
            Log.e(TAG, "doExtraSecurityCheck: appid or inputurl is empty!");
            return 0;
        }
        long l = System.currentTimeMillis();
        PassContext passContext = new PassContext();
        new PassContext().reqSessionId = String.format("%s", "" + l + new Random().nextInt(9999));
        passContext.appid = object;
        passContext.inputUrl = string2;
        passContext.version = string;
        object = this.getStoredData(passContext.appid);
        string = this.context.getPackageManager();
        if (string.checkPermission("android.permission.INTERNET", string2 = this.context.getPackageName()) != 0) {
            Log.w(TAG, "doExtraSecurityCheck: No Internet permission!");
            return 0;
        }
        if (!((WXSecurityData)object).isBasicParamsAllowed()) {
            Log.d(TAG, "doExtraSecurityCheck: local data illegal!");
            this.doRequestAsync(passContext);
            return 0;
        }
        passContext.localRule = this.convert2ShareRule(passContext.appid, ((WXSecurityData)object).respDataJson);
        boolean bl = (((WXSecurityData)object).lastStoreTimeStampSecond + passContext.localRule.getLegalReqInterval()) * 1000L < System.currentTimeMillis();
        Log.d(TAG, "doExtraSecurityCheck: needDoNextReq: " + bl + ", last req time stamp:" + ((WXSecurityData)object).lastStoreTimeStampSecond);
        if (!bl) {
            int n = this.checkRuleCanPass(passContext.inputUrl, passContext.localRule);
            Log.d(TAG, "doExtraSecurityCheck: no needDoNextReq, read local rule: ".concat(String.valueOf(n)));
            if (n == 2) {
                return 1;
            }
            return 0;
        }
        Log.d(TAG, "doExtraSecurityCheck: needDoNextReq, state: " + passContext.localRule.state);
        if (passContext.localRule.state != 1) {
            this.doRequestAsync(passContext);
            return 0;
        }
        this.doRequestSync(passContext, new ISecuritySyncCheck(){

            @Override
            public void onSyncCheckFinish(boolean bl) {
                WXAPiSecurityHelper.this.extraSecurityCheckDoCallback(iSecurityCheck, bl);
            }
        });
        return 2;
    }

    private void extraSecurityCheckDoCallback(final ISecurityCheck iSecurityCheck, final boolean bl) {
        if (iSecurityCheck != null) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    Log.d(WXAPiSecurityHelper.TAG, "has got result, callback on Main Thread.");
                    iSecurityCheck.onCheckFinish(bl);
                }
            });
        }
    }

    private void doRequestAsync(PassContext passContext) {
        Log.d(TAG, "doRequestAsync");
        this.doRequest(passContext, new IHttpCheckCallback(){

            @Override
            public void onHttpCheckFinish(PromiseShareRule promiseShareRule) {
                WXAPiSecurityHelper.this.storeIfNecessary(promiseShareRule);
            }
        });
    }

    private void doRequestSync(final PassContext passContext, final ISecuritySyncCheck iSecuritySyncCheck) {
        Log.i(TAG, "requestId = " + passContext.reqSessionId);
        final Timer timer = new Timer(passContext.reqSessionId);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                Log.i(WXAPiSecurityHelper.TAG, "sync request overtime, requestId = " + passContext.reqSessionId);
                WXAPiSecurityHelper.this.overtimeSyncReqSet.add(passContext.reqSessionId);
                if (iSecuritySyncCheck != null) {
                    iSecuritySyncCheck.onSyncCheckFinish(true);
                }
            }
        }, passContext.localRule.getLegalUserWaitTime());
        this.doRequest(passContext, new IHttpCheckCallback(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void onHttpCheckFinish(PromiseShareRule var1_1) {
                block3: {
                    block5: {
                        block6: {
                            block4: {
                                timer.cancel();
                                if (WXAPiSecurityHelper.access$400(WXAPiSecurityHelper.this).contains(passContext.reqSessionId)) {
                                    WXAPiSecurityHelper.access$400(WXAPiSecurityHelper.this).remove(passContext.reqSessionId);
                                    WXAPiSecurityHelper.access$300(WXAPiSecurityHelper.this, var1_1);
                                    return;
                                }
                                if (iSecuritySyncCheck == null) break block3;
                                var2_2 = WXAPiSecurityHelper.access$500(WXAPiSecurityHelper.this, passContext.inputUrl, var1_1);
                                if (var2_2 != 1) break block4;
                                v0 = iSecuritySyncCheck;
                                v1 = true;
                                break block5;
                            }
                            if (var2_2 != 2) break block6;
                            v0 = iSecuritySyncCheck;
                            ** GOTO lbl-1000
                        }
                        var2_3 = WXAPiSecurityHelper.this.getStoredData(passContext.appid);
                        var2_3 = WXAPiSecurityHelper.this.convert2ShareRule(passContext.appid, var2_3.respDataJson);
                        var2_4 = WXAPiSecurityHelper.access$500(WXAPiSecurityHelper.this, passContext.inputUrl, (PromiseShareRule)var2_3);
                        v0 = iSecuritySyncCheck;
                        if (var2_4 != 2) {
                            v1 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                    }
                    v0.onSyncCheckFinish(v1);
                }
                WXAPiSecurityHelper.access$300(WXAPiSecurityHelper.this, var1_1);
            }
        });
    }

    private void doRequest(final PassContext passContext, final IHttpCheckCallback iHttpCheckCallback) {
        d.b().submit(new Runnable(){

            @Override
            public void run() {
                Object object = WXAPiSecurityHelper.this.postHttpRequest(passContext.appid, passContext.version, passContext.localRule.buffer);
                object = WXAPiSecurityHelper.this.convert2ShareRule(passContext.appid, ((StringBuffer)object).toString());
                iHttpCheckCallback.onHttpCheckFinish((PromiseShareRule)object);
            }
        });
    }

    protected StringBuffer postHttpRequest(String object, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object = URLEncoder.encode((String)object, "UTF-8");
            string2 = URLEncoder.encode(string2, "UTF-8");
            String string3 = String.format("https://mp.weixin.qq.com/publicpoc/opensdkconf?action=GetShareConf&appid=%s&sdkVersion=%s&buffer=%s", object, string, string2);
            Log.d(TAG, "request http, url = " + string3 + ", appid = " + (String)object + ", version = " + string + ", buffer = " + string2);
            object = (HttpURLConnection)new URL(string3).openConnection();
            ((URLConnection)object).setConnectTimeout(60000);
            ((URLConnection)object).setReadTimeout(60000);
            ((URLConnection)object).setRequestProperty("Content-Type", "application/json");
            ((URLConnection)object).connect();
            int n = ((HttpURLConnection)object).getResponseCode();
            Log.i(TAG, "http respCode = ".concat(String.valueOf(n)));
            if (n == 200) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object).getInputStream()));
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string2);
                }
                Log.d(TAG, "http response = ".concat(String.valueOf(stringBuffer)));
                bufferedReader.close();
            }
            ((HttpURLConnection)object).disconnect();
        }
        catch (Exception exception) {
            Log.e(TAG, "http request fail, ex = " + exception.getMessage());
        }
        return stringBuffer;
    }

    private void storeIfNecessary(PromiseShareRule promiseShareRule) {
        Log.d(TAG, "storeIfNecessary");
        if (d.b(promiseShareRule.reqAppid) || promiseShareRule.reqAppid.length() > 100) {
            Log.i(TAG, "store fail! reqAppid illegal!");
            return;
        }
        if (d.b(promiseShareRule.orgJsonData) || promiseShareRule.orgJsonData.length() > 2048) {
            Log.i(TAG, "store fail! response json illegal!");
            return;
        }
        if (promiseShareRule.state == 1 && promiseShareRule.reqAppid.equals(promiseShareRule.appidInRule)) {
            Log.d(TAG, "storeIfNecessary, in rule");
            this.storeCheckResp(promiseShareRule.reqAppid, promiseShareRule);
        }
        if (promiseShareRule.state == 2) {
            Log.d(TAG, "storeIfNecessary, not rule");
            this.storeCheckResp(promiseShareRule.reqAppid, promiseShareRule);
        }
    }

    protected String cookStoreJson(String string, PromiseShareRule promiseShareRule) {
        if (promiseShareRule == null || d.b(string)) {
            return "";
        }
        try {
            string = "";
            if (promiseShareRule.state == 2) {
                string = new JSONObject();
                string.put("state", promiseShareRule.state);
                string.put("interval", promiseShareRule.getLegalReqInterval());
                string.put("buffer", (Object)(promiseShareRule.buffer.length() > 64 ? "" : promiseShareRule.buffer));
                string = string.toString();
            } else if (promiseShareRule.state == 1) {
                string = this.covertShareRule2Json(promiseShareRule);
            }
            return string;
        }
        catch (Exception exception) {
            Log.e(TAG, "storeCheckResp fail, ex = " + exception.getMessage());
            return "";
        }
    }

    private void storeCheckResp(String string, PromiseShareRule object) {
        object = this.cookStoreJson(string, (PromiseShareRule)object);
        Log.d(TAG, "cookStoreJson = ".concat(String.valueOf(object)));
        if (d.b((String)object)) {
            Log.w(TAG, "cookStoreJson get null!");
            return;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(SECURITY_KEY_TIMESTAMP_SECOND, System.currentTimeMillis() / 1000L);
            jSONObject.put(STORE_VALUE_DATA, object);
            this.commitSp(string, jSONObject.toString());
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "storeCheckResp fail, ex = " + exception.getMessage());
            return;
        }
    }

    protected void commitSp(String string, String string2) {
        SharedPreferences.Editor editor = this.sp.edit();
        editor.putString(this.getStoreKey(string), string2);
        editor.commit();
    }

    protected String getLocalStoredJson(String string) {
        return this.getStoredData((String)string).respDataJson;
    }

    protected WXSecurityData getStoredData(String string) {
        WXSecurityData wXSecurityData = new WXSecurityData();
        Log.d(TAG, "getStoredData, appid = ".concat(String.valueOf(string)));
        try {
            String string2 = this.getStoreKey(string);
            if (!this.sp.contains(string2)) {
                Log.d(TAG, "getStoredData, fail, not exist!");
            } else {
                string2 = this.sp.getString(this.getStoreKey(string), "");
                string2 = new JSONObject(string2);
                long l = string2.optLong(SECURITY_KEY_TIMESTAMP_SECOND);
                string2 = string2.optString(STORE_VALUE_DATA);
                wXSecurityData.appid = string;
                wXSecurityData.lastStoreTimeStampSecond = l;
                wXSecurityData.respDataJson = string2;
                Log.d(TAG, "getStoredData, Ok, appid = " + string + "timeStampSecond: " + wXSecurityData.lastStoreTimeStampSecond);
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "getStoredData fail, ex = " + exception.getMessage());
        }
        return wXSecurityData;
    }

    private int checkRuleCanPass(String string, PromiseShareRule promiseShareRule) {
        Log.d(TAG, "checkRuleCanPass, start check!");
        if (promiseShareRule.orgJsonData.length() > 2048) {
            Log.w(TAG, "response json is too long!");
            return 0;
        }
        if (promiseShareRule.state == 2) {
            Log.d(TAG, "checkRuleCanPass, not in rule");
            return 1;
        }
        if (promiseShareRule.state == 1 && promiseShareRule.appidInRule.equals(promiseShareRule.reqAppid)) {
            if (promiseShareRule.urlRuleList.size() == 0) {
                Log.d(TAG, "checkRuleCanPass, urlRuleList empty!");
                return 1;
            }
            boolean bl = this.checkUrlParametersLegal(string, promiseShareRule);
            Log.d(TAG, "checkRuleCanPass, urlCheckResult = ".concat(String.valueOf(bl)));
            if (!bl) {
                Log.d(TAG, "checkRuleCanPass, no pass");
                return 2;
            }
            Log.d(TAG, "checkRuleCanPass, pass");
            return 1;
        }
        Log.d(TAG, "checkRuleCanPass, unknown");
        return 0;
    }

    private boolean checkUrlParametersLegal(String string, PromiseShareRule promiseShareRule) {
        String string2 = (string = Uri.parse((String)string)).getHost();
        if (d.b(string2)) {
            Log.i(TAG, "checkUrlParameters, host empty!");
            return false;
        }
        for (int i = 0; i < promiseShareRule.urlRuleList.size(); ++i) {
            UrlRule urlRule = promiseShareRule.urlRuleList.get(i);
            if (!string2.equals(urlRule.host)) continue;
            try {
                int n;
                int n2 = 0;
                for (n = 0; n < urlRule.mustQueryKey.size(); n += 1) {
                    String string3 = urlRule.mustQueryKey.get(n);
                    Log.d(TAG, "checkRuleCanPass, key = ".concat(String.valueOf(string3)));
                    if (d.b(string.getQueryParameter(string3))) continue;
                    ++n2;
                }
                n = n2 == urlRule.mustQueryKey.size() ? 1 : 0;
                Log.d(TAG, "checkRuleCanPass, rule.host = " + urlRule.host + ", queryOk = " + (n != 0));
                return n != 0;
            }
            catch (Exception exception) {
                Log.e(TAG, "checkRuleCanPass, parse fail, e = %s" + exception.getMessage());
            }
        }
        return false;
    }

    protected String covertShareRule2Json(PromiseShareRule object) {
        String string = "";
        if (object == null) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("state", ((PromiseShareRule)object).state);
            jSONObject.put("appid_rule", (Object)((PromiseShareRule)object).appidInRule);
            jSONObject.put("wait_time", ((PromiseShareRule)object).userWaitTimeMs);
            jSONObject.put("interval", ((PromiseShareRule)object).nextRequestIntervalSecond);
            jSONObject.put("buffer", (Object)(((PromiseShareRule)object).buffer.length() > 64 ? "" : ((PromiseShareRule)object).buffer));
            JSONArray jSONArray = new JSONArray();
            for (UrlRule urlRule : ((PromiseShareRule)object).urlRuleList) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put("host", (Object)urlRule.host);
                jSONObject2.put("querys", (Object)new JSONArray(urlRule.mustQueryKey));
                jSONArray.put((Object)jSONObject2);
            }
            jSONObject.put("rules", (Object)jSONArray);
            string = jSONObject.toString();
        }
        catch (Exception exception) {
            Log.e(TAG, "covertShareRule2Json fail, ex = " + exception.getMessage());
        }
        return string;
    }

    protected PromiseShareRule convert2ShareRule(String string, String string2) {
        PromiseShareRule promiseShareRule = new PromiseShareRule();
        new PromiseShareRule().reqAppid = string;
        promiseShareRule.orgJsonData = string2;
        if (d.b(string2)) {
            Log.d(TAG, "convert2ShareRule: jsonRespData is empty");
            return promiseShareRule;
        }
        try {
            string = new JSONObject(string2);
            promiseShareRule.state = string.optInt("state", 0);
            promiseShareRule.appidInRule = string.optString("appid_rule", "");
            promiseShareRule.userWaitTimeMs = string.optLong("wait_time", 0L);
            promiseShareRule.nextRequestIntervalSecond = string.optLong("interval", 0L);
            promiseShareRule.buffer = string.optString("buffer", "");
            string = string.optJSONArray("rules");
            if (string != null) {
                for (int i = 0; i < string.length(); ++i) {
                    JSONObject jSONObject = string.getJSONObject(i);
                    UrlRule urlRule = new UrlRule();
                    new UrlRule().host = jSONObject.optString("host");
                    if ((jSONObject = jSONObject.optJSONArray("querys")) != null) {
                        for (int j = 0; j < jSONObject.length(); ++j) {
                            if (d.b(jSONObject.optString(j, ""))) continue;
                            urlRule.mustQueryKey.add(jSONObject.optString(j, ""));
                        }
                    }
                    promiseShareRule.urlRuleList.add(urlRule);
                }
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "coverJson2ShareRule fail, ex = " + exception.getMessage());
        }
        return promiseShareRule;
    }

    static /* synthetic */ int access$500(WXAPiSecurityHelper wXAPiSecurityHelper, String string, PromiseShareRule promiseShareRule) {
        return wXAPiSecurityHelper.checkRuleCanPass(string, promiseShareRule);
    }

    private static class UrlRule {
        String host = "";
        List<String> mustQueryKey = new ArrayList<String>();

        private UrlRule() {
        }
    }

    private static class PromiseShareRule {
        String orgJsonData = "";
        String reqAppid = "";
        int state;
        String appidInRule = "";
        List<UrlRule> urlRuleList = new ArrayList<UrlRule>();
        long userWaitTimeMs;
        public long nextRequestIntervalSecond;
        String buffer = "";

        private PromiseShareRule() {
        }

        public long getLegalUserWaitTime() {
            long l = 5000L;
            if (this.userWaitTimeMs > 100L && this.userWaitTimeMs < 60000L) {
                l = this.userWaitTimeMs;
            }
            Log.d(WXAPiSecurityHelper.TAG, "getLegalUserWaitTime = ".concat(String.valueOf(l)));
            return l;
        }

        public long getLegalReqInterval() {
            long l = 3600L;
            if (this.nextRequestIntervalSecond > 0L && this.nextRequestIntervalSecond < 86400L) {
                l = this.nextRequestIntervalSecond;
            }
            Log.d(WXAPiSecurityHelper.TAG, "getLegalReqInterval = ".concat(String.valueOf(l)));
            return l;
        }
    }

    private static class PassContext {
        String reqSessionId = "";
        String appid = "";
        String inputUrl = "";
        String version = "";
        PromiseShareRule localRule = new PromiseShareRule();

        private PassContext() {
        }
    }

    private static class CheckRuleResult {
        public static final int Unknown = 0;
        public static final int Pass = 1;
        public static final int NoPass = 2;

        private CheckRuleResult() {
        }
    }

    public static class ExtraSecurityCheckRes {
        public static final int Directly_Pass = 0;
        public static final int Directly_NoPass = 1;
        public static final int Need_Deep_Check = 2;
    }

    private static class RuleState {
        public static final int None = 0;
        public static final int InRule = 1;
        public static final int NotInRule = 2;

        private RuleState() {
        }
    }

    private static class WXSecurityData {
        long lastStoreTimeStampSecond;
        String appid = "";
        String respDataJson = "";

        private WXSecurityData() {
        }

        public boolean isBasicParamsAllowed() {
            boolean bl;
            boolean bl2 = this.lastStoreTimeStampSecond > 0L && this.lastStoreTimeStampSecond < System.currentTimeMillis() / 1000L;
            boolean bl3 = !d.b(this.appid);
            boolean bl4 = bl = !d.b(this.respDataJson);
            return bl2 && bl3 && bl;
        }
    }

    static interface IHttpCheckCallback {
        public void onHttpCheckFinish(PromiseShareRule var1);
    }

    static interface ISecuritySyncCheck {
        public void onSyncCheckFinish(boolean var1);
    }

    static interface ISecurityCheck {
        public void onCheckFinish(boolean var1);
    }
}

