/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelmsg.WXFileObject;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.utils.Log;

public class SendMessageToWX {
    private SendMessageToWX() {
    }

    public static class Resp
    extends BaseResp {
        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
        }

        @Override
        public boolean checkArgs() {
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        public static final int WXSceneSession = 0;
        public static final int WXSceneTimeline = 1;
        public static final int WXSceneFavorite = 2;
        public static final int WXSceneSpecifiedContact = 3;
        public static final int WXSceneStatus = 4;
        private static final String TAG = "MicroMsg.SDK.SendMessageToWX.Req";
        private static final int FAV_CONTENT_LENGTH_LIMIT = 0x1900000;
        private static final String SCENE_DATA_OBJECT_KEY_IDENTIFIER = "_scene_data_object_identifier";
        public WXMediaMessage message;
        public int scene;
        public IWXSceneDataObject sceneDataObject;
        public String userOpenId;

        public Req() {
        }

        public Req(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.message = WXMediaMessage.Builder.fromBundle(bundle);
            this.scene = bundle.getInt("_wxapi_sendmessagetowx_req_scene");
            this.userOpenId = bundle.getString("_wxapi_sendmessagetowx_req_use_open_id");
            String string = bundle.getString(SCENE_DATA_OBJECT_KEY_IDENTIFIER);
            try {
                if (string != null) {
                    Class<?> clazz = Class.forName(string);
                    this.sceneDataObject = (IWXSceneDataObject)clazz.newInstance();
                    this.sceneDataObject.unserialize(bundle);
                }
                return;
            }
            catch (Exception exception) {
                Log.e(TAG, "get WXSceneDataObject from bundle failed: unknown ident " + string + ", ex = " + exception.getMessage());
                return;
            }
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putAll(WXMediaMessage.Builder.toBundle(this.message));
            bundle.putInt("_wxapi_sendmessagetowx_req_scene", this.scene);
            bundle.putInt("_wxapi_sendmessagetowx_req_media_type", this.message.getType());
            bundle.putString("_wxapi_sendmessagetowx_req_use_open_id", this.userOpenId);
            if (this.sceneDataObject != null) {
                bundle.putString(SCENE_DATA_OBJECT_KEY_IDENTIFIER, this.sceneDataObject.getClass().getName());
                this.sceneDataObject.serialize(bundle);
            }
        }

        @Override
        public boolean checkArgs() {
            if (this.message == null) {
                Log.e(TAG, "checkArgs fail ,message is null");
                return false;
            }
            if (this.message.mediaObject.type() == 6 && this.scene == 2) {
                ((WXFileObject)this.message.mediaObject).setContentLengthLimit(0x1900000);
            }
            if (this.scene == 3 && this.userOpenId == null) {
                Log.e(TAG, "Send specifiedContact userOpenId can not be null.");
                return false;
            }
            if (this.scene == 3 && this.openId == null) {
                Log.e(TAG, "Send specifiedContact openid can not be null.");
                return false;
            }
            if (this.scene == 4) {
                if (this.sceneDataObject == null) {
                    Log.e(TAG, "checkArgs fail, sceneDataObject is null");
                    return false;
                }
                if (this.message.getType() == 1) {
                    return this.sceneDataObject.checkArgs();
                }
                return this.message.checkArgs() && this.sceneDataObject.checkArgs();
            }
            return this.message.checkArgs();
        }
    }

    public static interface IWXMusicVipObject {
        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public boolean checkArgs();
    }

    public static interface IWXSceneDataObject {
        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public boolean checkArgs();

        public int getJumpType();
    }
}

