/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import com.tencent.mm.opensdk.a.a;
import com.tencent.mm.opensdk.a.a.a;
import com.tencent.mm.opensdk.a.a.b;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelbiz.AddCardToWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.ChooseCardFromWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.CreateChatroom;
import com.tencent.mm.opensdk.modelbiz.JoinChatroom;
import com.tencent.mm.opensdk.modelbiz.OpenWebview;
import com.tencent.mm.opensdk.modelmsg.GetMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.LaunchFromWX;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.ShowMessageFromWX;
import com.tencent.mm.opensdk.modelpay.PayResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.MMSharedPreferences;
import com.tencent.mm.opensdk.openapi.WXApiImplComm;

final class WXApiImplV10
implements IWXAPI {
    private static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    private Context context;
    private String appId;
    private boolean checkSignature = false;
    private boolean detached = false;
    private static String wxappPayEntryClassname = null;

    WXApiImplV10(Context context, String string, boolean bl) {
        Log.d((String)TAG, (String)("<init>, appId = " + string + ", checkSignature = " + bl));
        this.context = context;
        this.appId = string;
        this.checkSignature = bl;
    }

    @Override
    public final boolean registerApp(String string) {
        return this.registerApp(string, 0L);
    }

    @Override
    public final boolean registerApp(String object, long l) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e((String)TAG, (String)"register app failed for wechat app signature check failed");
            return false;
        }
        Log.d((String)TAG, (String)("registerApp, appId = " + (String)object));
        if (object != null) {
            this.appId = object;
        }
        Log.d((String)TAG, (String)("registerApp, appId = " + (String)object));
        if (object != null) {
            this.appId = object;
        }
        Log.d((String)TAG, (String)("register app " + this.context.getPackageName()));
        object = new a.a();
        new a.a().e = "com.tencent.mm";
        ((a.a)object).f = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).c = "weixin://registerapp?appid=" + this.appId;
        ((a.a)object).g = l;
        return com.tencent.mm.opensdk.a.a.a.a(this.context, (a.a)object);
    }

    @Override
    public final void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e((String)TAG, (String)"unregister app failed for wechat app signature check failed");
            return;
        }
        Log.d((String)TAG, (String)("unregisterApp, appId = " + this.appId));
        if (this.appId == null || this.appId.length() == 0) {
            Log.e((String)TAG, (String)"unregisterApp fail, appId is empty");
            return;
        }
        Log.d((String)TAG, (String)("unregister app " + this.context.getPackageName()));
        a.a a2 = new a.a();
        new a.a().e = "com.tencent.mm";
        a2.f = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a2.c = "weixin://unregisterapp?appid=" + this.appId;
        com.tencent.mm.opensdk.a.a.a.a(this.context, a2);
    }

    @Override
    public final boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        try {
            if (!WXApiImplComm.isIntentFromWx(object, "com.tencent.mm.openapi.token")) {
                Log.i((String)TAG, (String)"handleIntent fail, intent not from weixin msg");
                return false;
            }
            if (this.detached) {
                throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
            }
            Object object2 = object.getStringExtra("_mmessage_content");
            int n = object.getIntExtra("_mmessage_sdkVersion", 0);
            String string = object.getStringExtra("_mmessage_appPackage");
            if (string == null || string.length() == 0) {
                Log.e((String)TAG, (String)"invalid argument");
                return false;
            }
            byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
            if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, n, string)))) {
                Log.e((String)TAG, (String)"checksum fail");
                return false;
            }
            int n2 = object.getIntExtra("_wxapi_command_type", 0);
            switch (n2) {
                case 1: {
                    object = new SendAuth.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 2: {
                    object = new SendMessageToWX.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 3: {
                    object = new GetMessageFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 4: {
                    object = new ShowMessageFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 5: {
                    object = new PayResp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 6: {
                    object = new LaunchFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 9: {
                    object = new AddCardToWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 16: {
                    object = new ChooseCardFromWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 14: {
                    object = new CreateChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 15: {
                    object = new JoinChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 12: {
                    object = new OpenWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
            }
            Log.e((String)TAG, (String)("unknown cmd = " + n2));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("handleIntent fail, ex = " + exception.getMessage()));
        }
        return false;
    }

    @Override
    public final boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @Override
    public final boolean isWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        return this.getWXAppSupportAPI() >= 0x24000002;
    }

    @Override
    public final int getWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e((String)TAG, (String)"open wx app failed, not installed or signature check failed");
            return 0;
        }
        int n = new MMSharedPreferences(this.context).getInt("_build_info_sdk_int_", 0);
        if (n == 0) {
            try {
                n = this.context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getInt("com.tencent.mm.BuildInfo.OPEN_SDK_VERSION", 0);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("get from metaData failed : " + exception.getMessage()));
            }
        }
        return n;
    }

    @Override
    public final boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e((String)TAG, (String)"open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("startActivity fail, exception = " + exception.getMessage()));
            return false;
        }
        return true;
    }

    @Override
    public final boolean sendReq(BaseReq object) {
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e((String)TAG, (String)"sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseReq)object).checkArgs()) {
            Log.e((String)TAG, (String)"sendReq checkArgs fail");
            return false;
        }
        Log.d((String)TAG, (String)("sendReq, req type = " + ((BaseReq)object).getType()));
        Bundle bundle = new Bundle();
        ((BaseReq)object).toBundle(bundle);
        if (((BaseReq)object).getType() == 5) {
            return this.sendPayReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 7) {
            return this.sendJumpToBizProfileReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 8) {
            return this.sendJumpToBizWebviewReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 10) {
            return this.sendJumpToBizTempSessionReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 9) {
            return this.sendAddCardToWX(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 16) {
            return this.sendChooseCardFromWX(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 11) {
            return this.sendOpenRankListReq(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 12) {
            return this.sendOpenWebview(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 13) {
            return this.sendOpenBusiLuckyMoney(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 14) {
            return this.createChatroom(this.context, bundle);
        }
        if (((BaseReq)object).getType() == 15) {
            return this.joinChatroom(this.context, bundle);
        }
        object = new a.a();
        new a.a().d = bundle;
        ((a.a)object).c = "weixin://sendreq?appid=" + this.appId;
        ((a.a)object).a = "com.tencent.mm";
        ((a.a)object).b = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return a.a(this.context, (a.a)object);
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new MMSharedPreferences(context).getString("_wxapp_pay_entry_classname_", null);
            Log.d((String)TAG, (String)("pay, set wxappPayEntryClassname = " + wxappPayEntryClassname));
            if (wxappPayEntryClassname == null) {
                try {
                    wxappPayEntryClassname = context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getString("com.tencent.mm.BuildInfo.OPEN_SDK_PAY_ENTRY_CLASSNAME", null);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)("get from metaData failed : " + exception.getMessage()));
                }
            }
            if (wxappPayEntryClassname == null) {
                Log.e((String)TAG, (String)"pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        a.a a2 = new a.a();
        new a.a().d = bundle;
        a2.a = "com.tencent.mm";
        a2.b = wxappPayEntryClassname;
        return a.a(context, a2);
    }

    private boolean sendJumpToBizProfileReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_profile_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_profile_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_scene"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_profile_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizWebviewReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_scene")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizTempSessionReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizTempSession");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_session_from"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_show_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendAddCardToWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/addCardToWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_add_card_to_wx_card_list"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendChooseCardFromWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/chooseCardFromWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{stringArray.getString("_wxapi_choose_card_from_wx_card_app_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_location_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_sign_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_sign"), stringArray.getString("_wxapi_choose_card_from_wx_card_time_stamp"), stringArray.getString("_wxapi_choose_card_from_wx_card_nonce_str"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_can_multi_select"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenRankListReq(Context context, Bundle bundle) {
        String[] stringArray;
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openRankList");
        if ((context = context.query((Uri)bundle, null, null, stringArray = new String[0], null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenWebview(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openWebview");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_webview_url"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusiLuckyMoney(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusiLuckyMoney");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_open_busi_lucky_money_timeStamp"), stringArray.getString("_wxapi_open_busi_lucky_money_nonceStr"), stringArray.getString("_wxapi_open_busi_lucky_money_signType"), stringArray.getString("_wxapi_open_busi_lucky_money_signature"), stringArray.getString("_wxapi_open_busi_lucky_money_package")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean createChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/createChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_create_chatroom_group_id", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_name", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_create_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean joinChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/joinChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_join_chatroom_group_id", ""), stringArray.getString("_wxapi_join_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_join_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    @Override
    public final boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e((String)TAG, (String)"sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            Log.e((String)TAG, (String)"sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        ((BaseResp)object).toBundle(bundle);
        object = new a.a();
        new a.a().d = bundle;
        ((a.a)object).c = "weixin://sendresp?appid=" + this.appId;
        ((a.a)object).a = "com.tencent.mm";
        ((a.a)object).b = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return a.a(this.context, (a.a)object);
    }

    @Override
    public final void detach() {
        Log.d((String)TAG, (String)"detach");
        this.detached = true;
        this.context = null;
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            Log.e((String)TAG, (String)"checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            Log.e((String)TAG, (String)"checkSumConsistent fail, length is different");
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

