/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.mm.opensdk.channel.MMessageActV2;
import com.tencent.mm.opensdk.channel.a.a;
import com.tencent.mm.opensdk.channel.a.b;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelbiz.AddCardToWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.ChooseCardFromWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.CreateChatroom;
import com.tencent.mm.opensdk.modelbiz.HandleScanResult;
import com.tencent.mm.opensdk.modelbiz.JoinChatroom;
import com.tencent.mm.opensdk.modelbiz.OpenWebview;
import com.tencent.mm.opensdk.modelbiz.SubscribeMessage;
import com.tencent.mm.opensdk.modelmsg.GetMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.LaunchFromWX;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.ShowMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.WXMiniProgramObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.modelpay.PayResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.MMSharedPreferences;
import com.tencent.mm.opensdk.openapi.WXApiImplComm;
import com.tencent.mm.opensdk.utils.ILog;
import com.tencent.mm.opensdk.utils.d;
import com.tencent.wxop.stat.MtaSDkException;
import com.tencent.wxop.stat.StatConfig;
import com.tencent.wxop.stat.StatReportStrategy;
import com.tencent.wxop.stat.StatService;

final class WXApiImplV10
implements IWXAPI {
    private static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    private static ActivityLifecycleCb activityCb = null;
    private Context context;
    private String appId;
    private boolean checkSignature = false;
    private boolean detached = false;
    private static String wxappPayEntryClassname = null;

    WXApiImplV10(Context context, String string, boolean bl) {
        com.tencent.mm.opensdk.utils.Log.d(TAG, "<init>, appId = " + string + ", checkSignature = " + bl);
        this.context = context;
        this.appId = string;
        this.checkSignature = bl;
    }

    @Override
    public final boolean registerApp(String string) {
        return this.registerApp(string, 0L);
    }

    @Override
    public final boolean registerApp(String object, long l2) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "register app failed for wechat app signature check failed");
            return false;
        }
        com.tencent.mm.opensdk.utils.Log.d(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        if (activityCb == null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Activity)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                this.initMta(this.context, (String)object);
                activityCb = new ActivityLifecycleCb(this.context);
                ((Service)this.context).getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else {
                com.tencent.mm.opensdk.utils.Log.w(TAG, "context is not instanceof Activity or Service, disable WXStat");
            }
        }
        com.tencent.mm.opensdk.utils.Log.d(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        com.tencent.mm.opensdk.utils.Log.d(TAG, "register app " + this.context.getPackageName());
        object = new a.a();
        new a.a().W = "com.tencent.mm";
        ((a.a)object).action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).content = "weixin://registerapp?appid=" + this.appId;
        ((a.a)object).X = l2;
        return a.a(this.context, (a.a)object);
    }

    @Override
    public final void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "unregister app failed for wechat app signature check failed");
            return;
        }
        com.tencent.mm.opensdk.utils.Log.d(TAG, "unregisterApp, appId = " + this.appId);
        if (this.appId == null || this.appId.length() == 0) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "unregisterApp fail, appId is empty");
            return;
        }
        com.tencent.mm.opensdk.utils.Log.d(TAG, "unregister app " + this.context.getPackageName());
        a.a a2 = new a.a();
        new a.a().W = "com.tencent.mm";
        a2.action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a2.content = "weixin://unregisterapp?appid=" + this.appId;
        a.a(this.context, a2);
    }

    @Override
    public final boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        try {
            if (!WXApiImplComm.isIntentFromWx(object, "com.tencent.mm.openapi.token")) {
                com.tencent.mm.opensdk.utils.Log.i(TAG, "handleIntent fail, intent not from weixin msg");
                return false;
            }
            if (this.detached) {
                throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
            }
            Object object2 = object.getStringExtra("_mmessage_content");
            int n2 = object.getIntExtra("_mmessage_sdkVersion", 0);
            String string = object.getStringExtra("_mmessage_appPackage");
            if (string == null || string.length() == 0) {
                com.tencent.mm.opensdk.utils.Log.e(TAG, "invalid argument");
                return false;
            }
            byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
            if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, n2, string)))) {
                com.tencent.mm.opensdk.utils.Log.e(TAG, "checksum fail");
                return false;
            }
            int n3 = object.getIntExtra("_wxapi_command_type", 0);
            com.tencent.mm.opensdk.utils.Log.i(TAG, "handleIntent, cmd = " + n3);
            switch (n3) {
                case 1: {
                    object = new SendAuth.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 2: {
                    object = new SendMessageToWX.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 3: {
                    object = new GetMessageFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 4: {
                    object = new ShowMessageFromWX.Req(object.getExtras());
                    String string2 = object.message.messageExt;
                    if (string2 != null && string2.contains("wx_internal_resptype")) {
                        boolean bl = this.handleWxInternalRespType(string2, iWXAPIEventHandler);
                        com.tencent.mm.opensdk.utils.Log.i(TAG, "handleIntent, extInfo contains wx_internal_resptype, ret = " + bl);
                        return bl;
                    }
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 5: {
                    object = new PayResp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 6: {
                    object = new LaunchFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 9: {
                    object = new AddCardToWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 16: {
                    object = new ChooseCardFromWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 14: {
                    object = new CreateChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 15: {
                    object = new JoinChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 12: {
                    object = new OpenWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 17: {
                    object = new HandleScanResult.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
            }
            com.tencent.mm.opensdk.utils.Log.e(TAG, "unknown cmd = " + n3);
        }
        catch (Exception exception) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "handleIntent fail, ex = " + exception.getMessage());
        }
        return false;
    }

    private boolean handleWxInternalRespType(String string, IWXAPIEventHandler iWXAPIEventHandler) {
        com.tencent.mm.opensdk.utils.Log.i(TAG, "handleWxInternalRespType, extInfo = " + string);
        string = "http://www.qq.com/s?" + string;
        try {
            string = Uri.parse((String)string);
            Object object = string.getQueryParameter("wx_internal_resptype");
            com.tencent.mm.opensdk.utils.Log.i(TAG, "handleWxInternalRespType, respType = " + (String)object);
            if (d.h((String)object)) {
                com.tencent.mm.opensdk.utils.Log.e(TAG, "handleWxInternalRespType fail, respType is null");
                return false;
            }
            if (((String)object).equals("subscribemessage")) {
                object = new SubscribeMessage.Resp();
                new SubscribeMessage.Resp().openId = string.getQueryParameter("openid");
                ((SubscribeMessage.Resp)object).templateID = string.getQueryParameter("template_id");
                ((SubscribeMessage.Resp)object).scene = d.i(string.getQueryParameter("scene"));
                ((SubscribeMessage.Resp)object).action = string.getQueryParameter("action");
                ((SubscribeMessage.Resp)object).reserved = string.getQueryParameter("reserved");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            com.tencent.mm.opensdk.utils.Log.e(TAG, "handleWxInternalRespType fail, unknown resptype = " + (String)object);
        }
        catch (Exception exception) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "handleWxInternalRespType fail, ex = " + exception.getMessage());
        }
        return false;
    }

    @Override
    public final boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @Override
    public final boolean isWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        return this.getWXAppSupportAPI() >= 620756998;
    }

    @Override
    public final int getWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return 0;
        }
        int n2 = new MMSharedPreferences(this.context).getInt("_build_info_sdk_int_", 0);
        if (n2 == 0) {
            try {
                n2 = this.context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getInt("com.tencent.mm.BuildInfo.OPEN_SDK_VERSION", 0);
            }
            catch (Exception exception) {
                com.tencent.mm.opensdk.utils.Log.e(TAG, "get from metaData failed : " + exception.getMessage());
            }
        }
        return n2;
    }

    @Override
    public final boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public final boolean sendReq(BaseReq baseReq) {
        Object object;
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "sendReq checkArgs fail");
            return false;
        }
        com.tencent.mm.opensdk.utils.Log.i(TAG, "sendReq, req type = " + baseReq.getType());
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        if (baseReq.getType() == 5) {
            return this.sendPayReq(this.context, bundle);
        }
        if (baseReq.getType() == 7) {
            return this.sendJumpToBizProfileReq(this.context, bundle);
        }
        if (baseReq.getType() == 8) {
            return this.sendJumpToBizWebviewReq(this.context, bundle);
        }
        if (baseReq.getType() == 10) {
            return this.sendJumpToBizTempSessionReq(this.context, bundle);
        }
        if (baseReq.getType() == 9) {
            return this.sendAddCardToWX(this.context, bundle);
        }
        if (baseReq.getType() == 16) {
            return this.sendChooseCardFromWX(this.context, bundle);
        }
        if (baseReq.getType() == 11) {
            return this.sendOpenRankListReq(this.context, bundle);
        }
        if (baseReq.getType() == 12) {
            return this.sendOpenWebview(this.context, bundle);
        }
        if (baseReq.getType() == 13) {
            return this.sendOpenBusiLuckyMoney(this.context, bundle);
        }
        if (baseReq.getType() == 14) {
            return this.createChatroom(this.context, bundle);
        }
        if (baseReq.getType() == 15) {
            return this.joinChatroom(this.context, bundle);
        }
        if (baseReq.getType() == 17) {
            return this.sendHandleScanResult(this.context, bundle);
        }
        if (baseReq.getType() == 18) {
            return this.sendSubscribeMessage(this.context, baseReq);
        }
        if (baseReq.getType() == 2 && bundle.getInt("_wxapi_sendmessagetowx_req_media_type") == 36) {
            object = (SendMessageToWX.Req)baseReq;
            if (this.getWXAppSupportAPI() < 620756993) {
                WXWebpageObject wXWebpageObject = new WXWebpageObject();
                new WXWebpageObject().webpageUrl = bundle.getString("_wxminiprogram_webpageurl");
                ((SendMessageToWX.Req)object).message.mediaObject = wXWebpageObject;
            } else {
                WXMiniProgramObject wXMiniProgramObject = (WXMiniProgramObject)((SendMessageToWX.Req)object).message.mediaObject;
                wXMiniProgramObject.userName = wXMiniProgramObject.userName + "@app";
                Object object2 = wXMiniProgramObject.path;
                if (!d.h((String)wXMiniProgramObject.path)) {
                    object2 = ((String[])(object2 = object2.split("\\?"))).length > 1 ? object2[0] + ".html?" + object2[1] : object2[0] + ".html";
                    wXMiniProgramObject.path = object2;
                }
            }
            ((SendMessageToWX.Req)object).scene = 0;
            baseReq.toBundle(bundle);
        }
        object = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        ((MMessageActV2.Args)object).content = "weixin://sendreq?appid=" + this.appId;
        ((MMessageActV2.Args)object).targetPkgName = "com.tencent.mm";
        ((MMessageActV2.Args)object).targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return MMessageActV2.send(this.context, (MMessageActV2.Args)object);
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new MMSharedPreferences(context).getString("_wxapp_pay_entry_classname_", null);
            com.tencent.mm.opensdk.utils.Log.d(TAG, "pay, set wxappPayEntryClassname = " + wxappPayEntryClassname);
            if (wxappPayEntryClassname == null) {
                try {
                    wxappPayEntryClassname = context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getString("com.tencent.mm.BuildInfo.OPEN_SDK_PAY_ENTRY_CLASSNAME", null);
                }
                catch (Exception exception) {
                    com.tencent.mm.opensdk.utils.Log.e(TAG, "get from metaData failed : " + exception.getMessage());
                }
            }
            if (wxappPayEntryClassname == null) {
                com.tencent.mm.opensdk.utils.Log.e(TAG, "pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        MMessageActV2.Args args = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        args.targetPkgName = "com.tencent.mm";
        args.targetClassName = wxappPayEntryClassname;
        return MMessageActV2.send(context, args);
    }

    private boolean sendJumpToBizProfileReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_profile_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_profile_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_scene"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_profile_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizWebviewReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_scene")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizTempSessionReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizTempSession");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_session_from"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_show_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendAddCardToWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/addCardToWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_add_card_to_wx_card_list"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendChooseCardFromWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/chooseCardFromWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{stringArray.getString("_wxapi_choose_card_from_wx_card_app_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_location_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_sign_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_sign"), stringArray.getString("_wxapi_choose_card_from_wx_card_time_stamp"), stringArray.getString("_wxapi_choose_card_from_wx_card_nonce_str"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_can_multi_select"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenRankListReq(Context context, Bundle bundle) {
        String[] stringArray;
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openRankList");
        if ((context = context.query((Uri)bundle, null, null, stringArray = new String[0], null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenWebview(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openWebview");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_webview_url"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusiLuckyMoney(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusiLuckyMoney");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_open_busi_lucky_money_timeStamp"), stringArray.getString("_wxapi_open_busi_lucky_money_nonceStr"), stringArray.getString("_wxapi_open_busi_lucky_money_signType"), stringArray.getString("_wxapi_open_busi_lucky_money_signature"), stringArray.getString("_wxapi_open_busi_lucky_money_package")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean createChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/createChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_create_chatroom_group_id", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_name", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_create_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean joinChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/joinChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_join_chatroom_group_id", ""), stringArray.getString("_wxapi_join_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_join_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendHandleScanResult(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/handleScanResult");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_scan_qrcode_result")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendSubscribeMessage(Context context, BaseReq stringArray) {
        stringArray = (SubscribeMessage.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = new String[]{this.appId, "1", String.valueOf(stringArray.scene), stringArray.templateID, stringArray.reserved};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    @Override
    public final boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        ((BaseResp)object).toBundle(bundle);
        object = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        ((MMessageActV2.Args)object).content = "weixin://sendresp?appid=" + this.appId;
        ((MMessageActV2.Args)object).targetPkgName = "com.tencent.mm";
        ((MMessageActV2.Args)object).targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return MMessageActV2.send(this.context, (MMessageActV2.Args)object);
    }

    @Override
    public final void detach() {
        com.tencent.mm.opensdk.utils.Log.d(TAG, "detach");
        this.detached = true;
        if (activityCb != null && Build.VERSION.SDK_INT >= 14) {
            if (this.context instanceof Activity) {
                ((Activity)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            } else if (this.context instanceof Service) {
                ((Service)this.context).getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)activityCb);
            }
            activityCb.detach();
        }
        this.context = null;
    }

    @Override
    public final void setLogImpl(ILog iLog) {
        com.tencent.mm.opensdk.utils.Log.setLogImpl(iLog);
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void initMta(Context context, String string) {
        string = "AWXOP" + string;
        StatConfig.setAppKey(context, string);
        StatConfig.setEnableSmartReporting(true);
        StatConfig.setStatSendStrategy(StatReportStrategy.PERIOD);
        StatConfig.setSendPeriodMinutes(60);
        StatConfig.setInstallChannel(context, "Wechat_Sdk");
        try {
            StatService.startStatService(context, string, "2.0.4");
            return;
        }
        catch (MtaSDkException mtaSDkException) {
            com.tencent.mm.opensdk.utils.Log.e(TAG, "initMta exception:" + mtaSDkException.getMessage());
            return;
        }
    }

    private static final class ActivityLifecycleCb
    implements Application.ActivityLifecycleCallbacks {
        private static final String TAG = "MicroMsg.SDK.WXApiImplV10.ActivityLifecycleCb";
        private static final int DELAYED = 800;
        private boolean isForeground = false;
        private Handler handler = new Handler(Looper.getMainLooper());
        private Context context;
        private Runnable onPausedRunnable = new Runnable(){

            @Override
            public void run() {
                if (activityCb != null && ActivityLifecycleCb.this.isForeground) {
                    Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onBackground");
                    StatService.trackCustomKVEvent(ActivityLifecycleCb.this.context, "onBackground_WX", null);
                    ActivityLifecycleCb.this.isForeground = false;
                }
            }
        };
        private Runnable onResumedRunnable = new Runnable(){

            @Override
            public void run() {
                if (activityCb != null && !ActivityLifecycleCb.this.isForeground) {
                    Log.v((String)ActivityLifecycleCb.TAG, (String)"WXStat trigger onForeground");
                    StatService.trackCustomKVEvent(ActivityLifecycleCb.this.context, "onForeground_WX", null);
                    ActivityLifecycleCb.this.isForeground = true;
                }
            }
        };

        private ActivityLifecycleCb(Context context) {
            this.context = context;
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
        }

        public final void onActivityDestroyed(Activity activity) {
        }

        public final void onActivityPaused(Activity activity) {
            Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityPaused"));
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.postDelayed(this.onPausedRunnable, 800L);
        }

        public final void onActivityResumed(Activity activity) {
            Log.v((String)TAG, (String)(activity.getComponentName().getClassName() + "  onActivityResumed"));
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.handler.postDelayed(this.onResumedRunnable, 800L);
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        }

        public final void onActivityStarted(Activity activity) {
        }

        public final void onActivityStopped(Activity activity) {
        }

        public final void detach() {
            this.handler.removeCallbacks(this.onResumedRunnable);
            this.handler.removeCallbacks(this.onPausedRunnable);
            this.context = null;
        }
    }
}

